/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import org.daypilot.data.AreaAction;
import org.daypilot.data.AreaVisibility;
import org.daypilot.json.JSONObject;

public class Area {
    private Integer _width;
    private Integer _height;
    private Integer _left;
    private Integer _right;
    private Integer _top;
    private Integer _bottom;
    private String _cssClass;
    private String _style;
    private String _id;
    private String _menu;
    private String _javaScript;
    private String _html;
    private String _symbol;
    private AreaAction _action = AreaAction.NONE;
    private AreaVisibility _visibility = AreaVisibility.HOVER;

    JSONObject getJSON() {
        JSONObject jSONObject = new JSONObject();
        if (this._width != null) {
            jSONObject.put("w", this._width);
        }
        if (this._height != null) {
            jSONObject.put("h", this._height);
        }
        if (this._right != null) {
            jSONObject.put("right", this._right);
        }
        if (this._top != null) {
            jSONObject.put("top", this._top);
        }
        if (this._left != null) {
            jSONObject.put("left", this._left);
        }
        if (this._bottom != null) {
            jSONObject.put("bottom", this._bottom);
        }
        if (this._cssClass != null) {
            jSONObject.put("css", this._cssClass);
        }
        if (this._html != null) {
            jSONObject.put("html", this._html);
        }
        if (this._id != null) {
            jSONObject.put("id", this._id);
        }
        if (this._menu != null) {
            jSONObject.put("menu", this._menu);
        }
        if (this._javaScript != null) {
            jSONObject.put("js", String.format("(function(e) {{ %s; }})", this._javaScript));
        }
        if (this._visibility != null) {
            jSONObject.put("v", this._visibility.toString());
        }
        if (this._style != null) {
            jSONObject.put("style", this._style);
        }
        if (this._symbol != null) {
            jSONObject.put("symbol", this._symbol);
        }
        jSONObject.put("action", this._action.toString());
        return jSONObject;
    }

    public Area width(int n) {
        this._width = n;
        return this;
    }

    public Area height(int n) {
        this._height = n;
        return this;
    }

    public Area left(int n) {
        this._left = n;
        return this;
    }

    public Area right(int n) {
        this._right = n;
        return this;
    }

    public Area top(int n) {
        this._top = n;
        return this;
    }

    public Area bottom(int n) {
        this._bottom = n;
        return this;
    }

    public Area cssClass(String string) {
        this._cssClass = string;
        return this;
    }

    public Area id(String string) {
        this._id = string;
        return this;
    }

    public Area contextMenu(String string) {
        this._action = AreaAction.CONTEXT_MENU;
        this._menu = string;
        return this;
    }

    public Area visibility(AreaVisibility areaVisibility) {
        this._visibility = areaVisibility;
        return this;
    }

    public Area visible() {
        this.visibility(AreaVisibility.VISIBLE);
        return this;
    }

    public Area bubble() {
        this._action = AreaAction.BUBBLE;
        return this;
    }

    public Area javaScript(String string) {
        this._action = AreaAction.JAVASCRIPT;
        this._javaScript = string;
        return this;
    }

    public Area html(String string) {
        this._html = string;
        return this;
    }

    public Area resizeEnd() {
        this._action = AreaAction.RESIZE_END;
        return this;
    }

    public Area resizeStart() {
        this._action = AreaAction.RESIZE_START;
        return this;
    }

    public Area style(String string) {
        this._style = string;
        return this;
    }

    public Area move() {
        this._action = AreaAction.MOVE;
        return this;
    }

    public Area symbol(String string) {
        this._symbol = string;
        return this;
    }
}

