/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.date;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.daypilot.date.DayOfWeek;
import org.daypilot.date.TimeSpan;

public class DateTime {
    public static final TimeZone UTC = new SimpleTimeZone(0, "UTC");
    protected long ticks;
    private TimeZone timeZone = UTC;
    public static final DateTime EMPTY = new DateTime(0L);
    public static final DateTime MAX = new DateTime("9999-01-01T00:00:00");
    public static final DateTime MIN = new DateTime("0001-01-01T00:00:00");

    public DateTime() {
        this.ticks = new Date().getTime();
    }

    public DateTime(long l) {
        this.ticks = l;
    }

    protected Calendar calendar() {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(this.ticks);
        return calendar;
    }

    public DateTime(Timestamp timestamp) {
        this(timestamp, false);
    }

    public DateTime(Timestamp timestamp, boolean bl) {
        this((Date)timestamp, bl);
    }

    public DateTime(Date date, boolean bl) {
        this();
        if (date == null) {
            return;
        }
        if (bl) {
            DateTime dateTime = new DateTime(date.getTime());
            this.ticks = dateTime.addMinutes(DateTime.getTimeZoneOffset(date)).getTicks();
        } else {
            this.ticks = date.getTime();
        }
    }

    private static int getTimeZoneOffset(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = (calendar.get(15) + calendar.get(16)) / 60000;
        return n;
    }

    public DateTime(Date date) {
        this(date, false);
    }

    public DateTime(String string) {
        this.fromString(string);
    }

    private void fromString(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
            simpleDateFormat.setTimeZone(this.timeZone);
            this.ticks = string.length() == 10 ? simpleDateFormat.parse(string + "T00:00:00").getTime() : simpleDateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public static DateTime fromDateLocal(Date date) {
        return new DateTime(date, true);
    }

    public DateTime(int n, int n2, int n3) {
        Calendar calendar = this.calendar();
        calendar.clear();
        calendar.set(n, n2 - 1, n3);
        this.ticks = calendar.getTimeInMillis();
    }

    public DateTime(long l, TimeZone timeZone) {
        this.ticks = l;
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
    }

    public String toStringSortable() {
        return this.toStringIso8601();
    }

    public String toStringIso8601() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
        simpleDateFormat.setTimeZone(this.timeZone);
        String string = simpleDateFormat.format(new Date(this.ticks));
        return string;
    }

    public String toString() {
        return this.toStringIso8601();
    }

    public String toString(String string) {
        return this.toString(string, Locale.getDefault());
    }

    public String toDateString(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        dateFormat.setTimeZone(this.timeZone);
        return dateFormat.format(this.calendar().getTime());
    }

    public String toDateTimeString(Locale locale) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        dateFormat.setTimeZone(this.timeZone);
        return dateFormat.format(this.calendar().getTime());
    }

    public String toString(String string, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
        simpleDateFormat.setTimeZone(this.timeZone);
        String string2 = simpleDateFormat.format(new Date(this.ticks));
        return string2;
    }

    public Timestamp toTimeStamp() {
        Timestamp timestamp = new Timestamp(this.ticks);
        return timestamp;
    }

    public DateTime addDays(int n) {
        return this.add(TimeSpan.fromDays(n));
    }

    public DateTime addMinutes(int n) {
        DateTime dateTime = this.add(TimeSpan.fromMinutes(n));
        return dateTime;
    }

    public static DateTime parseAsLocal(Object object) {
        return DateTime.parse(object, true);
    }

    public static DateTime parseString(String string) {
        DateTime dateTime = new DateTime();
        dateTime.fromString(string);
        return dateTime;
    }

    public static DateTime parse(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof DateTime) {
            return (DateTime)object;
        }
        if (object instanceof Date) {
            return new DateTime((Date)object, bl);
        }
        if (object instanceof Timestamp) {
            return new DateTime((Timestamp)object, bl);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            return new DateTime(string);
        }
        throw new RuntimeException("Unable to convert from " + object.getClass() + " to org.daypilot.date.DateTime");
    }

    public Date toDate() {
        return this.calendar().getTime();
    }

    public Date toDateLocal() {
        Date date = new Date();
        return this.addMinutes(date.getTimezoneOffset()).toDate();
    }

    public int getYear() {
        Calendar calendar = this.calendar();
        return calendar.get(1);
    }

    public int getMonth() {
        Calendar calendar = this.calendar();
        return calendar.get(2) + 1;
    }

    public int getDay() {
        Calendar calendar = this.calendar();
        return calendar.get(5);
    }

    public DateTime getDatePart() {
        Calendar calendar = this.calendar();
        calendar.clear();
        calendar.set(this.getYear(), this.getMonth() - 1, this.getDay());
        return new DateTime(calendar.getTime().getTime(), this.timeZone);
    }

    public DateTime add(TimeSpan timeSpan) {
        return new DateTime(this.ticks + timeSpan.getTotalMilliseconds(), this.timeZone);
    }

    public int getHour() {
        Calendar calendar = this.calendar();
        return calendar.get(11);
    }

    public DayOfWeek getDayOfWeek() {
        Calendar calendar = this.calendar();
        return DayOfWeek.fromConstant(calendar.get(7));
    }

    public int getDayOfWeekOrdinal() {
        Calendar calendar = this.calendar();
        int n = calendar.get(7);
        return n - 1;
    }

    public String toDateString() {
        return this.toStringSortable().substring(0, 10);
    }

    public static DateTime getToday() {
        return new DateTime().getDatePart();
    }

    public static DateTime today() {
        return new DateTime().getDatePart();
    }

    public int getDayOfYear() {
        Calendar calendar = this.calendar();
        return calendar.get(6);
    }

    public int getMinute() {
        Calendar calendar = this.calendar();
        return calendar.get(12);
    }

    public TimeSpan getTimeOfDay() {
        return new TimeSpan(this.ticks - this.getDatePart().getTicks());
    }

    public long getTicks() {
        return this.ticks;
    }

    public boolean before(DateTime dateTime) {
        return this.ticks < dateTime.ticks;
    }

    public DateTime addHours(int n) {
        Calendar calendar = this.calendar();
        calendar.add(10, n);
        return new DateTime(calendar.getTime().getTime(), this.timeZone);
    }

    public DateTime addMonths(int n) {
        Calendar calendar = this.calendar();
        calendar.add(2, n);
        return new DateTime(calendar.getTime().getTime(), this.timeZone);
    }

    public TimeSpan minus(DateTime dateTime) {
        return new TimeSpan(this.getTicks() - dateTime.getTicks());
    }

    public DateTime addYears(int n) {
        Calendar calendar = this.calendar();
        calendar.add(1, n);
        return new DateTime(calendar.getTime().getTime(), this.timeZone);
    }

    public boolean after(DateTime dateTime) {
        return this.getTicks() > dateTime.getTicks();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DateTime)) {
            return false;
        }
        return this.getTicks() == ((DateTime)object).getTicks();
    }

    public DateTime addSeconds(int n) {
        Calendar calendar = this.calendar();
        calendar.add(13, n);
        return new DateTime(calendar.getTime().getTime(), this.timeZone);
    }

    public boolean beforeOrEqual(DateTime dateTime) {
        return this.before(dateTime) || this.equals(dateTime);
    }

    public boolean afterOrEqual(DateTime dateTime) {
        return this.after(dateTime) || this.equals(dateTime);
    }

    public static boolean canParse(String string) {
        try {
            DateTime.parse(string, false);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isWeekend() {
        if (this.getDayOfWeek() == DayOfWeek.SATURDAY) {
            return true;
        }
        return this.getDayOfWeek() == DayOfWeek.SUNDAY;
    }

    public String getMonthName(DateTime dateTime, Locale locale) {
        return dateTime.toString("MMMM", locale);
    }

    public DateTime firstDayOfMonth() {
        return new DateTime(this.getYear(), this.getMonth(), 1);
    }

    public int getDaysOfMonth() {
        DateTime dateTime = this.firstDayOfMonth();
        DateTime dateTime2 = dateTime.addMonths(1);
        return (int)dateTime2.minus(dateTime).getTotalDays();
    }

    public int getDaysOfYear() {
        DateTime dateTime = this.firstDayOfYear().addYears(1);
        return (int)dateTime.minus(this.firstDayOfYear()).getTotalDays();
    }

    public DateTime firstDayOfYear() {
        return new DateTime(this.getYear(), 1, 1);
    }

    public int compareTo(DateTime dateTime) {
        return this.calendar().compareTo(dateTime.calendar());
    }

    public DateTime smaller(DateTime dateTime) {
        return this.before(dateTime) ? this : dateTime;
    }

    public DateTime bigger(DateTime dateTime) {
        return this.before(dateTime) ? dateTime : this;
    }

    public DateTime tz(TimeZone timeZone) {
        return new DateTime(this.ticks, timeZone);
    }

    public DateTime utc() {
        return this.tz(UTC);
    }

    public TimeZone getTimezone() {
        return this.timeZone;
    }

    public void setTimezone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new RuntimeException("Timezone cannot be null.");
        }
        this.timeZone = timeZone;
    }

    public DateTime addMilliSeconds(int n) {
        return new DateTime(this.ticks + (long)n, this.timeZone);
    }

    public static DateTime getToday(TimeZone timeZone) {
        DateTime dateTime = DateTime.getToday();
        int n = DateTime.safeTimeZone(timeZone).getOffset(dateTime.getTicks());
        return dateTime.addMilliSeconds(-n).tz(timeZone);
    }

    private static TimeZone safeTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            return UTC;
        }
        return timeZone;
    }

    public DateTime inZoneByName(TimeZone timeZone) {
        if (timeZone == null) {
            throw new RuntimeException("newZone parameter cannot be null");
        }
        int n = this.timeZone.getOffset(this.getTicks());
        DateTime dateTime = this.addMilliSeconds(n);
        n = timeZone.getOffset(this.getTicks());
        return dateTime.addMilliSeconds(-n).tz(timeZone);
    }
}

