/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.date;

import java.util.Calendar;
import java.util.Locale;

public enum DayOfWeek {
    SUNDAY,
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY;


    public static DayOfWeek getDefaultWeekStart() {
        return DayOfWeek.getDefaultWeekStart(Locale.getDefault());
    }

    public static DayOfWeek getDefaultWeekStart(Locale locale) {
        Calendar calendar = Calendar.getInstance(locale);
        return DayOfWeek.fromConstant(calendar.getFirstDayOfWeek());
    }

    public int toOrdinal() {
        switch (this.ordinal()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 0: {
                return 0;
            }
        }
        throw new RuntimeException("Unrecognized day constant value.");
    }

    public static DayOfWeek fromOrdinal(int n) {
        switch (n) {
            case 0: {
                return SUNDAY;
            }
            case 1: {
                return MONDAY;
            }
            case 2: {
                return TUESDAY;
            }
            case 3: {
                return WEDNESDAY;
            }
            case 4: {
                return THURSDAY;
            }
            case 5: {
                return FRIDAY;
            }
            case 6: {
                return SATURDAY;
            }
        }
        throw new RuntimeException("Unrecognized day constant value.");
    }

    public static DayOfWeek fromConstant(int n) {
        switch (n) {
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
            case 1: {
                return SUNDAY;
            }
        }
        throw new RuntimeException("Unrecognized day constant value.");
    }
}

