/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.date;

public class TimeSpan {
    private long ticks = 0L;
    private static final long TICKS_PER_DAY = 86400000L;
    private static final long TICKS_PER_HOUR = 3600000L;
    private static final long TICKS_PER_MINUTE = 60000L;
    private static final long TICKS_PER_SECOND = 1000L;

    public TimeSpan(long l) {
        this.ticks = l;
    }

    public static TimeSpan fromMinutes(int n) {
        return new TimeSpan((long)n * 60000L);
    }

    public static TimeSpan fromHours(int n) {
        return new TimeSpan((long)n * 3600000L);
    }

    public boolean isZero() {
        return this.ticks == 0L;
    }

    public double getTotalDays() {
        return (double)this.ticks / 8.64E7;
    }

    public long getDays() {
        return (long)Math.floor(this.getTotalDays());
    }

    public double getTotalHours() {
        return (double)this.ticks / 3600000.0;
    }

    public long getHours() {
        long l = this.ticks % 86400000L;
        return (long)Math.floor((double)l / 3600000.0);
    }

    public double getTotalMinutes() {
        return (double)this.ticks / 60000.0;
    }

    public long getMinutes() {
        long l = this.ticks % 3600000L;
        return (long)Math.floor((double)l / 60000.0);
    }

    public double getTotalSeconds() {
        return (double)this.ticks / 1000.0;
    }

    public long getSeconds() {
        long l = this.ticks % 60000L;
        return (long)Math.floor((double)l / 1000.0);
    }

    public long getTotalMilliseconds() {
        return this.ticks;
    }

    public long getMilliSeconds() {
        return this.ticks % 1000L;
    }

    public long getTicks() {
        return this.ticks;
    }

    public static TimeSpan fromDays(int n) {
        return new TimeSpan((long)n * 86400000L);
    }

    public TimeSpan add(TimeSpan timeSpan) {
        return new TimeSpan(this.ticks + timeSpan.ticks);
    }

    public String getDayHourMinuteString() {
        if (this.getHours() == 0L && this.getDays() == 0L) {
            return String.format("%dm", this.getMinutes());
        }
        if (this.getDays() == 0L) {
            return String.format("%dh %02dm", this.getHours(), this.getMinutes());
        }
        return String.format("%dd %dh %02dm", this.getDays(), this.getHours(), this.getMinutes());
    }

    public String getHourMinuteString() {
        int n = (int)this.getTotalHours();
        if (n == 0) {
            return String.format("%dm", this.getMinutes());
        }
        return String.format("%dh %02dm", n, this.getMinutes());
    }

    public String toString() {
        return String.format("%d:%02d:%02d:%02d", this.getDays(), this.getHours(), this.getMinutes(), this.getMinutes());
    }
}

