/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.recurrence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.date.TimeSpan;
import org.daypilot.recurrence.Occurrence;
import org.daypilot.recurrence.RecurEx;
import org.daypilot.recurrence.RecurInfo;
import org.daypilot.recurrence.RecurType;
import org.daypilot.recurrence.RecurrenceException;
import org.daypilot.recurrence.RecurrenceRule;

public class RecurEvent
extends RecurInfo {
    private DayOfWeek firstDayOfWeek = DayOfWeek.getDefaultWeekStart();
    private DateTime start;
    private DateTime end;
    private Map<String, RecurEx> exceptions = new HashMap<String, RecurEx>();
    private RecurrenceRule rule;
    private DateTime last = DateTime.MIN;

    private RecurEvent() {
        this.setType(RecurType.EVENT);
    }

    public static RecurEvent fromRule(RecurrenceRule recurrenceRule, DateTime dateTime, DateTime dateTime2, String string, Object object) {
        RecurEvent recurEvent = new RecurEvent();
        recurEvent.setTag(object);
        recurEvent.setStart(dateTime);
        recurEvent.setEnd(dateTime2);
        recurEvent.rule = recurrenceRule;
        if (!string.equals(recurEvent.rule.getId())) {
            throw new RecurrenceException("The recurrence info id doesn't correspond to event id.");
        }
        return recurEvent;
    }

    public static RecurEvent parseEvent(String string, DateTime dateTime, DateTime dateTime2, String string2, Object object) {
        if (string == null) {
            throw new RecurrenceException("Input not in correct format");
        }
        RecurEvent recurEvent = new RecurEvent();
        recurEvent.setTag(object);
        recurEvent.setStart(dateTime);
        recurEvent.setEnd(dateTime2);
        recurEvent.rule = RecurrenceRule.decode(string);
        if (!string2.equals(recurEvent.rule.getId())) {
            throw new RecurrenceException("The recurrence info id doesn't correspond to event id.");
        }
        return recurEvent;
    }

    private DateTime next() {
        DateTime dateTime = this.last.equals(DateTime.MIN) ? this.start : this.last;
        TimeSpan timeSpan = this.start.getTimeOfDay();
        dateTime = dateTime.getDatePart();
        switch (this.rule.getRepeat()) {
            case NONE: {
                throw new RecurrenceException("Can't get next occurrence for RepeatRule.None.");
            }
            case DAILY: {
                dateTime = dateTime.addDays(this.rule.getEvery());
                break;
            }
            case WEEKLY: {
                dateTime = this.nextWeekly(dateTime);
                break;
            }
            case MONTHLY: {
                dateTime = this.nextMonthly(dateTime);
                break;
            }
            case ANNUALLY: {
                dateTime = dateTime.addYears(this.rule.getEvery());
                break;
            }
            default: {
                throw new RecurrenceException("Unrecognized Repeat value.");
            }
        }
        this.last = dateTime = dateTime.add(timeSpan);
        return dateTime;
    }

    private DateTime nextWeekly(DateTime dateTime) {
        if (this.isLastThisWeek(dateTime)) {
            DateTime dateTime2 = dateTime.addDays(-this.dayOfWeekOffset(dateTime));
            dateTime2 = dateTime2.addDays(7 * this.rule.getEvery());
            return this.findNextDayOfWeek(dateTime2);
        }
        return this.findNextDayOfWeek(dateTime.addDays(1));
    }

    private DateTime nextMonthly(DateTime dateTime) {
        if (!this.isLastThisMonth(dateTime)) {
            return this.findNextDayOfMonth(dateTime.addDays(1));
        }
        DateTime dateTime2 = new DateTime(dateTime.getYear(), dateTime.getMonth(), 1);
        dateTime2 = this.rule.getNamed() == null ? dateTime2.addMonths(this.rule.getEvery()) : this.findNextMonth(dateTime2);
        dateTime2 = this.findNextDayOfMonth(dateTime2);
        return dateTime2;
    }

    private int dayOfWeekOffset(DateTime dateTime) {
        int n;
        int n2 = this.firstDayOfWeek.toOrdinal();
        if (n2 > (n = dateTime.getDayOfWeekOrdinal())) {
            n += 7;
        }
        return n - n2;
    }

    private boolean isLastThisWeek(DateTime dateTime) {
        boolean bl;
        List<DayOfWeek> list = this.getDaysOfWeek();
        int n = list.contains((Object)dateTime.getDayOfWeek()) ? list.indexOf((Object)dateTime.getDayOfWeek()) : -1;
        boolean bl2 = bl = n == list.size() - 1;
        return bl;
    }

    private boolean isLastThisMonth(DateTime dateTime) {
        boolean bl;
        List<Integer> list = this.getDaysOfMonth();
        int n = list.contains(dateTime.getDay()) ? list.indexOf(dateTime.getDay()) : -1;
        boolean bl2 = bl = n == list.size() - 1;
        return bl;
    }

    private DateTime findNextDayOfWeek(DateTime dateTime) {
        List<DayOfWeek> list = this.getDaysOfWeek();
        while (!list.contains((Object)dateTime.getDayOfWeek())) {
            dateTime = dateTime.addDays(1);
        }
        return dateTime;
    }

    private List<DayOfWeek> getDaysOfWeek() {
        ArrayList<DayOfWeek> arrayList = new ArrayList<DayOfWeek>();
        for (int i = 0; i < 7; ++i) {
            int n = (this.firstDayOfWeek.toOrdinal() + i) % 7;
            if (this.rule.getUnits() == null) {
                if (n != this.start.getDayOfWeekOrdinal()) continue;
                arrayList.add(DayOfWeek.fromOrdinal(n));
                continue;
            }
            if (!this.rule.getUnits().contains(n)) continue;
            arrayList.add(DayOfWeek.fromOrdinal(n));
        }
        return arrayList;
    }

    private DateTime findNextDayOfMonth(DateTime dateTime) {
        List<Integer> list = this.getDaysOfMonth();
        while (!list.contains(dateTime.getDay())) {
            dateTime = dateTime.addDays(1);
        }
        return dateTime;
    }

    private DateTime findNextMonth(DateTime dateTime) {
        List<Integer> list = this.getMonths();
        while (!list.contains(dateTime.getMonth())) {
            dateTime = dateTime.addMonths(1);
        }
        return dateTime;
    }

    private List<Integer> getMonths() {
        return this.rule.getNamed();
    }

    private List<Integer> getDaysOfMonth() {
        if (this.rule.getUnits() != null) {
            return this.rule.getUnits();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.start.getMonth());
        return arrayList;
    }

    public List<Occurrence> occurrences(DateTime dateTime) {
        Object object;
        Object object2;
        this.last = this.start;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.getStart());
        if (this.rule.getRangeSpec() == RecurrenceRule.RangeSpecType.Until) {
            object2 = dateTime.after(this.rule.getUntilValue()) ? this.rule.getUntilValue() : dateTime;
            object = this.next();
            while (((DateTime)object).before((DateTime)object2)) {
                arrayList.add(object);
                object = this.next();
            }
        } else {
            for (int i = 0; i < this.rule.getTimesValue() && !((DateTime)(object = this.next())).afterOrEqual(dateTime); ++i) {
                arrayList.add(object);
            }
        }
        object2 = new ArrayList();
        for (DateTime dateTime2 : arrayList) {
            if (!this.exceptions.containsKey(dateTime2.toStringIso8601())) {
                object2.add(Occurrence.fromDateTime(dateTime2, this));
                continue;
            }
            RecurEx recurEx = this.exceptions.get(dateTime2.toStringIso8601());
            if (recurEx.getType() == RecurType.DELETED || recurEx.getType() != RecurType.MODIFIED) continue;
            Occurrence occurrence = Occurrence.fromRecurex(recurEx);
            object2.add(occurrence);
        }
        return object2;
    }

    public void addRecurexSilent(RecurEx recurEx) {
        if (!recurEx.getMasterId().equals(this.rule.getId())) {
            return;
        }
        this.exceptions.put(recurEx.getStart().toStringIso8601(), recurEx);
    }

    public void addRecurex(RecurEx recurEx) {
        if (!recurEx.getMasterId().equals(this.rule.getId())) {
            throw new RecurrenceException("RecurEx not applicable to this RecurEvent.");
        }
        this.exceptions.put(recurEx.getStart().toStringIso8601(), recurEx);
    }

    public DateTime getStart() {
        return this.start;
    }

    public void setStart(DateTime dateTime) {
        this.start = dateTime;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public void setEnd(DateTime dateTime) {
        this.end = dateTime;
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(DayOfWeek dayOfWeek) {
        this.firstDayOfWeek = dayOfWeek;
    }

    private DateTime nextWithinRange(int n, DateTime dateTime) {
        this.last = dateTime;
        if (this.rule.getRangeSpec() == RecurrenceRule.RangeSpecType.Until) {
            if (dateTime.after(this.rule.getUntilValue())) {
                return null;
            }
            DateTime dateTime2 = this.next();
            if (dateTime2.after(this.rule.getUntilValue())) {
                return null;
            }
            return dateTime2;
        }
        if (n >= this.rule.getTimesValue()) {
            return null;
        }
        return this.next();
    }

    public DateTime next(int n, DateTime dateTime) {
        DateTime dateTime2 = this.nextWithinRange(n, dateTime);
        while (dateTime2 != null) {
            if (!this.exceptions.containsKey(dateTime2.toStringIso8601())) {
                return dateTime2;
            }
            RecurEx recurEx = this.exceptions.get(dateTime2.toStringIso8601());
            if (recurEx.getType() == RecurType.MODIFIED) {
                return recurEx.getStart();
            }
            if (recurEx.getType() == RecurType.DELETED) {
                dateTime2 = this.nextWithinRange(n, dateTime);
                continue;
            }
            throw new RecurrenceException("Unexpected recurrence exception type.");
        }
        return null;
    }
}

