/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.daypilot.data.Column;
import org.daypilot.data.Task;
import org.daypilot.data.TimeHeaderCell;
import org.daypilot.date.DateTime;
import org.daypilot.date.TimeSpan;
import org.daypilot.json.JSONObject;
import org.daypilot.ui.CellTableCell;
import org.daypilot.ui.Day;
import org.daypilot.ui.DayPilotCalendar;
import org.daypilot.ui.DayPilotGantt;
import org.daypilot.ui.DayPilotScheduler;
import org.daypilot.ui.enums.ViewType;
import org.daypilot.util.Base64;
import org.daypilot.util.Str;

class CellTable {
    private Map<Integer, String> firstLine;
    private boolean dirty = false;
    private Object[] colors = null;
    private int yMax;
    private int xMax;
    private DayPilotScheduler scheduler;
    private DayPilotCalendar calendar;
    private DayPilotGantt gantt;
    private List<Task> ganttTasksFlat;
    private Map<String, Map> properties = new HashMap<String, Map>();
    private Map<String, Map> _optimized;
    private String _defaultHash;
    private Map _defaultValue;
    private boolean _vertically = false;
    private boolean _horizontally = false;

    CellTable(DayPilotScheduler dayPilotScheduler) {
        this.scheduler = dayPilotScheduler;
    }

    CellTable(DayPilotCalendar dayPilotCalendar) {
        this.calendar = dayPilotCalendar;
    }

    CellTable(DayPilotGantt dayPilotGantt) {
        this.gantt = dayPilotGantt;
    }

    private void prepareYMax() {
        if (this.scheduler != null) {
            this.yMax = this.scheduler.getRowCount();
            return;
        }
        if (this.gantt != null) {
            this.yMax = this.gantt.getTasks().getTotalCount();
            return;
        }
        if (this.calendar != null) {
            this.yMax = (int)Math.floor(this.calendar.duration().getTotalMinutes() / (double)this.calendar.getCellDuration());
            return;
        }
        throw new RuntimeException("Unable to get YMax");
    }

    private void prepareXMax() {
        if (this.scheduler != null) {
            this.xMax = this.scheduler.getTimeHeader().getTimeline().size();
            return;
        }
        if (this.gantt != null) {
            this.xMax = this.gantt.timeHeader.getTimeline().size();
            return;
        }
        if (this.calendar != null) {
            this.xMax = this.calendar.getColumnCount();
            return;
        }
        throw new RuntimeException("Unable to get XMax");
    }

    private Task findTaskByIndex(int n) {
        if (this.ganttTasksFlat != null && n < this.ganttTasksFlat.size()) {
            return this.ganttTasksFlat.get(n);
        }
        return null;
    }

    private CellTableCell getCell(int n, int n2) {
        if (this.scheduler != null) {
            Day day = this.scheduler.getRow(n2);
            DateTime dateTime = ((TimeHeaderCell)this.scheduler.getTimeHeader().getTimeline().get(n)).getStart();
            DateTime dateTime2 = ((TimeHeaderCell)this.scheduler.getTimeHeader().getTimeline().get(n)).getEnd();
            if (this.scheduler.getViewType() == ViewType.DAYS) {
                dateTime = dateTime.addDays(n2);
            }
            return this.scheduler.getCell(dateTime, dateTime2, day.getValue());
        }
        if (this.gantt != null) {
            Task task = this.findTaskByIndex(n2);
            DateTime dateTime = ((TimeHeaderCell)this.gantt.timeHeader.getTimeline().get(n)).getStart();
            DateTime dateTime3 = ((TimeHeaderCell)this.gantt.timeHeader.getTimeline().get(n)).getEnd();
            return this.gantt.getCell(dateTime, dateTime3, task.getId());
        }
        if (this.calendar != null) {
            TimeSpan timeSpan = this.calendar.getVisibleStart().getTimeOfDay();
            Column column = this.calendar.getColumn(n);
            DateTime dateTime = column.getDate();
            DateTime dateTime4 = new DateTime(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay()).add(timeSpan).addMinutes(n2 * this.calendar.getCellDuration());
            String string = column.getValue();
            return this.calendar.getCell(dateTime4, string);
        }
        throw new RuntimeException("Unable to GetCell");
    }

    private void prepareGantt() {
        if (this.gantt != null) {
            this.ganttTasksFlat = this.gantt.getTasksFlat();
        }
    }

    void process() {
        this.prepareYMax();
        this.prepareXMax();
        this.prepareGantt();
        this.colors = new Object[this.yMax];
        this.firstLine = new HashMap<Integer, String>();
        for (int i = 0; i < this.yMax; ++i) {
            this.colors[i] = new String[this.xMax];
            for (int j = 0; j < this.xMax; ++j) {
                String string;
                String string2;
                CellTableCell cellTableCell = this.getCell(j, i);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                if (!Str.isNullOrEmpty(cellTableCell.getInnerHTML())) {
                    hashMap.put("html", cellTableCell.getInnerHTML());
                }
                if (!Str.isNullOrEmpty(cellTableCell.getCssClass())) {
                    hashMap.put("cssClass", cellTableCell.getCssClass());
                }
                if (!Str.isNullOrEmpty(cellTableCell.getBackgroundImage())) {
                    hashMap.put("backImage", cellTableCell.getBackgroundImage());
                }
                if (!Str.isNullOrEmpty(cellTableCell.getBackgroundRepeat())) {
                    hashMap.put("backRepeat", cellTableCell.getBackgroundRepeat());
                }
                if (!Str.isNullOrEmpty(cellTableCell.getBackgroundColor())) {
                    hashMap.put("backColor", cellTableCell.getBackgroundColor());
                }
                hashMap.put("business", cellTableCell.isBusiness() ? 1 : 0);
                if (hashMap.keySet().size() > 0) {
                    string2 = j + "_" + i;
                    this.properties.put(string2, hashMap);
                    this.dirty = true;
                }
                ((String[])this.colors[i])[j] = cellTableCell.getColor();
                if (i == 0) {
                    this.firstLine.put(j, cellTableCell.getColor());
                    continue;
                }
                string2 = this.firstLine.get(j);
                if (Str.equalWithNullsIgnoreCase(string2, string = cellTableCell.getColor())) continue;
                this.dirty = true;
            }
        }
        this.optimize();
    }

    private void optimize() {
        this.findDefaultValue();
        this._vertically = this.isVerticallyIdentical();
        this._horizontally = this.isHorizontallyIdentical();
        this._optimized = new HashMap<String, Map>();
        for (Map.Entry<String, Map> entry : this.properties.entrySet()) {
            if (this._defaultValue != null && this.jsonHash(entry.getValue()).equals(this._defaultHash) || this._vertically && !entry.getKey().endsWith("_0") || this._horizontally && !entry.getKey().startsWith("0_")) continue;
            this._optimized.put(entry.getKey(), entry.getValue());
        }
    }

    private String jsonHash(Map map) {
        try {
            if (map == null) {
                return null;
            }
            byte[] byArray = new JSONObject(map).toString().getBytes("ASCII");
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            return Base64.encodeBytes(messageDigest.digest(byArray));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void findDefaultValue() {
        if (this.properties.size() == this.yMax * this.xMax) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (Map object : this.properties.values()) {
                String string = this.jsonHash(object);
                if (hashMap.containsKey(string)) {
                    hashMap.put(string, (Integer)hashMap.get(string) + 1);
                    continue;
                }
                hashMap.put(string, 0);
            }
            int n = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                if ((Integer)entry.getValue() <= n) continue;
                this._defaultHash = (String)entry.getKey();
                n = (Integer)entry.getValue();
            }
            this._defaultValue = this.PropsByHash(this._defaultHash);
        }
    }

    private boolean isVerticallyIdentical() {
        for (int i = 0; i < this.xMax; ++i) {
            String string = this.properties.containsKey(i + "_0") ? this.jsonHash(this.properties.get(i + "_0")) : null;
            for (int j = 0; j < this.yMax; ++j) {
                String string2;
                String string3 = string2 = this.properties.containsKey(i + "_" + j) ? this.jsonHash(this.properties.get(i + "_" + j)) : null;
                if (string2 == string) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isHorizontallyIdentical() {
        for (int i = 0; i < this.yMax; ++i) {
            String string = this.properties.containsKey("0_" + i) ? this.jsonHash(this.properties.get("0_" + i)) : null;
            for (int j = 0; j < this.xMax; ++j) {
                String string2;
                String string3 = string2 = this.properties.containsKey(j + "_" + i) ? this.jsonHash(this.properties.get(j + "_" + i)) : null;
                if (string2 == string) continue;
                return false;
            }
        }
        return true;
    }

    public Hashtable getConfig() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this._defaultValue != null) {
            hashtable.put("default", this._defaultValue);
        }
        hashtable.put("vertical", this._vertically);
        hashtable.put("horizontal", this._horizontally);
        hashtable.put("x", this.xMax);
        hashtable.put("y", this.yMax);
        return hashtable;
    }

    private Map PropsByHash(String string) {
        for (Map map : this.properties.values()) {
            if (!this.jsonHash(map).equals(string)) continue;
            return map;
        }
        return null;
    }

    boolean getDirty() {
        return this.dirty;
    }

    Map<String, Map> getProperties() {
        return this._optimized;
    }
}

