/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.util.Locale;
import java.util.TimeZone;
import org.daypilot.data.TimeCellCollection;
import org.daypilot.data.TimeHeaderCollection;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.ui.DayPilotGantt;
import org.daypilot.ui.ITimeHeaderParent;
import org.daypilot.ui.args.gantt.IncludeCellArgs;
import org.daypilot.ui.args.scheduler.BeforeTimeHeaderRenderArgs;
import org.daypilot.ui.enums.CellWidthSpec;
import org.daypilot.ui.enums.GroupBy;
import org.daypilot.ui.enums.TimeFormat;
import org.daypilot.ui.enums.TimeScale;

class GanttTimeHeaderParent
implements ITimeHeaderParent {
    private DayPilotGantt gantt;

    public GanttTimeHeaderParent(DayPilotGantt dayPilotGantt) {
        this.gantt = dayPilotGantt;
    }

    @Override
    public DateTime getVisibleStart() {
        return this.gantt.getVisibleStart();
    }

    @Override
    public boolean isDaysMode() {
        return false;
    }

    @Override
    public DateTime getVisibleEnd() {
        return this.gantt.getVisibleEnd();
    }

    @Override
    public DateTime getStartDate() {
        return this.gantt.getStartDate();
    }

    @Override
    public TimeHeaderCollection getTimeHeadersResolved() {
        return this.gantt.getTimeHeaders();
    }

    @Override
    public GroupBy getCellGroupBy() {
        return this.gantt.getCellGroupBy();
    }

    @Override
    public String getHourNameBackColor() {
        return null;
    }

    @Override
    public boolean getShowNonBusiness() {
        return this.gantt.isShowNonBusiness();
    }

    @Override
    public int getBusinessBeginsHour() {
        return this.gantt.getBusinessBeginsHour();
    }

    @Override
    public int getBusinessEndsHour() {
        return this.gantt.getBusinessEndsHour();
    }

    @Override
    public DayOfWeek getResolvedWeekStart() {
        return this.gantt.getResolvedWeekStart();
    }

    @Override
    public TimeFormat getTimeFormat() {
        return this.gantt.getTimeFormat();
    }

    @Override
    public TimeScale getScale() {
        return this.gantt.getScale();
    }

    @Override
    public TimeCellCollection getTimeline() {
        return this.gantt.getTimeline();
    }

    @Override
    public int getCellWidth() {
        return this.gantt.getCellWidth();
    }

    @Override
    public DateTime getEndDate() {
        return this.gantt.getEndDate();
    }

    @Override
    public int getCellDuration() {
        return this.gantt.getCellDuration();
    }

    @Override
    public boolean getFixedCellWidth() {
        return this.gantt.getCellWidthSpec() == CellWidthSpec.FIXED;
    }

    @Override
    public void doBeforeTimeHeaderRender(BeforeTimeHeaderRenderArgs beforeTimeHeaderRenderArgs) {
        try {
            org.daypilot.ui.args.gantt.BeforeTimeHeaderRenderArgs beforeTimeHeaderRenderArgs2 = org.daypilot.ui.args.gantt.BeforeTimeHeaderRenderArgs.fromCell(beforeTimeHeaderRenderArgs.getCell());
            this.gantt.onBeforeTimeHeaderRender(beforeTimeHeaderRenderArgs2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean doIncludeCell(DateTime dateTime, DateTime dateTime2, boolean bl) {
        IncludeCellArgs includeCellArgs = new IncludeCellArgs();
        includeCellArgs.setStart(dateTime);
        includeCellArgs.setEnd(dateTime2);
        includeCellArgs.setVisible(bl);
        this.gantt.doIncludeCell(includeCellArgs);
        return includeCellArgs.isVisible();
    }

    @Override
    public Locale getLocale() {
        return this.gantt.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.gantt.getTimeZone();
    }
}

