/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.util.Locale;
import java.util.TimeZone;
import org.daypilot.data.TimeCellCollection;
import org.daypilot.data.TimeHeaderCollection;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.ui.DayPilotScheduler;
import org.daypilot.ui.ITimeHeaderParent;
import org.daypilot.ui.args.scheduler.BeforeTimeHeaderRenderArgs;
import org.daypilot.ui.args.scheduler.IncludeCellArgs;
import org.daypilot.ui.enums.CellWidthSpec;
import org.daypilot.ui.enums.GroupBy;
import org.daypilot.ui.enums.TimeFormat;
import org.daypilot.ui.enums.TimeScale;
import org.daypilot.ui.enums.ViewType;

class SchedulerTimeHeaderParent
implements ITimeHeaderParent {
    private DayPilotScheduler scheduler;

    public SchedulerTimeHeaderParent(DayPilotScheduler dayPilotScheduler) {
        this.scheduler = dayPilotScheduler;
    }

    @Override
    public DateTime getVisibleStart() {
        return this.scheduler.getVisibleStart();
    }

    @Override
    public boolean isDaysMode() {
        return this.scheduler.getViewType() == ViewType.DAYS;
    }

    @Override
    public DateTime getVisibleEnd() {
        return this.scheduler.getVisibleEnd();
    }

    @Override
    public DateTime getStartDate() {
        return this.scheduler.getStartDate();
    }

    @Override
    public TimeHeaderCollection getTimeHeadersResolved() {
        return this.scheduler.getTimeHeadersResolved();
    }

    @Override
    public GroupBy getCellGroupBy() {
        return this.scheduler.getCellGroupBy();
    }

    @Override
    public String getHourNameBackColor() {
        return this.scheduler.getHourNameBackColor();
    }

    @Override
    public boolean getShowNonBusiness() {
        return this.scheduler.isShowNonBusiness();
    }

    @Override
    public int getBusinessBeginsHour() {
        return this.scheduler.getBusinessBeginsHour();
    }

    @Override
    public int getBusinessEndsHour() {
        return this.scheduler.getBusinessEndsHour();
    }

    @Override
    public DayOfWeek getResolvedWeekStart() {
        return this.scheduler.getResolvedWeekStart();
    }

    @Override
    public TimeFormat getTimeFormat() {
        return this.scheduler.getTimeFormat();
    }

    @Override
    public TimeScale getScale() {
        return this.scheduler.getScale();
    }

    @Override
    public TimeCellCollection getTimeline() {
        return this.scheduler.getTimeline();
    }

    @Override
    public int getCellWidth() {
        return this.scheduler.getCellWidth();
    }

    @Override
    public DateTime getEndDate() {
        return this.scheduler.getEndDate();
    }

    @Override
    public int getCellDuration() {
        return this.scheduler.getCellDuration();
    }

    @Override
    public boolean getFixedCellWidth() {
        return this.scheduler.getCellWidthSpec() == CellWidthSpec.FIXED;
    }

    @Override
    public void doBeforeTimeHeaderRender(BeforeTimeHeaderRenderArgs beforeTimeHeaderRenderArgs) {
        try {
            this.scheduler.onBeforeTimeHeaderRender(beforeTimeHeaderRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean doIncludeCell(DateTime dateTime, DateTime dateTime2, boolean bl) {
        IncludeCellArgs includeCellArgs = new IncludeCellArgs();
        includeCellArgs.setStart(dateTime);
        includeCellArgs.setEnd(dateTime2);
        includeCellArgs.setVisible(bl);
        this.scheduler.doIncludeCell(includeCellArgs);
        return includeCellArgs.isVisible();
    }

    @Override
    public Locale getLocale() {
        return this.scheduler.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.scheduler.getTimeZone();
    }
}

