/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.args.calendar;

import org.daypilot.data.TagCollection;
import org.daypilot.date.DateTime;
import org.daypilot.json.JSONObject;
import org.daypilot.ui.args.common.DayPilotArgs;

public class EventActionArgs
extends DayPilotArgs {
    private String id;
    private String text;
    private DateTime start;
    private DateTime end;
    private String resource;
    private boolean allDay;
    private TagCollection tags;
    private String recurrentMasterId;

    protected EventActionArgs() {
    }

    public void loadEvent(JSONObject jSONObject) {
        this.id = jSONObject.isNull("id") ? null : jSONObject.getString("id");
        this.text = jSONObject.getString("text");
        this.start = jSONObject.getDateTime("start");
        this.end = jSONObject.getDateTime("end");
        this.resource = jSONObject.optString("resource");
        this.allDay = jSONObject.getBoolean("isAllDay");
        this.tags = TagCollection.fromJSON(jSONObject.getJSONObject("tag"));
        this.recurrentMasterId = jSONObject.isNull("recurrentMasterId") ? null : jSONObject.getString("recurrentMasterId");
    }

    @Deprecated
    public String getValue() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public TagCollection getTags() {
        return this.tags;
    }

    @Override
    protected void setData(JSONObject jSONObject) {
        this.data = jSONObject;
    }

    public boolean isRecurrent() {
        return this.recurrentMasterId != null;
    }

    public String getRecurrentMasterId() {
        return this.recurrentMasterId;
    }

    public boolean isRecurrentException() {
        return this.isRecurrent() && this.id != null;
    }
}

