/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.enums;

import java.util.Calendar;
import java.util.Locale;
import org.daypilot.util.Str;

public enum WeekStarts {
    SUNDAY,
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    AUTO;


    public static WeekStarts fromStringJavaScript(String string) {
        if ("Auto".equals(string)) {
            return AUTO;
        }
        if (Str.isNullOrEmpty(string)) {
            return AUTO;
        }
        int n = Integer.parseInt(string);
        switch (n) {
            case 0: {
                return SUNDAY;
            }
            case 1: {
                return MONDAY;
            }
            case 2: {
                return TUESDAY;
            }
            case 3: {
                return WEDNESDAY;
            }
            case 4: {
                return THURSDAY;
            }
            case 5: {
                return FRIDAY;
            }
            case 6: {
                return SATURDAY;
            }
        }
        throw new IllegalArgumentException("Unable to map int value to WeekStarts enum.");
    }

    public static WeekStarts fromConstant(int n) {
        switch (n) {
            case 1: {
                return SUNDAY;
            }
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
        }
        throw new IllegalArgumentException("Unable to map int value to WeekStarts enum.");
    }

    public int toInt() {
        switch (this.ordinal()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unknown WeekStarts value.");
    }

    public WeekStarts resolve(Locale locale) {
        if (this == AUTO) {
            int n = Calendar.getInstance(locale).getFirstDayOfWeek();
            return WeekStarts.fromConstant(n);
        }
        return this;
    }
}

