/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import java.util.ArrayList;
import java.util.List;
import org.daypilot.data.ColumnCollection;
import org.daypilot.date.DateTime;
import org.daypilot.json.JSONObject;

public class Column {
    private String value;
    private String name;
    private DateTime date = DateTime.EMPTY;
    private String toolTip;
    private ColumnCollection children = new ColumnCollection();
    private static Column EMPTY = new Column();

    public Column() {
    }

    public Column(String string, String string2) {
        this.value = string2;
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime dateTime) {
        this.date = dateTime;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String string) {
        this.toolTip = string;
    }

    public ColumnCollection getChildren() {
        return this.children;
    }

    public List<Column> getChildren(int n, boolean bl) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        if (n <= 1) {
            arrayList.add(this);
            return arrayList;
        }
        if (this.children.isEmpty()) {
            if (bl) {
                arrayList.add(this);
            } else {
                arrayList.add(EMPTY);
            }
            return arrayList;
        }
        for (Column column : this.children) {
            List<Column> list = column.getChildren(n - 1, bl);
            for (Column column2 : list) {
                arrayList.add(column2);
            }
        }
        return arrayList;
    }

    public JSONObject getJSON() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("Value", this.value);
            jSONObject.put("Name", this.name);
            jSONObject.put("Date", this.date.toStringSortable());
            jSONObject.put("ToolTip", this.toolTip);
            jSONObject.put("Children", this.children.getJSON());
            return jSONObject;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Column fromJSON(JSONObject jSONObject) {
        try {
            Column column = new Column();
            column.setName(jSONObject.optString("Name"));
            column.setToolTip(jSONObject.optString("ToolTip"));
            column.setValue(jSONObject.optString("Value"));
            column.setDate(jSONObject.optDateTime("Date"));
            column.getChildren().restoreFromJSON(jSONObject.getJSONArray("Children"));
            return column;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

