/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import org.daypilot.json.JSONObject;
import org.daypilot.ui.enums.gantt.LinkType;

public class Link {
    private String id;
    private LinkType type = LinkType.FINISH_TO_START;
    private String from;
    private String to;
    private Object dataItem;

    public Link() {
    }

    public Link(String string, String string2) {
        this.from = string;
        this.to = string2;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.id);
        jSONObject.put("from", this.from);
        jSONObject.put("to", this.to);
        jSONObject.put("type", this.type.toString());
        return jSONObject;
    }

    public static Link fromJSON(JSONObject jSONObject) {
        try {
            Link link = new Link();
            link.id = jSONObject.optString("id");
            link.from = jSONObject.getString("from");
            link.to = jSONObject.getString("to");
            link.type = LinkType.fromString(jSONObject.getString("type"));
            return link;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public LinkType getType() {
        return this.type;
    }

    public void setType(LinkType linkType) {
        this.type = linkType;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String string) {
        this.to = string;
    }

    public Object getDataItem() {
        return this.dataItem;
    }

    public void setDataItem(Object object) {
        this.dataItem = object;
    }
}

