/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import java.util.ArrayList;
import org.daypilot.data.Resource;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONObject;

public class ResourceCollection
extends ArrayList<Resource> {
    private static final long serialVersionUID = 2855600073458457731L;

    public Resource add(String string, String string2) {
        Resource resource = new Resource(string, string2);
        this.add(resource);
        return resource;
    }

    public void restoreFromJSON(JSONArray jSONArray) {
        try {
            this.clear();
            if (jSONArray == null) {
                return;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                this.add(Resource.fromJSON(jSONObject));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Resource findByIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative index not allowed.");
        }
        Position position = new Position();
        return this.findByIndex(position, n);
    }

    private Resource findByIndex(Position position, int n) {
        for (Resource resource : this) {
            if (position.is(n)) {
                return resource;
            }
            position.inc();
            Resource resource2 = resource.getChildren().findByIndex(position, n);
            if (resource2 == null) continue;
            return resource2;
        }
        return null;
    }

    public Resource findById(String string) {
        if (string == null) {
            return null;
        }
        for (Resource resource : this) {
            if (string.equals(resource.getValue())) {
                return resource;
            }
            Resource resource2 = resource.getChildren().findById(string);
            if (resource2 == null) continue;
            return resource2;
        }
        return null;
    }

    public ResourceCollection findParentCollection(Resource resource) {
        Resource resource2 = this.findParent(resource);
        if (resource2 == Resource.ROOT) {
            return this;
        }
        return resource2.getChildren();
    }

    public Resource findParent(Resource resource) {
        return this.findParent(resource, Resource.ROOT);
    }

    private Resource findParent(Resource resource, Resource resource2) {
        for (Resource resource3 : this) {
            if (resource3 == resource) {
                return resource2;
            }
            Resource resource4 = resource3.getChildren().findParent(resource, resource3);
            if (resource4 == null) continue;
            return resource4;
        }
        return null;
    }

    class Position {
        private int i = 0;

        Position() {
        }

        void inc() {
            ++this.i;
        }

        boolean is(int n) {
            return this.i == n;
        }
    }
}

