/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONObject;

public class TagCollection {
    private List<String> fields = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();

    public TagCollection(String[] stringArray, JSONArray jSONArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.fields.add(stringArray[i]);
            this.values.add(jSONArray.getString(i));
        }
    }

    public TagCollection(JSONObject jSONObject) {
        String[] stringArray = JSONObject.getNames(jSONObject);
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.fields.add(string);
            this.values.add(jSONObject.getString(string));
        }
    }

    public TagCollection(String[] stringArray, String[] stringArray2) {
        for (String string : stringArray) {
            this.fields.add(string);
        }
        for (String string : stringArray2) {
            this.values.add(string);
        }
    }

    private TagCollection() {
    }

    public String get(int n) {
        return this.values.get(n);
    }

    public String get(String string) {
        int n = this.getIndex(string);
        if (n == -1) {
            return null;
        }
        return this.values.get(n);
    }

    private int getIndex(String string) {
        int n = this.fields.indexOf(string);
        return n;
    }

    public static TagCollection fromJSON(JSONObject jSONObject) {
        TagCollection tagCollection = new TagCollection();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            tagCollection.fields.add(string);
            tagCollection.values.add(jSONObject.getString(string));
        }
        return tagCollection;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        for (int i = 0; i < this.fields.size(); ++i) {
            String string = this.fields.get(i);
            String string2 = this.values.get(i);
            jSONObject.put(string, string2);
        }
        return jSONObject;
    }
}

