/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import org.daypilot.data.TaskCollection;
import org.daypilot.data.TaskTagMap;
import org.daypilot.date.DateTime;
import org.daypilot.json.JSONObject;
import org.daypilot.ui.enums.gantt.TaskType;
import org.daypilot.util.Str;

public class Task {
    public static final Task ROOT = new Task();
    private String id;
    private String text;
    private DateTime start;
    private DateTime end;
    private TaskType type = TaskType.TASK;
    private TaskTagMap tags = new TaskTagMap();
    private int complete;
    private TaskCollection children = new TaskCollection();
    private boolean expanded = false;
    private boolean dynamicChildren = false;
    private Object dataItem;

    public Task() {
    }

    public Task(String string, String string2, DateTime dateTime, DateTime dateTime2) {
        this.id = string2;
        this.text = string;
        this.start = dateTime;
        this.end = dateTime2;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("id", this.id);
        jSONObject2.put("text", this.text);
        jSONObject2.put("start", this.start.toString());
        jSONObject2.put("end", this.end.toString());
        if (this.type != TaskType.TASK) {
            jSONObject2.put("type", this.type.toString());
        }
        if (this.complete > 0) {
            jSONObject2.put("complete", this.complete);
        }
        if ((jSONObject = this.tags.toJSON()).length() > 0) {
            jSONObject2.put("tags", jSONObject);
        }
        return jSONObject2;
    }

    public JSONObject toJSONIncludeChildren() {
        JSONObject jSONObject = this.toJSON();
        if (this.children.size() > 0) {
            jSONObject.put("children", this.children.toJSON());
        }
        return jSONObject;
    }

    public static Task fromJSON(JSONObject jSONObject) {
        try {
            String string;
            Task task = new Task();
            task.text = jSONObject.getString("text");
            task.id = jSONObject.getString("id");
            task.start = jSONObject.getDateTime("start");
            task.end = jSONObject.getDateTime("end");
            if (!jSONObject.isNull("complete")) {
                task.complete = jSONObject.getInt("complete");
            }
            if (Str.isNullOrEmpty(string = jSONObject.optString("type"))) {
                string = "Task";
            }
            task.type = TaskType.fromString(string);
            if (!jSONObject.isNull("expanded")) {
                task.expanded = jSONObject.getBoolean("expanded");
            }
            task.dynamicChildren = jSONObject.isNull("loaded") ? true : !jSONObject.getBoolean("loaded");
            task.tags.restoreFromJSON(jSONObject.getJSONObject("tags"));
            task.children.restoreFromJSON(jSONObject.getJSONArray("children"));
            return task;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public TaskCollection getChildren() {
        return this.children;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public DateTime getStart() {
        return this.start;
    }

    public void setStart(DateTime dateTime) {
        this.start = dateTime;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public void setEnd(DateTime dateTime) {
        this.end = dateTime;
    }

    public TaskType getType() {
        return this.type;
    }

    public void setType(TaskType taskType) {
        if (taskType == TaskType.GROUP) {
            throw new RuntimeException("Task.Type cannot be set to TaskType.GROUP directly. Use TaskType.TASK and specify children.");
        }
        this.type = taskType;
    }

    public TaskTagMap getTags() {
        return this.tags;
    }

    public int getComplete() {
        return this.complete;
    }

    public void setComplete(int n) {
        this.complete = n;
    }

    public boolean isDynamicChildren() {
        return this.dynamicChildren;
    }

    public void setDynamicChildren(boolean bl) {
        this.dynamicChildren = bl;
    }

    public void setChildren(TaskCollection taskCollection) {
        this.children = taskCollection;
    }

    public Object getDataItem() {
        return this.dataItem;
    }

    public void setDataItem(Object object) {
        this.dataItem = object;
    }

    public StartEnd getChildrenStartEnd() {
        StartEnd startEnd = new StartEnd();
        if (this.children.size() == 0) {
            startEnd.start = this.start;
            startEnd.end = this.end;
            if (this.type == TaskType.MILESTONE) {
                startEnd.end = this.start;
            }
            return startEnd;
        }
        for (Task task : this.children) {
            StartEnd startEnd2 = task.getChildrenStartEnd();
            if (startEnd.start == null || startEnd2.start.before(this.start)) {
                startEnd.start = startEnd2.start;
            }
            if (startEnd.end != null && !startEnd2.end.after(this.end)) continue;
            startEnd.end = startEnd2.end;
        }
        return startEnd;
    }

    public class StartEnd {
        private DateTime start;
        private DateTime end;

        public DateTime getStart() {
            return this.start;
        }

        public void setStart(DateTime dateTime) {
            this.start = dateTime;
        }

        public DateTime getEnd() {
            return this.end;
        }

        public void setEnd(DateTime dateTime) {
            this.end = dateTime;
        }
    }
}

