/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import java.util.ArrayList;
import org.daypilot.data.Task;
import org.daypilot.date.DateTime;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONObject;

public class TaskCollection
extends ArrayList<Task> {
    private static final long serialVersionUID = -3197334728738133375L;

    public Task add(String string, String string2, DateTime dateTime, DateTime dateTime2) {
        Task task = new Task(string, string2, dateTime, dateTime2);
        this.add(task);
        return task;
    }

    public void restoreFromJSON(JSONArray jSONArray) {
        try {
            this.clear();
            if (jSONArray == null) {
                return;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                this.add(Task.fromJSON(jSONObject));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Task findByIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative index not allowed.");
        }
        Position position = new Position();
        return this.findByIndex(position, n);
    }

    private Task findByIndex(Position position, int n) {
        for (Task task : this) {
            if (position.is(n)) {
                return task;
            }
            position.inc();
            Task task2 = task.getChildren().findByIndex(position, n);
            if (task2 == null) continue;
            return task2;
        }
        return null;
    }

    public Task findById(String string) {
        if (string == null) {
            return null;
        }
        for (Task task : this) {
            if (string.equals(task.getId())) {
                return task;
            }
            Task task2 = task.getChildren().findById(string);
            if (task2 == null) continue;
            return task2;
        }
        return null;
    }

    public JSONArray toJSON() {
        JSONArray jSONArray = new JSONArray();
        for (Task task : this) {
            jSONArray.put(task.toJSONIncludeChildren());
        }
        return jSONArray;
    }

    public int getTotalCount() {
        int n = this.size();
        for (Task task : this) {
            n += task.getChildren().getTotalCount();
        }
        return n;
    }

    public TaskCollection findParentCollection(Task task) {
        Task task2 = this.findParent(task);
        if (task2 == Task.ROOT) {
            return this;
        }
        return task2.getChildren();
    }

    private Task findParent(Task task) {
        return this.findParent(task, Task.ROOT);
    }

    private Task findParent(Task task, Task task2) {
        for (Task task3 : this) {
            if (task3 == task) {
                return task2;
            }
            Task task4 = task3.getChildren().findParent(task, task3);
            if (task4 == null) continue;
            return task4;
        }
        return null;
    }

    class Position {
        private int i = 0;

        Position() {
        }

        void inc() {
            ++this.i;
        }

        boolean is(int n) {
            return this.i == n;
        }
    }
}

