/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import org.daypilot.json.JSONObject;
import org.daypilot.ui.enums.GroupBy;
import org.daypilot.util.Str;

public class TimeHeader {
    private GroupBy groupBy;
    private String format;

    public TimeHeader() {
    }

    public TimeHeader(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public TimeHeader(GroupBy groupBy, String string) {
        this.groupBy = groupBy;
        this.format = string;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("groupBy", this.groupBy.toString());
        if (!Str.isNullOrEmpty(this.format)) {
            jSONObject.put("format", this.format);
        }
        return jSONObject;
    }

    public static TimeHeader FromJson(JSONObject jSONObject) {
        TimeHeader timeHeader = new TimeHeader();
        timeHeader.groupBy = GroupBy.fromString(jSONObject.getString("groupBy"));
        timeHeader.format = jSONObject.optString("format");
        return timeHeader;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }
}

