/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.date;

import java.util.Calendar;
import java.util.Locale;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;

public class Week {
    public static DateTime firstDayOfWeek() {
        return Week.firstDayOfWeek(DateTime.getToday());
    }

    public static DateTime firstDayOfWeek(DateTime dateTime) {
        return Week.firstDayOfWeek(dateTime, DayOfWeek.getDefaultWeekStart());
    }

    public static DateTime firstDayOfWeek(DateTime dateTime, DayOfWeek dayOfWeek) {
        DateTime dateTime2 = dateTime;
        while (dateTime2.getDayOfWeek() != dayOfWeek) {
            dateTime2 = dateTime2.addDays(-1);
        }
        return dateTime2;
    }

    public static DateTime firstWorkingDayOfWeek(DateTime dateTime) {
        return Week.firstDayOfWeek(dateTime, DayOfWeek.MONDAY);
    }

    public static int weekNrISO8601(DateTime dateTime) {
        int n;
        boolean bl = false;
        int n2 = dateTime.getDayOfYear();
        int n3 = new DateTime(dateTime.getYear(), 1, 1).getDayOfWeekOrdinal();
        int n4 = new DateTime(dateTime.getYear(), 12, 31).getDayOfWeekOrdinal();
        if (n3 == 0) {
            n3 = 7;
        }
        if (n4 == 0) {
            n4 = 7;
        }
        int n5 = 8 - n3;
        if (n3 == 4 || n4 == 4) {
            bl = true;
        }
        int n6 = n = (int)Math.ceil((double)(n2 - n5) / 7.0);
        if (n5 >= 4) {
            ++n6;
        }
        if (n6 > 52 && !bl) {
            n6 = 1;
        }
        if (n6 == 0) {
            n6 = Week.weekNrISO8601(new DateTime(dateTime.getYear() - 1, 12, 31));
        }
        return n6;
    }

    public static DateTime firstDayOfWeek(DateTime dateTime, Locale locale) {
        Calendar calendar = Calendar.getInstance(locale);
        DayOfWeek dayOfWeek = DayOfWeek.fromConstant(calendar.getFirstDayOfWeek());
        return Week.firstDayOfWeek(dateTime, dayOfWeek);
    }

    public static DateTime monday(DateTime dateTime, DayOfWeek dayOfWeek) {
        DateTime dateTime2;
        DayOfWeek dayOfWeek2 = DayOfWeek.MONDAY;
        DateTime dateTime3 = dateTime2 = Week.firstDayOfWeek(dateTime, dayOfWeek);
        while (dateTime3.getDayOfWeek() != dayOfWeek2) {
            dateTime3 = dateTime3.addDays(1);
        }
        return dateTime3;
    }
}

