/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.recurrence;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONObject;
import org.daypilot.recurrence.Occurrence;
import org.daypilot.recurrence.RecurEvent;
import org.daypilot.recurrence.RecurEx;
import org.daypilot.recurrence.RecurType;
import org.daypilot.recurrence.RecurrenceException;
import org.daypilot.recurrence.RepeatRule;
import org.daypilot.util.Base64;
import org.daypilot.util.Str;

public class RecurrenceRule {
    private static final DateTime INFINITY = DateTime.parseString("2999-12-31");
    private String id;
    private RangeSpecType rangeSpec = RangeSpecType.Until;
    private DateTime until = INFINITY;
    private int times;
    private RepeatRule repeat = RepeatRule.NONE;
    private int every = 1;
    private List<Integer> named;
    private List<Integer> units;
    private DateTime start = null;
    private boolean initialized = true;
    public static final RecurrenceRule NOREPEAT = new RecurrenceRule();
    public static final RecurrenceRule EXCEPTION = new RecurrenceRule();

    private RecurrenceRule() {
    }

    public String getId() {
        this.makeSureNotNone();
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public RangeSpecType getRangeSpec() {
        return this.rangeSpec;
    }

    public void setRangeSpec(RangeSpecType rangeSpecType) {
        this.rangeSpec = rangeSpecType;
    }

    public DateTime getUntilValue() {
        if (this.getRangeSpec() != RangeSpecType.Until) {
            throw new RecurrenceException("This RecurrenceRule has not RangeSpec = Until defined.");
        }
        return this.until;
    }

    public Integer getTimesValue() {
        if (this.getRangeSpec() != RangeSpecType.Times) {
            throw new RecurrenceException("This RecurrenceRule has not RangeSpec = Times defined.");
        }
        return this.times;
    }

    public static RecurrenceRule fromDateTime(String string, DateTime dateTime) {
        RecurrenceRule recurrenceRule = new RecurrenceRule();
        recurrenceRule.id = string;
        recurrenceRule.start = dateTime;
        recurrenceRule.initialized = false;
        return recurrenceRule;
    }

    private void makeSureNotNone() {
        if (this == NOREPEAT) {
            throw new RecurrenceException("RecurrenceRule.NoRepeat be read or modified.");
        }
        if (this == EXCEPTION) {
            throw new RecurrenceException("RecurrenceRule.Disabled be read or modified.");
        }
    }

    private void makeSureInitialized() {
        if (!this.initialized) {
            throw new RecurrenceException("RecurrenceRule instance was not initialized properly (no recurrence rule defined).");
        }
    }

    public RecurrenceRule monthly() {
        this.initialized = true;
        this.makeSureNotNone();
        this.repeat = RepeatRule.MONTHLY;
        this.units = new ArrayList<Integer>();
        this.units.add(this.start.getDay());
        return this;
    }

    public RecurrenceRule monthly(Integer[] integerArray) {
        this.initialized = true;
        this.makeSureNotNone();
        return this.monthly(integerArray, 1);
    }

    public RecurrenceRule monthly(Integer[] integerArray, int n) {
        this.initialized = true;
        this.makeSureNotNone();
        this.repeat = RepeatRule.MONTHLY;
        this.every = n;
        this.units = new ArrayList<Integer>();
        Integer[] integerArray2 = integerArray;
        int n2 = integerArray2.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = integerArray2[i];
            this.units.add(n3);
        }
        return this;
    }

    public RecurrenceRule annually() {
        this.initialized = true;
        this.makeSureNotNone();
        this.repeat = RepeatRule.ANNUALLY;
        return this;
    }

    public RecurrenceRule monthly(int[] nArray, int[] nArray2) {
        this.initialized = true;
        this.makeSureNotNone();
        this.repeat = RepeatRule.MONTHLY;
        this.units = new ArrayList<Integer>();
        for (int n : nArray) {
            this.units.add(n);
        }
        this.named = new ArrayList<Integer>();
        for (int n : nArray2) {
            this.named.add(n);
        }
        return this;
    }

    public RecurrenceRule daily() {
        this.initialized = true;
        this.makeSureNotNone();
        this.repeat = RepeatRule.DAILY;
        return this;
    }

    public RecurrenceRule daily(int n) {
        this.initialized = true;
        this.makeSureNotNone();
        if (this.every < 1) {
            throw new RecurrenceException("Negative or zero value of 'every' argument is not allowed.");
        }
        this.repeat = RepeatRule.DAILY;
        this.every = n;
        return this;
    }

    public RecurrenceRule weekly() {
        this.initialized = true;
        this.makeSureNotNone();
        this.repeat = RepeatRule.WEEKLY;
        this.units = new ArrayList<Integer>();
        this.units.add(this.start.getDayOfWeekOrdinal());
        return this;
    }

    public RecurrenceRule weekly(DayOfWeek[] dayOfWeekArray) {
        this.initialized = true;
        this.makeSureNotNone();
        return this.weekly(dayOfWeekArray, 1);
    }

    public RecurrenceRule weekly(DayOfWeek[] dayOfWeekArray, int n) {
        this.initialized = true;
        this.makeSureNotNone();
        if (dayOfWeekArray == null || dayOfWeekArray.length == 0) {
            throw new RecurrenceException("No day of week specified.");
        }
        if (this.every < 1) {
            throw new RecurrenceException("Negative or zero value of 'every' argument is not allowed.");
        }
        this.repeat = RepeatRule.WEEKLY;
        this.every = n;
        this.units = new ArrayList<Integer>();
        for (DayOfWeek dayOfWeek : dayOfWeekArray) {
            this.units.add(dayOfWeek.toOrdinal());
        }
        return this;
    }

    public RecurrenceRule times(int n) {
        this.makeSureNotNone();
        this.rangeSpec = RangeSpecType.Times;
        this.times = n;
        return this;
    }

    public RecurrenceRule until(DateTime dateTime) {
        this.makeSureNotNone();
        this.rangeSpec = RangeSpecType.Until;
        this.until = dateTime;
        return this;
    }

    public RecurrenceRule indefinitely() {
        return this.until(INFINITY);
    }

    public String encode() {
        if (this == NOREPEAT || this == EXCEPTION) {
            return null;
        }
        this.makeSureInitialized();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Base64.encodeString(this.getId()));
        arrayList.add("2");
        arrayList.add("C");
        if (this.rangeSpec == RangeSpecType.Times) {
            arrayList.add("T");
            arrayList.add(this.getTimesValue().toString());
        } else {
            arrayList.add("U");
            arrayList.add(this.getUntilValue().toStringSortable());
        }
        arrayList.add(Base64.encodeString(this.toSimple()));
        return Str.join(arrayList, "#");
    }

    private String toSimple() {
        this.makeSureInitialized();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.repeat.toString().charAt(0));
        stringBuilder.append(" ");
        if (this.units == null) {
            stringBuilder.append("*");
        } else {
            stringBuilder.append(Str.join(this.units, ","));
        }
        stringBuilder.append(" ");
        if (this.named == null) {
            if (this.every > 1) {
                stringBuilder.append("*/");
                stringBuilder.append(this.every);
            } else {
                stringBuilder.append("*");
            }
        } else {
            stringBuilder.append(Str.join(this.named, ","));
        }
        return stringBuilder.toString();
    }

    public static String encodeExceptionModified(String string, DateTime dateTime) {
        return RecurEx.createString(RecurType.MODIFIED, string, dateTime);
    }

    public static String encodeExceptionDeleted(String string, DateTime dateTime) {
        return RecurEx.createString(RecurType.DELETED, string, dateTime);
    }

    public static RecurrenceRule decode(String string) {
        if (string == null) {
            return NOREPEAT;
        }
        String[] stringArray = string.split("#");
        if (!stringArray[1].equals("1") && !stringArray[1].equals("2")) {
            throw new RecurrenceException("Unsupported recurrence format exception.");
        }
        int n = Integer.parseInt(stringArray[1]);
        if (stringArray[2].equals("M")) {
            return EXCEPTION;
        }
        RecurrenceRule recurrenceRule = new RecurrenceRule();
        recurrenceRule.id = Base64.decodeToString(stringArray[0]);
        if (stringArray[3].equals("T")) {
            recurrenceRule.setRangeSpec(RangeSpecType.Times);
            recurrenceRule.times = Integer.parseInt(stringArray[4]);
        } else {
            recurrenceRule.setRangeSpec(RangeSpecType.Until);
            recurrenceRule.until = new DateTime(stringArray[4]);
        }
        if (n == 1) {
            throw new RecurrenceException("Version 1 format not supported.");
        }
        if (n == 2) {
            recurrenceRule.parseSimple(Base64.decodeToString(stringArray[5]));
        }
        return recurrenceRule;
    }

    private void parseSimple(String string) {
        if (Str.isNullOrEmpty(string)) {
            throw new RecurrenceException("Empty or null string not allowed.");
        }
        String[] stringArray = string.split(" ");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        RecurrenceRule recurrenceRule = this;
        switch (string2.charAt(0)) {
            case 'D': {
                recurrenceRule.repeat = RepeatRule.DAILY;
                break;
            }
            case 'W': {
                recurrenceRule.repeat = RepeatRule.WEEKLY;
                break;
            }
            case 'M': {
                recurrenceRule.repeat = RepeatRule.MONTHLY;
                break;
            }
            case 'A': {
                recurrenceRule.repeat = RepeatRule.ANNUALLY;
                break;
            }
            default: {
                throw new RecurrenceException("Unknown Repeat specification.");
            }
        }
        if (!string3.equals("*")) {
            recurrenceRule.units = RecurrenceRule.deserializeList(string3);
        }
        if (string4.equals("*")) {
            recurrenceRule.every = 1;
        } else if (string4.startsWith("*/")) {
            recurrenceRule.every = Integer.parseInt(string4.substring(2));
        } else {
            recurrenceRule.named = RecurrenceRule.deserializeList(string4);
        }
    }

    private static List<Integer> deserializeList(String string) {
        String[] stringArray = string.split(",");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : stringArray) {
            arrayList.add(Integer.parseInt(string2));
        }
        return arrayList;
    }

    public String ToJson() {
        return this.ToJson(Locale.getDefault());
    }

    public String ToJson(Locale locale) {
        JSONObject jSONObject = new JSONObject();
        if (this == EXCEPTION) {
            jSONObject.put("type", "disabled");
            return jSONObject.toString();
        }
        if (this == NOREPEAT) {
            jSONObject.put("type", "norepeat");
            return jSONObject.toString();
        }
        this.makeSureInitialized();
        if (this.repeat == RepeatRule.DAILY) {
            jSONObject.put("type", "daily");
            jSONObject.put("every", this.every);
        } else if (this.repeat == RepeatRule.WEEKLY) {
            jSONObject.put("type", "weekly");
            JSONArray jSONArray = new JSONArray();
            jSONObject.put("days", jSONArray);
            if (this.units == null) {
                jSONArray.put(this.start.getDayOfWeekOrdinal());
            } else {
                for (int n : this.units) {
                    jSONArray.put(n);
                }
            }
            jSONObject.put("every", this.every);
        } else if (this.repeat == RepeatRule.MONTHLY) {
            jSONObject.put("type", "monthly");
            JSONArray jSONArray = new JSONArray();
            jSONObject.put("days", jSONArray);
            if (this.units == null) {
                jSONArray.put(this.start.getDay());
            } else {
                for (int n : this.units) {
                    jSONArray.put(n);
                }
            }
            jSONObject.put("every", this.every);
        } else if (this.repeat == RepeatRule.ANNUALLY) {
            jSONObject.put("type", "annually");
        } else {
            throw new RecurrenceException("Unable to serialize RecurrenceRule to JSON.");
        }
        switch (this.getRangeSpec().ordinal()) {
            case 1: {
                jSONObject.put("range", "times");
                jSONObject.put("times", this.getTimesValue());
                break;
            }
            case 0: {
                if (this.until.equals(INFINITY)) {
                    jSONObject.put("range", "indefinitely");
                    break;
                }
                jSONObject.put("range", "until");
                jSONObject.put("until", this.until.toDateString(locale));
            }
        }
        return jSONObject.toString();
    }

    public static RecurrenceRule fromJson(String string, DateTime dateTime, String string2) {
        Object object;
        RecurrenceRule recurrenceRule;
        if (Str.isNullOrEmpty(string)) {
            throw new RecurrenceException("Id parameter must not be null or empty.");
        }
        JSONObject jSONObject = new JSONObject(string2);
        String string3 = jSONObject.getString("type");
        if (string3.equals("disabled")) {
            return EXCEPTION;
        }
        if (string3.equals("norepeat")) {
            return NOREPEAT;
        }
        if (string3.equals("daily")) {
            recurrenceRule = RecurrenceRule.fromDateTime(string, dateTime).daily(jSONObject.getInt("every"));
        } else if (string3.equals("monthly")) {
            object = new ArrayList();
            JSONArray jSONArray = jSONObject.optJSONArray("days");
            if (jSONArray != null) {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    object.add(jSONArray.getInt(i));
                }
            }
            recurrenceRule = RecurrenceRule.fromDateTime(string, dateTime).monthly(object.toArray(new Integer[0]), jSONObject.getInt("every"));
        } else if (string3.equals("weekly")) {
            object = new ArrayList();
            JSONArray jSONArray = jSONObject.optJSONArray("days");
            if (jSONArray != null) {
                for (int i = 0; i < jSONArray.length(); ++i) {
                    int n = jSONArray.getInt(i);
                    DayOfWeek dayOfWeek = DayOfWeek.fromOrdinal(n);
                    object.add(dayOfWeek);
                }
            }
            recurrenceRule = RecurrenceRule.fromDateTime(string, dateTime).weekly(object.toArray(new DayOfWeek[0]), jSONObject.getInt("every"));
        } else if (string3.equals("annually")) {
            recurrenceRule = RecurrenceRule.fromDateTime(string, dateTime).annually();
        } else {
            throw new RecurrenceException("Unknown Json recurrence format.");
        }
        object = jSONObject.getString("range");
        if (((String)object).equals("indefinitely")) {
            return recurrenceRule;
        }
        if (((String)object).equals("until")) {
            return recurrenceRule.until(DateTime.parseString(jSONObject.getString("until")));
        }
        if (((String)object).equals("times")) {
            return recurrenceRule.times(jSONObject.getInt("times"));
        }
        throw new RecurrenceException("Unknown Json recurrence format.");
    }

    public List<Occurrence> occurrences(DateTime dateTime) {
        RecurEvent recurEvent = RecurEvent.fromRule(this, this.start, this.start, this.id, null);
        return recurEvent.occurrences(dateTime);
    }

    public RepeatRule getRepeat() {
        return this.repeat;
    }

    public void setRepeat(RepeatRule repeatRule) {
        this.repeat = repeatRule;
    }

    public int getEvery() {
        return this.every;
    }

    public void setEvery(int n) {
        this.every = n;
    }

    public List<Integer> getNamed() {
        return this.named;
    }

    public void setNamed(List<Integer> list) {
        this.named = list;
    }

    public List<Integer> getUnits() {
        return this.units;
    }

    public void setUnits(List<Integer> list) {
        this.units = list;
    }

    public DateTime next(int n, DateTime dateTime) {
        RecurEvent recurEvent = RecurEvent.fromRule(this, this.start, this.start, this.id, null);
        return recurEvent.next(n, dateTime);
    }

    public static enum RangeSpecType {
        Until,
        Times;

    }
}

