/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.daypilot.data.LinkCollection;
import org.daypilot.data.Task;
import org.daypilot.data.TaskCollection;
import org.daypilot.data.TaskColumnCollection;
import org.daypilot.data.TimeCell;
import org.daypilot.data.TimeCellCollection;
import org.daypilot.data.TimeHeaderCollection;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.date.TimeSpan;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONException;
import org.daypilot.json.JSONObject;
import org.daypilot.ui.BubbleDetails;
import org.daypilot.ui.CellTable;
import org.daypilot.ui.CellTableCell;
import org.daypilot.ui.Ensure;
import org.daypilot.ui.GanttTimeHeaderParent;
import org.daypilot.ui.JSONParser;
import org.daypilot.ui.SchedulerTimeHeader;
import org.daypilot.ui.Version;
import org.daypilot.ui.args.gantt.BeforeCellRenderArgs;
import org.daypilot.ui.args.gantt.BeforeTaskRenderArgs;
import org.daypilot.ui.args.gantt.BeforeTimeHeaderRenderArgs;
import org.daypilot.ui.args.gantt.CommandArgs;
import org.daypilot.ui.args.gantt.IncludeCellArgs;
import org.daypilot.ui.args.gantt.LinkCreateArgs;
import org.daypilot.ui.args.gantt.LinkMenuClickArgs;
import org.daypilot.ui.args.gantt.RowBubbleArgs;
import org.daypilot.ui.args.gantt.RowClickArgs;
import org.daypilot.ui.args.gantt.RowCreateArgs;
import org.daypilot.ui.args.gantt.RowDoubleClickArgs;
import org.daypilot.ui.args.gantt.RowEditArgs;
import org.daypilot.ui.args.gantt.RowMenuClickArgs;
import org.daypilot.ui.args.gantt.RowMoveArgs;
import org.daypilot.ui.args.gantt.RowSelectArgs;
import org.daypilot.ui.args.gantt.TaskBubbleArgs;
import org.daypilot.ui.args.gantt.TaskClickArgs;
import org.daypilot.ui.args.gantt.TaskDoubleClickArgs;
import org.daypilot.ui.args.gantt.TaskMenuClickArgs;
import org.daypilot.ui.args.gantt.TaskMoveArgs;
import org.daypilot.ui.args.gantt.TaskResizeArgs;
import org.daypilot.ui.args.gantt.TaskRightClickArgs;
import org.daypilot.ui.enums.CellWidthSpec;
import org.daypilot.ui.enums.EventSource;
import org.daypilot.ui.enums.GroupBy;
import org.daypilot.ui.enums.TimeFormat;
import org.daypilot.ui.enums.TimeScale;
import org.daypilot.ui.enums.UpdateType;
import org.daypilot.ui.enums.WeekStarts;
import org.daypilot.ui.enums.gantt.TaskGroupMode;
import org.daypilot.util.LocaleParser;

public class DayPilotGantt {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String id;
    private DateTime startDate;
    private int days;
    private int cellDuration;
    private GroupBy cellGroupBy;
    private int cellWidth;
    private JSONObject clientState;
    private boolean showNonBusiness;
    private int businessBeginsHour;
    private int businessEndsHour;
    private Locale locale;
    private TimeHeaderCollection timeHeaders;
    private TimeCellCollection timeline = new TimeCellCollection();
    private TimeFormat timeFormat;
    private WeekStarts weekStarts;
    private TimeScale scale;
    private BubbleDetails bubble;
    private TimeZone timeZone = null;
    private UpdateType updateType = UpdateType.NONE;
    private String updateMessage;
    private JSONObject callbackData;
    private CellWidthSpec cellWidthSpec;
    private int scrollX;
    private int scrollY;
    private int rowMarginBottom;
    private int rowMinHeight;
    private Object taskGroupMode;
    private TaskCollection tasks = new TaskCollection();
    private TaskColumnCollection columns = new TaskColumnCollection();
    private LinkCollection links = new LinkCollection();
    SchedulerTimeHeader timeHeader = new SchedulerTimeHeader(new GanttTimeHeaderParent(this));
    private Collection<Task> selectedRows;

    public void onPrepare() throws Exception {
    }

    public void onFinish() throws Exception {
    }

    public void onInit() throws Exception {
    }

    public void onCommand(CommandArgs commandArgs) throws Exception {
    }

    public void onTaskClick(TaskClickArgs taskClickArgs) throws Exception {
    }

    public void onTaskDoubleClick(TaskDoubleClickArgs taskDoubleClickArgs) throws Exception {
    }

    public void onRowClick(RowClickArgs rowClickArgs) throws Exception {
    }

    public void onTaskMenuClick(TaskMenuClickArgs taskMenuClickArgs) throws Exception {
    }

    public void onTaskRightClick(TaskRightClickArgs taskRightClickArgs) throws Exception {
    }

    public void onRowMenuClick(RowMenuClickArgs rowMenuClickArgs) throws Exception {
    }

    public void onTaskResize(TaskResizeArgs taskResizeArgs) throws Exception {
    }

    public void onTaskMove(TaskMoveArgs taskMoveArgs) throws Exception {
    }

    public void onLinkCreate(LinkCreateArgs linkCreateArgs) throws Exception {
    }

    public void onLinkMenuClick(LinkMenuClickArgs linkMenuClickArgs) throws Exception {
    }

    public void onRowCreate(RowCreateArgs rowCreateArgs) throws Exception {
    }

    public void onRowDoubleClick(RowDoubleClickArgs rowDoubleClickArgs) throws Exception {
    }

    public void onRowEdit(RowEditArgs rowEditArgs) throws Exception {
    }

    public void onRowMove(RowMoveArgs rowMoveArgs) throws Exception {
    }

    public void onRowSelect(RowSelectArgs rowSelectArgs) throws Exception {
    }

    public void onBeforeTaskRender(BeforeTaskRenderArgs beforeTaskRenderArgs) throws Exception {
    }

    public void onBeforeTimeHeaderRender(BeforeTimeHeaderRenderArgs beforeTimeHeaderRenderArgs) throws Exception {
    }

    public void onBeforeCellRender(BeforeCellRenderArgs beforeCellRenderArgs) throws Exception {
    }

    public void onIncludeCell(IncludeCellArgs includeCellArgs) throws Exception {
    }

    public void onTaskBubble(TaskBubbleArgs taskBubbleArgs) throws Exception {
    }

    public void onRowBubble(RowBubbleArgs rowBubbleArgs) throws Exception {
    }

    public DayPilotGantt() {
        this.timeHeaders = new TimeHeaderCollection();
        this.timeHeaders.add(GroupBy.MONTH);
        this.timeHeaders.add(GroupBy.DAY);
    }

    private JSONObject callback(JSONObject jSONObject) {
        try {
            Object object;
            String string = jSONObject.getString("action");
            JSONObject jSONObject2 = jSONObject.optJSONObject("parameters");
            JSONObject jSONObject3 = jSONObject.optJSONObject("data");
            JSONObject jSONObject4 = jSONObject.getJSONObject("header");
            EventSource eventSource = EventSource.fromString(jSONObject.getString("type"));
            Version.check(jSONObject4.optString("v"));
            this.id = jSONObject4.getString("id");
            this.startDate = jSONObject4.getDateTime("startDate");
            this.days = jSONObject4.optInt("days");
            if (this.days == 0) {
                this.days = 1;
            }
            this.cellDuration = jSONObject4.getInt("cellDuration");
            this.cellGroupBy = GroupBy.fromString(jSONObject4.getString("cellGroupBy"));
            this.cellWidth = jSONObject4.getInt("cellWidth");
            this.cellWidthSpec = CellWidthSpec.fromString(jSONObject4.getString("cellWidthSpec"));
            this.clientState = jSONObject4.getJSONObject("clientState");
            this.scrollX = jSONObject4.getInt("scrollX");
            this.scrollY = jSONObject4.getInt("scrollY");
            this.scale = TimeScale.fromString(jSONObject4.optString("scale"));
            this.showNonBusiness = jSONObject4.getBoolean("showNonBusiness");
            this.businessBeginsHour = jSONObject4.getInt("businessBeginsHour");
            this.businessEndsHour = jSONObject4.getInt("businessEndsHour");
            this.rowMarginBottom = jSONObject4.getInt("rowMarginBottom");
            this.rowMinHeight = jSONObject4.getInt("rowMinHeight");
            this.taskGroupMode = TaskGroupMode.fromString(jSONObject4.getString("taskGroupMode"));
            this.locale = LocaleParser.isValid(jSONObject4.optString("locale")) ? LocaleParser.parse(jSONObject4.getString("locale")) : this.locale;
            this.timeHeaders = TimeHeaderCollection.fromJSON(jSONObject4.optJSONArray("timeHeaders"));
            this.timeFormat = TimeFormat.isValid(jSONObject4.optString("timeFormat")) ? TimeFormat.parse(jSONObject4.getString("timeFormat")) : this.timeFormat;
            this.weekStarts = WeekStarts.fromStringJavaScript(jSONObject4.optString("weekStarts"));
            this.selectedRows = this.taskListFromJSON(jSONObject4.optJSONArray("selectedRows"));
            this.tasks.restoreFromJSON(jSONObject4.optJSONArray("tree"));
            this.links.restoreFromJSON(jSONObject4.optJSONArray("links"));
            this.columns.restoreFromJSON(jSONObject4.optJSONArray("rowHeaderColumns"));
            this.sanityCheck();
            this.onPrepare();
            if (string.equals("Init")) {
                this.onInit();
            } else if (string.equals("Command")) {
                object = CommandArgs.fromJSON(jSONObject2, jSONObject3);
                this.onCommand((CommandArgs)object);
            } else if (string.equals("EventClick")) {
                object = TaskClickArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onTaskClick((TaskClickArgs)object);
            } else if (string.equals("EventDoubleClick")) {
                object = TaskDoubleClickArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onTaskDoubleClick((TaskDoubleClickArgs)object);
            } else if (string.equals("RowClick")) {
                object = RowClickArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onRowClick((RowClickArgs)object);
            } else if (string.equals("RowDoubleClick")) {
                object = RowDoubleClickArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onRowDoubleClick((RowDoubleClickArgs)object);
            } else if (string.equals("EventMenuClick")) {
                object = TaskMenuClickArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onTaskMenuClick((TaskMenuClickArgs)object);
            } else if (string.equals("EventRightClick")) {
                object = TaskRightClickArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onTaskRightClick((TaskRightClickArgs)object);
            } else if (string.equals("RowMenuClick")) {
                object = RowMenuClickArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onRowMenuClick((RowMenuClickArgs)object);
            } else if (string.equals("RowCreate")) {
                object = RowCreateArgs.fromJSON(jSONObject2, jSONObject3);
                this.onRowCreate((RowCreateArgs)object);
            } else if (string.equals("RowMove")) {
                object = RowMoveArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onRowMove((RowMoveArgs)object);
            } else if (string.equals("EventMove")) {
                object = TaskMoveArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onTaskMove((TaskMoveArgs)object);
            } else if (string.equals("EventResize")) {
                object = TaskResizeArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onTaskResize((TaskResizeArgs)object);
            } else if (string.equals("RowEdit")) {
                object = RowEditArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onRowEdit((RowEditArgs)object);
            } else if (string.equals("LinkCreate")) {
                object = LinkCreateArgs.fromJSON(jSONObject2, jSONObject3);
                this.onLinkCreate((LinkCreateArgs)object);
            } else if (string.equals("LinkMenuClick")) {
                object = LinkMenuClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onLinkMenuClick((LinkMenuClickArgs)object);
            } else if (string.equals("Bubble")) {
                this.doBubble(jSONObject2, jSONObject3);
            } else if (string.equals("RowSelect")) {
                object = RowSelectArgs.fromJSON(this.tasks, jSONObject2, jSONObject3);
                this.onRowSelect((RowSelectArgs)object);
            }
            this.onFinish();
            this.sanityCheck();
            object = new JSONObject();
            if (this.bubble != null) {
                ((JSONObject)object).put("BubbleGuid", this.bubble.getGuid());
                JSONObject jSONObject5 = new JSONObject();
                jSONObject5.put("BubbleHTML", this.bubble.getHtml());
                ((JSONObject)object).put("Result", jSONObject5);
                return object;
            }
            ((JSONObject)object).put("Action", string);
            ((JSONObject)object).put("Message", this.updateMessage);
            ((JSONObject)object).put("CallBackData", this.callbackData);
            ((JSONObject)object).put("updateType", this.updateType.toString());
            ((JSONObject)object).put("type", eventSource.toString());
            if (this.updateType == UpdateType.NONE) {
                return object;
            }
            ((JSONObject)object).put("CallBackData", this.callbackData);
            if (this.updateType != UpdateType.NONE) {
                this.updateType = UpdateType.FULL;
            }
            ((JSONObject)object).put("days", this.days);
            ((JSONObject)object).put("cellDuration", this.cellDuration);
            ((JSONObject)object).put("cellGroupBy", this.cellGroupBy.toString());
            ((JSONObject)object).put("cellWidth", this.cellWidth);
            ((JSONObject)object).put("rowMinHeight", this.rowMinHeight);
            ((JSONObject)object).put("rowMarginBottom", this.rowMarginBottom);
            ((JSONObject)object).put("taskGroupMode", this.taskGroupMode.toString());
            ((JSONObject)object).put("startDate", this.startDate.utc());
            this.timeHeader.prepareTimeline();
            this.timeHeader.prepareGrouplines();
            CellTable cellTable = new CellTable(this);
            cellTable.process();
            ((JSONObject)object).put("cellProperties", cellTable.getProperties());
            ((JSONObject)object).put("cellConfig", cellTable.getConfig());
            ((JSONObject)object).put("timeHeader", this.timeHeader.toJSON());
            ((JSONObject)object).put("timeHeaders", this.timeHeaders.toJSON());
            ((JSONObject)object).put("timeline", this.timeHeader.getTimeline().toJSON());
            ((JSONObject)object).put("tasks", this.getTasksJSON());
            ((JSONObject)object).put("links", this.links.toJSON());
            ((JSONObject)object).put("days", this.days);
            ((JSONObject)object).put("cellDuration", this.cellDuration);
            ((JSONObject)object).put("cellGroupBy", this.cellGroupBy.toString());
            ((JSONObject)object).put("cellWidth", this.cellWidth);
            ((JSONObject)object).put("rowMinHeight", this.rowMinHeight);
            ((JSONObject)object).put("rowMarginBottom", this.rowMarginBottom);
            ((JSONObject)object).put("taskGroupMode", this.taskGroupMode.toString());
            ((JSONObject)object).put("startDate", this.startDate.toString());
            return object;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private Collection<Task> taskListFromJSON(JSONArray jSONArray) {
        if (jSONArray == null) {
            return new ArrayList<Task>();
        }
        ArrayList<Task> arrayList = new ArrayList<Task>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            String string = jSONArray.getJSONObject(i).getString("id");
            Task task = this.tasks.findById(string);
            arrayList.add(task);
        }
        return arrayList;
    }

    private void doBubble(JSONObject jSONObject, JSONObject jSONObject2) throws Exception {
        this.bubble = new BubbleDetails(jSONObject.getString("guid"));
        JSONObject jSONObject3 = jSONObject.getJSONObject("args");
        String string = jSONObject3.getString("type");
        if ("Event".equals(string)) {
            TaskBubbleArgs taskBubbleArgs = TaskBubbleArgs.fromJSON(this.tasks, jSONObject3, jSONObject2);
            this.onTaskBubble(taskBubbleArgs);
            this.bubble.setHtml(taskBubbleArgs.getBubbleHTML());
        } else if ("Resource".equals(string)) {
            RowBubbleArgs rowBubbleArgs = RowBubbleArgs.fromJSON(jSONObject3, jSONObject2);
            this.onRowBubble(rowBubbleArgs);
            this.bubble.setHtml(rowBubbleArgs.getBubbleHTML());
        } else if ("Cell".equals(string)) {
            this.bubble.setHtml(null);
        } else {
            throw new RuntimeException("not implemented");
        }
    }

    private void sanityCheck() {
        Ensure.inRange("businessBeginsHour", this.businessBeginsHour, 0, 23);
        Ensure.inRange("businessEndsHour", this.businessEndsHour, 0, 24);
        Ensure.inRange("cellDuration", this.cellDuration, 1, 10080);
        Ensure.inRange("days", this.days, 1, 1500);
    }

    private JSONArray getTasksJSON() throws Exception {
        return this.getTaskChildrenJSON(this.tasks);
    }

    private JSONArray getTaskChildrenJSON(TaskCollection taskCollection) throws Exception {
        JSONArray jSONArray = new JSONArray();
        for (BeforeTaskRenderArgs beforeTaskRenderArgs : this.processTasks(taskCollection)) {
            JSONObject jSONObject = beforeTaskRenderArgs.toJSON();
            if (beforeTaskRenderArgs.hasChildren()) {
                jSONObject.put("children", this.getTaskChildrenJSON(beforeTaskRenderArgs.getChildren()));
            }
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    private List<BeforeTaskRenderArgs> processTasks(TaskCollection taskCollection) throws Exception {
        ArrayList<BeforeTaskRenderArgs> arrayList = new ArrayList<BeforeTaskRenderArgs>();
        for (Task task : taskCollection) {
            BeforeTaskRenderArgs beforeTaskRenderArgs = BeforeTaskRenderArgs.fromTask(task, this);
            this.onBeforeTaskRender(beforeTaskRenderArgs);
            arrayList.add(beforeTaskRenderArgs);
        }
        return arrayList;
    }

    public void update() {
        this.updateType = UpdateType.FULL;
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            httpServletRequest.setCharacterEncoding("UTF-8");
            JSONObject jSONObject = JSONParser.parse(httpServletRequest);
            JSONObject jSONObject2 = this.callback(jSONObject);
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().print(jSONObject2);
            httpServletResponse.getWriter().close();
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    private TimeZone tz() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        return DateTime.UTC;
    }

    public DateTime getStartDate() {
        return this.startDate.tz(this.tz());
    }

    public void setStartDate(DateTime dateTime) {
        this.startDate = dateTime;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int n) {
        this.days = n;
    }

    public int getCellDuration() {
        return this.cellDuration;
    }

    public void setCellDuration(int n) {
        this.cellDuration = n;
    }

    public GroupBy getCellGroupBy() {
        return this.cellGroupBy;
    }

    public void setCellGroupBy(GroupBy groupBy) {
        this.cellGroupBy = groupBy;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int n) {
        this.cellWidth = n;
    }

    public JSONObject getClientState() {
        return this.clientState;
    }

    public void setClientState(JSONObject jSONObject) {
        this.clientState = jSONObject;
    }

    public boolean isShowNonBusiness() {
        return this.showNonBusiness;
    }

    public void setShowNonBusiness(boolean bl) {
        this.showNonBusiness = bl;
    }

    public int getBusinessBeginsHour() {
        return this.businessBeginsHour;
    }

    public void setBusinessBeginsHour(int n) {
        this.businessBeginsHour = n;
    }

    public int getBusinessEndsHour() {
        return this.businessEndsHour;
    }

    public void setBusinessEndsHour(int n) {
        this.businessEndsHour = n;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public TimeHeaderCollection getTimeHeaders() {
        return this.timeHeaders;
    }

    public void setTimeHeaders(TimeHeaderCollection timeHeaderCollection) {
        this.timeHeaders = timeHeaderCollection;
    }

    public TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    public WeekStarts getWeekStarts() {
        return this.weekStarts;
    }

    public void setWeekStarts(WeekStarts weekStarts) {
        this.weekStarts = weekStarts;
    }

    public TimeScale getScale() {
        return this.scale;
    }

    public void setScale(TimeScale timeScale) {
        this.scale = timeScale;
    }

    public TaskCollection getTasks() {
        return this.tasks;
    }

    public void setTasks(TaskCollection taskCollection) {
        this.tasks = taskCollection;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public void setScrollX(int n) {
        this.scrollX = n;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(int n) {
        this.scrollY = n;
    }

    public int getRowMarginBottom() {
        return this.rowMarginBottom;
    }

    public void setRowMarginBottom(int n) {
        this.rowMarginBottom = n;
    }

    public int getRowMinHeight() {
        return this.rowMinHeight;
    }

    public void setRowMinHeight(int n) {
        this.rowMinHeight = n;
    }

    public Object getTaskGroupMode() {
        return this.taskGroupMode;
    }

    public void setTaskGroupMode(Object object) {
        this.taskGroupMode = object;
    }

    public TaskColumnCollection getColumns() {
        return this.columns;
    }

    public void setColumns(TaskColumnCollection taskColumnCollection) {
        this.columns = taskColumnCollection;
    }

    public CellWidthSpec getCellWidthSpec() {
        return this.cellWidthSpec;
    }

    public void setCellWidthSpec(CellWidthSpec cellWidthSpec) {
        this.cellWidthSpec = cellWidthSpec;
    }

    public LinkCollection getLinks() {
        return this.links;
    }

    public void setLinks(LinkCollection linkCollection) {
        this.links = linkCollection;
    }

    public DateTime getVisibleStart() {
        DateTime dateTime = this.startDate;
        if (this.scale == TimeScale.MANUAL) {
            if (this.timeline.size() == 0) {
                throw new RuntimeException("The Timeline doesn't contain any cells (Scale='Manual' mode)");
            }
            dateTime = ((TimeCell)this.timeline.get(0)).getStart();
        }
        return dateTime;
    }

    public DateTime getVisibleEnd() {
        DateTime dateTime = this.startDate.addDays(this.days);
        if (this.scale == TimeScale.MANUAL) {
            if (this.timeline.size() == 0) {
                throw new RuntimeException("The Timeline doesn't contain any cells (Scale='Manual' mode)");
            }
            dateTime = ((TimeCell)this.timeline.get(this.timeline.size() - 1)).getEnd();
        }
        return dateTime;
    }

    public DayOfWeek getResolvedWeekStart() {
        switch (this.weekStarts) {
            case SUNDAY: {
                return DayOfWeek.SUNDAY;
            }
            case MONDAY: {
                return DayOfWeek.MONDAY;
            }
            case TUESDAY: {
                return DayOfWeek.TUESDAY;
            }
            case WEDNESDAY: {
                return DayOfWeek.WEDNESDAY;
            }
            case THURSDAY: {
                return DayOfWeek.THURSDAY;
            }
            case FRIDAY: {
                return DayOfWeek.FRIDAY;
            }
            case SATURDAY: {
                return DayOfWeek.SATURDAY;
            }
            case AUTO: {
                return DayOfWeek.getDefaultWeekStart();
            }
        }
        throw new RuntimeException("This weekStarts value is not supported (" + (Object)((Object)this.weekStarts) + ").");
    }

    public TimeCellCollection getTimeline() {
        return this.timeline;
    }

    public void setTimeline(TimeCellCollection timeCellCollection) {
        this.timeline = timeCellCollection;
    }

    public DateTime getEndDate() {
        return this.startDate.addDays(this.days);
    }

    void doIncludeCell(IncludeCellArgs includeCellArgs) {
        try {
            this.onIncludeCell(includeCellArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public CellTableCell getCell(DateTime dateTime, DateTime dateTime2, String string) {
        BeforeCellRenderArgs beforeCellRenderArgs = new BeforeCellRenderArgs(dateTime, dateTime2, string);
        boolean bl = this.isBusinessCell(dateTime, dateTime2);
        beforeCellRenderArgs.setBusiness(bl);
        try {
            this.onBeforeCellRender(beforeCellRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        CellTableCell cellTableCell = new CellTableCell();
        cellTableCell.setBusiness(beforeCellRenderArgs.isBusiness());
        cellTableCell.setColor(beforeCellRenderArgs.getBackgroundColor());
        cellTableCell.setInnerHTML(beforeCellRenderArgs.getInnerHTML());
        cellTableCell.setBackgroundImage(beforeCellRenderArgs.getBackgroundImage());
        cellTableCell.setBackgroundRepeat(beforeCellRenderArgs.getBackgroundRepeat());
        cellTableCell.setBackgroundColor(beforeCellRenderArgs.getBackgroundColor());
        cellTableCell.setCssClass(beforeCellRenderArgs.getCssClass());
        return cellTableCell;
    }

    private boolean isBusinessCell(DateTime dateTime, DateTime dateTime2) {
        int n = (int)dateTime2.minus(dateTime).getTotalMinutes();
        if (dateTime2.minus(dateTime).getTicks() > TimeSpan.fromDays(1).getTicks()) {
            return true;
        }
        if (dateTime.getDayOfWeek() == DayOfWeek.SATURDAY || dateTime.getDayOfWeek() == DayOfWeek.SUNDAY) {
            return false;
        }
        if (n < 720) {
            return dateTime.getHour() >= this.businessBeginsHour && dateTime.getHour() < this.businessEndsHour;
        }
        return true;
    }

    List<Task> getTasksFlat() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        this.tasksFlatAddCollection(arrayList, this.tasks);
        return arrayList;
    }

    private void tasksFlatAddCollection(List<Task> list, TaskCollection taskCollection) {
        for (Task task : taskCollection) {
            list.add(task);
            this.tasksFlatAddCollection(list, task.getChildren());
        }
    }

    public Collection<Task> getSelectedRows() {
        return this.selectedRows;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }
}

