/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.daypilot.data.LinkCollection;
import org.daypilot.data.Resource;
import org.daypilot.data.ResourceCollection;
import org.daypilot.data.SeparatorCollection;
import org.daypilot.data.TagCollection;
import org.daypilot.data.TimeCell;
import org.daypilot.data.TimeCellCollection;
import org.daypilot.data.TimeHeader;
import org.daypilot.data.TimeHeaderCell;
import org.daypilot.data.TimeHeaderCollection;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.date.TimeFormatter;
import org.daypilot.date.TimeSpan;
import org.daypilot.date.Week;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONException;
import org.daypilot.json.JSONObject;
import org.daypilot.recurrence.Occurrence;
import org.daypilot.recurrence.RecurEvent;
import org.daypilot.recurrence.RecurEx;
import org.daypilot.recurrence.RecurInfo;
import org.daypilot.recurrence.RecurType;
import org.daypilot.ui.CellTable;
import org.daypilot.ui.CellTableCell;
import org.daypilot.ui.Day;
import org.daypilot.ui.Ensure;
import org.daypilot.ui.Event;
import org.daypilot.ui.EventBean;
import org.daypilot.ui.JSONParser;
import org.daypilot.ui.Pixels;
import org.daypilot.ui.SchedulerTimeHeader;
import org.daypilot.ui.SchedulerTimeHeaderParent;
import org.daypilot.ui.SortExpression;
import org.daypilot.ui.TimeHeaderRow;
import org.daypilot.ui.TreeDay;
import org.daypilot.ui.Version;
import org.daypilot.ui.args.common.EventInfo;
import org.daypilot.ui.args.scheduler.BeforeCellRenderArgs;
import org.daypilot.ui.args.scheduler.BeforeEventRecurrenceArgs;
import org.daypilot.ui.args.scheduler.BeforeEventRenderArgs;
import org.daypilot.ui.args.scheduler.BeforeResHeaderRenderArgs;
import org.daypilot.ui.args.scheduler.BeforeTimeHeaderRenderArgs;
import org.daypilot.ui.args.scheduler.CommandArgs;
import org.daypilot.ui.args.scheduler.EventBubbleArgs;
import org.daypilot.ui.args.scheduler.EventClickArgs;
import org.daypilot.ui.args.scheduler.EventDeleteArgs;
import org.daypilot.ui.args.scheduler.EventDoubleClickArgs;
import org.daypilot.ui.args.scheduler.EventEditArgs;
import org.daypilot.ui.args.scheduler.EventMenuClickArgs;
import org.daypilot.ui.args.scheduler.EventMoveArgs;
import org.daypilot.ui.args.scheduler.EventResizeArgs;
import org.daypilot.ui.args.scheduler.EventRightClickArgs;
import org.daypilot.ui.args.scheduler.GroupBubbleArgs;
import org.daypilot.ui.args.scheduler.IncludeCellArgs;
import org.daypilot.ui.args.scheduler.NotifyArgs;
import org.daypilot.ui.args.scheduler.ResourceBubbleArgs;
import org.daypilot.ui.args.scheduler.ResourceHeaderClickArgs;
import org.daypilot.ui.args.scheduler.ResourceHeaderMenuClickArgs;
import org.daypilot.ui.args.scheduler.RowClickArgs;
import org.daypilot.ui.args.scheduler.RowCreateArgs;
import org.daypilot.ui.args.scheduler.RowDoubleClickArgs;
import org.daypilot.ui.args.scheduler.RowEditArgs;
import org.daypilot.ui.args.scheduler.RowMenuClickArgs;
import org.daypilot.ui.args.scheduler.RowMoveArgs;
import org.daypilot.ui.args.scheduler.RowSelectArgs;
import org.daypilot.ui.args.scheduler.TimeRangeDoubleClickArgs;
import org.daypilot.ui.args.scheduler.TimeRangeMenuClickArgs;
import org.daypilot.ui.args.scheduler.TimeRangeSelectedArgs;
import org.daypilot.ui.enums.CellWidthSpec;
import org.daypilot.ui.enums.GroupBy;
import org.daypilot.ui.enums.TimeFormat;
import org.daypilot.ui.enums.TimeScale;
import org.daypilot.ui.enums.UpdateType;
import org.daypilot.ui.enums.ViewType;
import org.daypilot.ui.enums.WeekStarts;
import org.daypilot.util.LocaleFormatter;
import org.daypilot.util.LocaleParser;
import org.daypilot.util.Str;
import org.daypilot.util.Xml;

public class DayPilotScheduler {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String dataIdField = "id";
    private String dataTextField = "text";
    private String dataStartField = "start";
    private String dataEndField = "end";
    private String dataResourceField = "resource";
    private String dataTagFields;
    private String dataRecurrenceField;
    private String dataJoinField;
    private boolean useUtcDates = false;
    private Collection<?> events;
    private List<Event> items;
    private UpdateType updateType = UpdateType.NONE;
    private String updateMessage;
    private String id;
    private DateTime startDate;
    private int days;
    private int cellDuration;
    private GroupBy cellGroupBy;
    private int cellWidth;
    private JSONObject clientState;
    private int scrollX;
    private DateTime scrollXDate = null;
    private int scrollY;
    private Locale locale = Locale.getDefault();
    private TimeZone timeZone = null;
    private TimeScale scale = TimeScale.CELL_DURATION;
    private TimeCellCollection timeline = new TimeCellCollection();
    private CellWidthSpec cellWidthSpec;
    private LinkCollection links = new LinkCollection();
    private JSONObject callbackData;
    private ViewType viewType = ViewType.RESOURCES;
    private String hourNameBackColor;
    private TimeFormat timeFormat = TimeFormat.AUTO;
    private boolean showNonBusiness = true;
    private int businessBeginsHour = 9;
    private int businessEndsHour = 18;
    private WeekStarts weekStarts = WeekStarts.AUTO;
    private boolean treeEnabled = false;
    private String headerDateFormat = "EEE, d MMMM";
    private String backColor = "#ffffff";
    private String nonBusinessBackColor = "yellow";
    private boolean cssOnly;
    private List<EventInfo> multiselect = new ArrayList<EventInfo>();
    private TimeHeaderCollection timeHeaders = new TimeHeaderCollection();
    private Section viewPort = new Section();
    private ResourceCollection resources = new ResourceCollection();
    private SeparatorCollection separators = new SeparatorCollection();
    private SchedulerTimeHeader timeHeader = new SchedulerTimeHeader(new SchedulerTimeHeaderParent(this));
    private List<Day> rows;
    private String bubbleGuid;
    private JSONObject bubbleResult;
    private String eventSortExpression;
    private SortExpression sortFields = new SortExpression();
    private Collection<Resource> selectedRows;

    private JSONObject callback(JSONObject jSONObject) {
        try {
            Object object;
            Object object2;
            Object object3;
            String string = jSONObject.getString("action");
            JSONObject jSONObject2 = jSONObject.optJSONObject("parameters");
            JSONObject jSONObject3 = jSONObject.optJSONObject("data");
            JSONObject jSONObject4 = jSONObject.getJSONObject("header");
            Version.check(jSONObject4.optString("v"));
            this.id = jSONObject4.getString("id");
            this.setStartDate(jSONObject4.getDateTime("startDate"));
            this.days = jSONObject4.getInt("days");
            this.cellDuration = jSONObject4.getInt("cellDuration");
            this.cellGroupBy = GroupBy.fromString(jSONObject4.getString("cellGroupBy"));
            this.cellWidth = jSONObject4.getInt("cellWidth");
            this.clientState = jSONObject4.getJSONObject("clientState");
            this.cellWidthSpec = CellWidthSpec.fromString(jSONObject4.getString("cellWidthSpec"));
            this.scrollX = jSONObject4.getInt("scrollX");
            this.scrollY = jSONObject4.getInt("scrollY");
            this.viewType = ViewType.parseSoft(jSONObject4.getString("viewType"));
            this.showNonBusiness = jSONObject4.getBoolean("showNonBusiness");
            this.businessBeginsHour = jSONObject4.getInt("businessBeginsHour");
            this.businessEndsHour = jSONObject4.getInt("businessEndsHour");
            this.treeEnabled = jSONObject4.getBoolean("treeEnabled");
            this.locale = LocaleParser.isValid(jSONObject4.optString("locale")) ? LocaleParser.parse(jSONObject4.getString("locale")) : this.locale;
            this.timeHeaders = TimeHeaderCollection.fromJSON(jSONObject4.optJSONArray("timeHeaders"));
            this.timeZone = !Str.isNullOrEmpty(jSONObject4.optString("timeZone")) ? TimeZone.getTimeZone(jSONObject4.optString("timeZone")) : this.timeZone;
            this.timeFormat = TimeFormat.isValid(jSONObject4.optString("timeFormat")) ? TimeFormat.parse(jSONObject4.getString("timeFormat")) : this.timeFormat;
            this.weekStarts = WeekStarts.fromStringJavaScript(jSONObject4.optString("weekStarts"));
            this.cssOnly = true;
            this.scale = TimeScale.fromString(jSONObject4.optString("scale"));
            this.viewPort.start = jSONObject4.optDateTime("rangeStart");
            this.viewPort.end = jSONObject4.optDateTime("rangeEnd");
            this.viewPort.restoreResourcesFromJSON(jSONObject4.getJSONArray("resources"));
            this.selectedRows = this.resourceListFromJSON(jSONObject4.optJSONArray("selectedRows"));
            this.multiselect = EventInfo.listFromJson(jSONObject4.optJSONArray("selected"));
            this.resources.restoreFromJSON(jSONObject4.optJSONArray("tree"));
            this.links.restoreFromJSON(jSONObject4.optJSONArray("links"));
            this.sanityCheck();
            this.onPrepare();
            if (string.equals("Command")) {
                object3 = CommandArgs.fromJSON(jSONObject2, jSONObject3);
                this.onCommand((CommandArgs)object3);
            } else if (string.equals("Notify")) {
                object3 = NotifyArgs.fromJSON(jSONObject2, jSONObject3);
                this.onNotify((NotifyArgs)object3);
            } else if (string.equals("Bubble")) {
                this.bubbleGuid = jSONObject2.optString("guid");
                object3 = jSONObject2.getJSONObject("args");
                object2 = ((JSONObject)object3).optString("type");
                if ("Event".equals(object2)) {
                    object = EventBubbleArgs.fromJSON((JSONObject)object3, jSONObject3);
                    this.onEventBubble((EventBubbleArgs)object);
                    this.bubbleResult = new JSONObject();
                    this.bubbleResult.put("BubbleHTML", ((EventBubbleArgs)object).getBubbleHTML());
                } else if ("Resource".equals(object2)) {
                    object = ResourceBubbleArgs.fromJSON((JSONObject)object3, jSONObject3);
                    this.onResourceBubble((ResourceBubbleArgs)object);
                    this.bubbleResult = new JSONObject();
                    this.bubbleResult.put("BubbleHTML", ((ResourceBubbleArgs)object).getBubbleHTML());
                } else if ("Cell".equals(object2)) {
                    this.bubbleResult = new JSONObject();
                } else if ("Group".equals(object2)) {
                    object = GroupBubbleArgs.fromJSON((JSONObject)object3, jSONObject3);
                    this.onGroupBubble((GroupBubbleArgs)object);
                    this.bubbleResult = new JSONObject();
                    this.bubbleResult.put("BubbleHTML", ((GroupBubbleArgs)object).getBubbleHTML());
                }
            } else if (string.equals("EventBubble")) {
                this.bubbleGuid = jSONObject2.optString("guid");
                object3 = EventBubbleArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventBubble((EventBubbleArgs)object3);
                this.bubbleResult = new JSONObject();
                this.bubbleResult.put("BubbleHTML", ((EventBubbleArgs)object3).getBubbleHTML());
            } else if (string.equals("EventClick")) {
                object3 = EventClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventClick((EventClickArgs)object3);
            } else if (string.equals("EventDoubleClick")) {
                object3 = EventDoubleClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventDoubleClick((EventDoubleClickArgs)object3);
            } else if (string.equals("EventEdit")) {
                object3 = EventEditArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventEdit((EventEditArgs)object3);
            } else if (string.equals("EventMenuClick")) {
                object3 = EventMenuClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventMenuClick((EventMenuClickArgs)object3);
            } else if (string.equals("EventMove")) {
                object3 = EventMoveArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventMove((EventMoveArgs)object3);
            } else if (string.equals("EventResize")) {
                object3 = EventResizeArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventResize((EventResizeArgs)object3);
            } else if (string.equals("EventRightClick")) {
                object3 = EventRightClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventRightClick((EventRightClickArgs)object3);
            } else if (string.equals("RowClick")) {
                object3 = ResourceHeaderClickArgs.fromJSON(this.getResources(), jSONObject2, jSONObject3);
                this.onResourceHeaderClick((ResourceHeaderClickArgs)object3);
                object2 = RowClickArgs.fromJSON(this.getResources(), jSONObject2, jSONObject3);
                this.onRowClick((RowClickArgs)object2);
            } else if (string.equals("RowMenuClick")) {
                object3 = ResourceHeaderMenuClickArgs.fromJSON(this.getResources(), jSONObject2, jSONObject3);
                this.onResourceHeaderMenuClick((ResourceHeaderMenuClickArgs)object3);
                object2 = RowMenuClickArgs.fromJSON(this.getResources(), jSONObject2, jSONObject3);
                this.onRowMenuClick((RowMenuClickArgs)object2);
            } else if (string.equals("TimeRangeDoubleClick")) {
                object3 = TimeRangeDoubleClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onTimeRangeDoubleClick((TimeRangeDoubleClickArgs)object3);
            } else if (string.equals("TimeRangeMenuClick")) {
                object3 = TimeRangeMenuClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onTimeRangeMenuClick((TimeRangeMenuClickArgs)object3);
            } else if (string.equals("TimeRangeSelected")) {
                object3 = TimeRangeSelectedArgs.fromJSON(jSONObject2, jSONObject3);
                this.onTimeRangeSelected((TimeRangeSelectedArgs)object3);
            } else if (string.equals("Scroll")) {
                this.onScroll();
            } else if (string.equals("Init")) {
                this.onInit();
            } else if (string.equals("RowCreate")) {
                object3 = RowCreateArgs.fromJSON(jSONObject2, jSONObject3);
                this.onRowCreate((RowCreateArgs)object3);
            } else if (string.equals("RowMove")) {
                object3 = RowMoveArgs.fromJSON(this.resources, jSONObject2, jSONObject3);
                this.onRowMove((RowMoveArgs)object3);
            } else if (string.equals("RowDoubleClick")) {
                object3 = RowDoubleClickArgs.fromJSON(this.resources, jSONObject2, jSONObject3);
                this.onRowDoubleClick((RowDoubleClickArgs)object3);
            } else if (string.equals("RowSelect")) {
                object3 = RowSelectArgs.fromJSON(this.resources, jSONObject2, jSONObject3);
                this.onRowSelect((RowSelectArgs)object3);
            } else if (string.equals("RowEdit")) {
                object3 = RowEditArgs.fromJSON(this.resources, jSONObject2, jSONObject3);
                this.onRowEdit((RowEditArgs)object3);
            } else if (string.equals("EventDelete")) {
                object3 = EventDeleteArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventDelete((EventDeleteArgs)object3);
            }
            this.onFinish();
            this.sanityCheck();
            object3 = new JSONObject();
            if (this.bubbleGuid != null) {
                ((JSONObject)object3).put("BubbleGuid", this.bubbleGuid);
                ((JSONObject)object3).put("Result", this.bubbleResult);
                return object3;
            }
            ((JSONObject)object3).put("UpdateType", (Object)this.getUpdateType());
            ((JSONObject)object3).put("Action", string);
            ((JSONObject)object3).put("Message", this.updateMessage);
            if (this.getUpdateType() == UpdateType.NONE) {
                return object3;
            }
            this.loadRows();
            this.loadEvents();
            object2 = this.getEventsJSON();
            this.generateResourcesIfGantt((JSONArray)object2);
            ((JSONObject)object3).put("Events", object2);
            ((JSONObject)object3).put("TagFields", this.getDataTagFieldsSplit());
            ((JSONObject)object3).put("CallBackData", this.callbackData);
            if (this.sortFields != null) {
                ((JSONObject)object3).put("SortDirections", this.sortFields.getDirections());
            }
            ((JSONObject)object3).put("SelectedEvents", this.getSelectedEvents());
            if (this.getUpdateType() == UpdateType.FULL) {
                this.timeHeader.prepareTimeline();
                this.timeHeader.prepareGrouplines();
                object = new CellTable(this);
                ((CellTable)object).process();
                ((JSONObject)object3).put("CellProperties", ((CellTable)object).getProperties());
                ((JSONObject)object3).put("CellConfig", ((CellTable)object).getConfig());
                ((JSONObject)object3).put("Resources", this.getResourcesJSON());
                ((JSONObject)object3).put("Separators", this.separators.getJSON());
                ((JSONObject)object3).put("Timeline", this.timeHeader.getTimeline().toJSON());
                ((JSONObject)object3).put("TimeHeader", this.timeHeader.toJSON());
                ((JSONObject)object3).put("TimeHeaders", this.timeHeaders.toJSON());
                ((JSONObject)object3).put("Links", this.links.toJSON());
                ((JSONObject)object3).put("StartDate", this.getStartDate().utc());
                ((JSONObject)object3).put("Days", this.days);
                ((JSONObject)object3).put("CellDuration", this.cellDuration);
                ((JSONObject)object3).put("CellGroupBy", this.cellGroupBy.toString());
                ((JSONObject)object3).put("CellWidth", this.cellWidth);
                ((JSONObject)object3).put("CellWidthSpec", this.cellWidthSpec.toString());
                ((JSONObject)object3).put("ScrollX", this.resolveScrollX());
                ((JSONObject)object3).put("ScrollY", this.scrollY);
                ((JSONObject)object3).put("ViewType", (Object)this.viewType);
                ((JSONObject)object3).put("HourNameBackColor", this.hourNameBackColor);
                ((JSONObject)object3).put("ShowNonBusiness", this.showNonBusiness);
                ((JSONObject)object3).put("BusinessBeginsHour", this.businessBeginsHour);
                ((JSONObject)object3).put("BusinessEndsHour", this.businessEndsHour);
                ((JSONObject)object3).put("TreeEnabled", this.treeEnabled);
                ((JSONObject)object3).put("BackColor", this.backColor);
                ((JSONObject)object3).put("NonBusinessBackColor", this.nonBusinessBackColor);
                ((JSONObject)object3).put("Locale", LocaleFormatter.format(this.locale));
                if (this.timeZone == null) {
                    ((JSONObject)object3).put("TimeZone", (Object)null);
                } else {
                    ((JSONObject)object3).put("TimeZone", this.timeZone.getID());
                }
                ((JSONObject)object3).put("TimeFormat", this.timeFormat.resolve(this.locale).toString());
                ((JSONObject)object3).put("WeekStarts", this.weekStarts.resolve(this.locale).toInt());
                BeforeResHeaderRenderArgs beforeResHeaderRenderArgs = this.getCorner();
                ((JSONObject)object3).put("CornerHTML", beforeResHeaderRenderArgs.getInnerHTML());
                ((JSONObject)object3).put("CornerBackColor", beforeResHeaderRenderArgs.getBackgroundColor());
            }
            return object3;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private JSONArray getSelectedEvents() {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < this.multiselect.size(); ++i) {
            EventInfo eventInfo = this.multiselect.get(i);
            JSONObject jSONObject = eventInfo.toJSON();
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    private void sanityCheck() {
        Ensure.inRange("businessBeginsHour", this.businessBeginsHour, 0, 23);
        Ensure.inRange("businessEndsHour", this.businessEndsHour, 0, 24);
        Ensure.inRange("cellDuration", this.cellDuration, 1, 10080);
        Ensure.inRange("days", this.days, 1, 1500);
    }

    private void generateResourcesIfGantt(JSONArray jSONArray) {
        if (this.viewType != ViewType.GANTT) {
            return;
        }
        this.getResources().clear();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            this.getResources().add(jSONObject.getString("text"), jSONObject.getString("id"));
        }
    }

    private int resolveScrollX() {
        if (this.scrollXDate != null) {
            return this.getPixels(this.scrollXDate).getLeft();
        }
        return this.scrollX;
    }

    public void onInit() throws Exception {
    }

    public void onEventBubble(EventBubbleArgs eventBubbleArgs) throws Exception {
    }

    public void onResourceBubble(ResourceBubbleArgs resourceBubbleArgs) throws Exception {
    }

    public void onGroupBubble(GroupBubbleArgs groupBubbleArgs) throws Exception {
    }

    public void onEventMove(EventMoveArgs eventMoveArgs) throws Exception {
    }

    public void onEventResize(EventResizeArgs eventResizeArgs) throws Exception {
    }

    public void onScroll() throws Exception {
    }

    public void onTimeRangeSelected(TimeRangeSelectedArgs timeRangeSelectedArgs) throws Exception {
    }

    public void onFinish() throws Exception {
    }

    public void onPrepare() throws Exception {
    }

    public void onBeforeTimeHeaderRender(BeforeTimeHeaderRenderArgs beforeTimeHeaderRenderArgs) throws Exception {
    }

    public void onBeforeCellRender(BeforeCellRenderArgs beforeCellRenderArgs) throws Exception {
    }

    public void onIncludeCell(IncludeCellArgs includeCellArgs) {
    }

    public void onCommand(CommandArgs commandArgs) throws Exception {
    }

    public void onNotify(NotifyArgs notifyArgs) throws Exception {
    }

    public void onTimeRangeMenuClick(TimeRangeMenuClickArgs timeRangeMenuClickArgs) throws Exception {
    }

    public void onTimeRangeDoubleClick(TimeRangeDoubleClickArgs timeRangeDoubleClickArgs) throws Exception {
    }

    @Deprecated
    public void onResourceHeaderMenuClick(ResourceHeaderMenuClickArgs resourceHeaderMenuClickArgs) throws Exception {
    }

    public void onRowMenuClick(RowMenuClickArgs rowMenuClickArgs) throws Exception {
    }

    @Deprecated
    public void onResourceHeaderClick(ResourceHeaderClickArgs resourceHeaderClickArgs) throws Exception {
    }

    public void onRowClick(RowClickArgs rowClickArgs) throws Exception {
    }

    public void onEventMenuClick(EventMenuClickArgs eventMenuClickArgs) throws Exception {
    }

    public void onEventRightClick(EventRightClickArgs eventRightClickArgs) throws Exception {
    }

    public void onEventEdit(EventEditArgs eventEditArgs) throws Exception {
    }

    public void onEventDoubleClick(EventDoubleClickArgs eventDoubleClickArgs) throws Exception {
    }

    public void onEventClick(EventClickArgs eventClickArgs) throws Exception {
    }

    public void onBeforeResHeaderRender(BeforeResHeaderRenderArgs beforeResHeaderRenderArgs) throws Exception {
    }

    public void onBeforeEventRender(BeforeEventRenderArgs beforeEventRenderArgs) throws Exception {
    }

    public void onBeforeEventRecurrence(BeforeEventRecurrenceArgs beforeEventRecurrenceArgs) throws Exception {
    }

    public void onRowCreate(RowCreateArgs rowCreateArgs) throws Exception {
    }

    public void onRowDoubleClick(RowDoubleClickArgs rowDoubleClickArgs) throws Exception {
    }

    public void onRowEdit(RowEditArgs rowEditArgs) throws Exception {
    }

    public void onRowMove(RowMoveArgs rowMoveArgs) throws Exception {
    }

    public void onRowSelect(RowSelectArgs rowSelectArgs) throws Exception {
    }

    public void onEventDelete(EventDeleteArgs eventDeleteArgs) throws Exception {
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            httpServletRequest.setCharacterEncoding("UTF-8");
            JSONObject jSONObject = JSONParser.parse(httpServletRequest);
            JSONObject jSONObject2 = this.callback(jSONObject);
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().print(jSONObject2);
            httpServletResponse.getWriter().close();
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private JSONArray getResourcesJSON() {
        JSONArray jSONArray = new JSONArray();
        if (this.resources == null) {
            return jSONArray;
        }
        if (this.resources.size() == 0) {
            return jSONArray;
        }
        switch (this.viewType) {
            case RESOURCES: {
                for (Resource resource : this.resources) {
                    JSONObject jSONObject = this.doBeforeResHeaderRender(resource);
                    jSONArray.put(jSONObject);
                }
                break;
            }
            case GANTT: {
                for (Resource resource : this.resources) {
                    JSONObject jSONObject = this.doBeforeResHeaderRender(resource);
                    jSONArray.put(jSONObject);
                }
                break;
            }
            case DAYS: {
                throw new UnsupportedOperationException("ViewType=DAYS not supported.");
            }
            default: {
                throw new UnsupportedOperationException("Unsupported ViewType.");
            }
        }
        return jSONArray;
    }

    private JSONObject doBeforeResHeaderRender(Resource resource) {
        BeforeResHeaderRenderArgs beforeResHeaderRenderArgs = BeforeResHeaderRenderArgs.fromResource(resource, this);
        try {
            this.onBeforeResHeaderRender(beforeResHeaderRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", beforeResHeaderRenderArgs.getValue());
        jSONObject.put("name", beforeResHeaderRenderArgs.getName());
        jSONObject.put("html", beforeResHeaderRenderArgs.getInnerHTML());
        jSONObject.put("toolTip", beforeResHeaderRenderArgs.getToolTip());
        jSONObject.put("backColor", beforeResHeaderRenderArgs.getBackgroundColor());
        if (resource.getChildren().size() > 0) {
            JSONArray jSONArray = new JSONArray();
            for (Resource resource2 : resource.getChildren()) {
                jSONArray.put(this.doBeforeResHeaderRender(resource2));
            }
            jSONObject.put("children", jSONArray);
        }
        jSONObject.put("expanded", resource.isExpanded());
        if (!resource.isChildrenLoaded()) {
            jSONObject.put("dynamicChildren", true);
        }
        jSONObject.put("columns", resource.getColumnsJSON());
        jSONObject.put("areas", beforeResHeaderRenderArgs.getAreas().getJSON());
        return jSONObject;
    }

    private BeforeResHeaderRenderArgs getCorner() {
        BeforeResHeaderRenderArgs beforeResHeaderRenderArgs = BeforeResHeaderRenderArgs.fromCorner(this);
        try {
            this.onBeforeResHeaderRender(beforeResHeaderRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return beforeResHeaderRenderArgs;
    }

    private JSONArray getEventsJSON() {
        JSONArray jSONArray = new JSONArray();
        if (this.events.size() == 0) {
            return jSONArray;
        }
        for (Event event : this.items) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("id", event.getId());
            jSONObject.put("text", event.getText());
            jSONObject.put("start", event.getStart());
            jSONObject.put("end", event.getEnd());
            if (event.getResourceId() != null) {
                jSONObject.put("resource", event.getResourceId());
            }
            if (event.getJoin() != null) {
                jSONObject.put("join", event.getJoin());
            }
            if (event.isRecurrent()) {
                jSONObject.put("recurrent", true);
                jSONObject.put("recurrentMasterId", event.getRecurrentMasterId());
            }
            if (event.getTags() != null) {
                JSONArray jSONArray2 = new JSONArray();
                for (String string : this.getDataTagFieldsSplit()) {
                    jSONArray2.put(event.getTags().get(string));
                }
                jSONObject.put("tag", jSONArray2);
            }
            if (event.getSort() != null) {
                jSONObject.put("sort", event.getSort());
            }
            this.doBeforeEventRender(jSONObject, event.getSource());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    private void loadEvents() {
        try {
            Object object;
            Object object2;
            this.items = new ArrayList<Event>();
            if (this.events == null) {
                return;
            }
            if (this.events.size() == 0) {
                return;
            }
            ArrayList<RecurEx> arrayList = new ArrayList<RecurEx>();
            ArrayList<RecurEvent> arrayList2 = new ArrayList<RecurEvent>();
            for (Object object4 : this.events) {
                Object object3;
                Object object5;
                String[] stringArray;
                object2 = new EventBean(object4);
                ((EventBean)object2).setUseUtc(this.useUtcDates);
                String string = ((EventBean)object2).getString(this.dataIdField);
                Object object6 = ((EventBean)object2).getString(this.dataTextField);
                object = ((EventBean)object2).getDateTime(this.dataStartField);
                DateTime dateTime = ((EventBean)object2).getDateTime(this.dataEndField);
                String string2 = null;
                if (this.dataResourceField != null) {
                    string2 = ((EventBean)object2).getString(this.dataResourceField);
                }
                String string3 = null;
                if (this.dataJoinField != null) {
                    string3 = ((EventBean)object2).getString(this.dataJoinField);
                }
                TagCollection tagCollection = null;
                if (this.dataTagFields != null) {
                    stringArray = this.getDataTagFieldsSplit();
                    object5 = new ArrayList();
                    for (String string4 : this.getDataTagFieldsSplit()) {
                        object5.add(((EventBean)object2).getString(string4));
                    }
                    tagCollection = new TagCollection(stringArray, object5.toArray(new String[0]));
                }
                stringArray = null;
                if (this.sortFields != null) {
                    stringArray = new String[this.sortFields.getFields().length];
                    for (int i = 0; i < this.sortFields.getFields().length; ++i) {
                        object3 = ((EventBean)object2).getString(this.sortFields.getFields()[i]);
                        stringArray[i] = DateTime.canParse((String)object3) ? DateTime.parseString((String)object3).toStringSortable() : object3;
                    }
                }
                object5 = new Event((DateTime)object, dateTime, string, (String)object6, string2, tagCollection, stringArray, false);
                ((Event)object5).setSource(object4);
                ((Event)object5).setJoin(string3);
                if (Str.isNullOrEmpty(this.dataRecurrenceField)) {
                    object3 = this.doBeforeEventRecurrence((Event)object5);
                    if (((BeforeEventRecurrenceArgs)object3).getRule() != null) {
                        RecurEvent recurEvent = RecurEvent.fromRule(((BeforeEventRecurrenceArgs)object3).getRule(), (DateTime)object, dateTime, string, object5);
                        recurEvent.setFirstDayOfWeek(this.getResolvedWeekStart());
                        arrayList2.add(recurEvent);
                    }
                } else {
                    object3 = ((EventBean)object2).getString(this.dataRecurrenceField);
                    RecurInfo recurInfo = RecurInfo.parse((String)object3, string, (DateTime)object, dateTime, object5);
                    switch (recurInfo.getType()) {
                        case DELETED: {
                            arrayList.add((RecurEx)recurInfo);
                            break;
                        }
                        case MODIFIED: {
                            arrayList.add((RecurEx)recurInfo);
                            break;
                        }
                        case EVENT: {
                            arrayList2.add((RecurEvent)recurInfo);
                            break;
                        }
                    }
                    if (recurInfo.getType() != RecurType.NONE) continue;
                }
                this.items.add((Event)object5);
            }
            for (RecurEvent recurEvent : arrayList2) {
                for (RecurEx recurEx : arrayList) {
                    recurEvent.addRecurexSilent(recurEx);
                }
                object2 = (Event)recurEvent.getTag();
                for (Object object6 : recurEvent.occurrences(this.startDate.addDays(this.days))) {
                    object = new Event(((Occurrence)object6).getStart(), ((Occurrence)object6).getEnd(), ((Occurrence)object6).getId(), ((Event)object2).getText(), ((Event)object2).getResourceId(), ((Event)object2).getTags(), ((Event)object2).getSort(), ((Event)object2).isAllDay());
                    if (((Occurrence)object6).isModified()) {
                        object = (Event)((Occurrence)object6).getTag();
                    }
                    ((Event)object).setRecurrentMasterId(((Event)object2).getId());
                    ((Event)object).setRecurrent(true);
                    if (!((Event)object).getEnd().afterOrEqual(this.startDate)) continue;
                    this.items.add((Event)object);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private BeforeEventRecurrenceArgs doBeforeEventRecurrence(Event event) {
        BeforeEventRecurrenceArgs beforeEventRecurrenceArgs = new BeforeEventRecurrenceArgs(event);
        try {
            this.onBeforeEventRecurrence(beforeEventRecurrenceArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return beforeEventRecurrenceArgs;
    }

    private void doBeforeEventRender(JSONObject jSONObject, Object object) {
        BeforeEventRenderArgs beforeEventRenderArgs = new BeforeEventRenderArgs(jSONObject, this.getDataTagFieldsSplit(), object);
        beforeEventRenderArgs.setToolTip(Xml.escape(beforeEventRenderArgs.getText()));
        beforeEventRenderArgs.setInnerHTML(Xml.escape(beforeEventRenderArgs.getText()));
        beforeEventRenderArgs.setDurationBarVisible(true);
        try {
            this.onBeforeEventRender(beforeEventRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (beforeEventRenderArgs.getDurationBarColor() != null) {
            jSONObject.put("barColor", beforeEventRenderArgs.getDurationBarColor());
        }
        if (beforeEventRenderArgs.getDurationBarImageUrl() != null) {
            jSONObject.put("barImageUrl", beforeEventRenderArgs.getDurationBarImageUrl());
        }
        if (!beforeEventRenderArgs.isDurationBarVisible()) {
            jSONObject.put("barHidden", true);
        }
        if (beforeEventRenderArgs.getBackgroundColor() != null) {
            jSONObject.put("backColor", beforeEventRenderArgs.getBackgroundColor());
        }
        if (beforeEventRenderArgs.getDurationBarBackgroundColor() != null) {
            jSONObject.put("barBackColor", beforeEventRenderArgs.getDurationBarBackgroundColor());
        }
        if (beforeEventRenderArgs.getInnerHTML() != null) {
            jSONObject.put("html", beforeEventRenderArgs.getInnerHTML());
        }
        if (beforeEventRenderArgs.getToolTip() != null) {
            jSONObject.put("toolTip", beforeEventRenderArgs.getToolTip());
        }
        if (beforeEventRenderArgs.getStaticBubbleHTML() != null) {
            jSONObject.put("bubbleHtml", beforeEventRenderArgs.getStaticBubbleHTML());
        }
        if (beforeEventRenderArgs.getContextMenuClientName() != null) {
            jSONObject.put("contextMenu", beforeEventRenderArgs.getContextMenuClientName());
        }
        if (beforeEventRenderArgs.getCssClass() != null) {
            jSONObject.put("cssClass", beforeEventRenderArgs.getCssClass());
        }
        if (beforeEventRenderArgs.getBackgroundImage() != null) {
            jSONObject.put("backImage", beforeEventRenderArgs.getBackgroundImage());
        }
        if (beforeEventRenderArgs.getBackgroundRepeat() != null) {
            jSONObject.put("backRepeat", beforeEventRenderArgs.getBackgroundRepeat());
        }
        jSONObject.put("areas", beforeEventRenderArgs.getAreas().getJSON());
        jSONObject.put("complete", beforeEventRenderArgs.getPercentComplete());
        if (!beforeEventRenderArgs.isEventClickEnabled()) {
            jSONObject.put("clickDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventResizeEnabled()) {
            jSONObject.put("resizeDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventMoveEnabled()) {
            jSONObject.put("moveDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventMoveHorizontalEnabled()) {
            jSONObject.put("moveHDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventMoveVerticalEnabled()) {
            jSONObject.put("moveVDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventDeleteEnabled()) {
            jSONObject.put("deleteDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventDoubleClickEnabled()) {
            jSONObject.put("doubleClickDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventRightClickEnabled()) {
            jSONObject.put("rightClickDisabled", true);
        }
        if (beforeEventRenderArgs.getContainer() != null) {
            jSONObject.put("container", beforeEventRenderArgs.getContainer());
        }
        if (beforeEventRenderArgs.getVersions() != null && beforeEventRenderArgs.getVersions().size() > 0) {
            jSONObject.put("versions", beforeEventRenderArgs.getVersions().getJSON());
        }
        if (beforeEventRenderArgs.getHeight() != null) {
            jSONObject.put("height", beforeEventRenderArgs.getHeight());
        }
    }

    private String[] getDataTagFieldsSplit() {
        if (this.dataTagFields == null || "".equals(this.dataTagFields)) {
            return new String[0];
        }
        String[] stringArray = this.dataTagFields.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public TimeHeaderCollection getTimeHeaders() {
        if (this.timeHeaders == null) {
            TimeHeaderCollection timeHeaderCollection = new TimeHeaderCollection();
            timeHeaderCollection.add(new TimeHeader(this.cellGroupBy));
            this.timeHeaders = timeHeaderCollection;
        }
        return this.timeHeaders;
    }

    public String getDataValueField() {
        return this.dataIdField;
    }

    public void setDataIdField(String string) {
        this.dataIdField = string;
    }

    public String getDataTextField() {
        return this.dataTextField;
    }

    public void setDataTextField(String string) {
        this.dataTextField = string;
    }

    public String getDataStartField() {
        return this.dataStartField;
    }

    public void setDataStartField(String string) {
        this.dataStartField = string;
    }

    public String getDataEndField() {
        return this.dataEndField;
    }

    public void setDataEndField(String string) {
        this.dataEndField = string;
    }

    public String getDataResourceField() {
        return this.dataResourceField;
    }

    public void setDataResourceField(String string) {
        this.dataResourceField = string;
    }

    public Collection getEvents() {
        return this.events;
    }

    public void setEvents(Collection collection) {
        this.events = collection;
    }

    public void update(UpdateType updateType) {
        this.updateType = updateType;
    }

    public void update(JSONObject jSONObject, UpdateType updateType) {
        this.update(updateType);
        this.callbackData = jSONObject;
    }

    public void update() {
        this.updateType = UpdateType.EVENTS_ONLY;
    }

    public void updateWithMessage(String string, UpdateType updateType) {
        this.updateType = updateType;
        this.updateMessage = string;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(UpdateType updateType) {
        this.updateType = updateType;
    }

    private void loadRows() {
        this.rows = new ArrayList<Day>();
        if (this.viewType == ViewType.RESOURCES) {
            if (this.resources == null) {
                return;
            }
            this.loadResourcesTree(this.treeEnabled);
        } else {
            for (int i = 0; i < this.days; ++i) {
                DateTime dateTime = this.getStartDate().addDays(i);
                Day day = new Day(dateTime, dateTime.addDays(1), dateTime.toString(this.headerDateFormat), null, this.cellDuration, dateTime.toString(this.headerDateFormat));
                this.rows.add(day);
            }
        }
    }

    private void loadResourcesTree(boolean bl) {
        this.loadResources(this.resources, 0, 0, null, bl, false);
    }

    private int loadResources(ResourceCollection resourceCollection, int n, int n2, TreeDay treeDay, boolean bl, boolean bl2) {
        if (resourceCollection == null) {
            return n;
        }
        for (Resource resource : resourceCollection) {
            TreeDay treeDay2 = new TreeDay(resource, this.getStartDate(), this.getStartDate().addDays(this.days), this.cellDuration);
            treeDay2.setColumns(resource.getColumns());
            treeDay2.setLoaded(resource.isChildrenLoaded());
            treeDay2.setLevel(n2);
            treeDay2.setIndex(n);
            treeDay2.setHidden(bl2);
            this.rows.add(treeDay2);
            if (treeDay != null) {
                treeDay.getChildren().add(n);
            }
            ++n;
            if (!bl) continue;
            boolean bl3 = bl2 || !treeDay2.isExpanded();
            n = this.loadResources(resource.getChildren(), n, n2 + 1, treeDay2, true, bl3);
        }
        return n;
    }

    int getDaysHorizontally() {
        switch (this.viewType) {
            case DAYS: {
                return 1;
            }
            case RESOURCES: {
                return this.days;
            }
            case GANTT: {
                return this.days;
            }
        }
        throw new RuntimeException("Unrecognized viewType value.");
    }

    private void fillTimeHeaderGroupHTML(TimeHeaderCell timeHeaderCell, DateTime dateTime, DateTime dateTime2, int n) {
        switch (this.cellGroupBy) {
            case HOUR: {
                timeHeaderCell.setInnerHTML(TimeFormatter.getHour(dateTime, this.timeFormat, "%d %s", this.locale));
                break;
            }
            case DAY: {
                timeHeaderCell.setInnerHTML(dateTime.toString("EEE, d MMMM yyyy", this.locale));
                break;
            }
            case WEEK: {
                DateTime dateTime3 = dateTime2.addSeconds(-1);
                if (n < 115) {
                    timeHeaderCell.setInnerHTML(String.format("%d", Week.weekNrISO8601(dateTime)));
                    timeHeaderCell.setToolTip(String.format("Week %d (%s)", Week.weekNrISO8601(dateTime), dateTime3.toString("MMMM yyyy", this.locale)));
                    break;
                }
                timeHeaderCell.setInnerHTML(String.format("Week %d (%s)", Week.weekNrISO8601(dateTime), dateTime3.toString("MMMM yyyy", this.locale)));
                break;
            }
            case MONTH: {
                timeHeaderCell.setInnerHTML(dateTime.toString("MMMM yyyy", this.locale));
                break;
            }
            case YEAR: {
                timeHeaderCell.setInnerHTML(dateTime.toString("yyyy", this.locale));
                break;
            }
            case NONE: {
                timeHeaderCell.setInnerHTML("");
                break;
            }
            default: {
                throw new RuntimeException("Unexpected groupby value.");
            }
        }
    }

    protected DayOfWeek getResolvedWeekStart() {
        switch (this.weekStarts) {
            case SUNDAY: {
                return DayOfWeek.SUNDAY;
            }
            case MONDAY: {
                return DayOfWeek.MONDAY;
            }
            case TUESDAY: {
                return DayOfWeek.TUESDAY;
            }
            case WEDNESDAY: {
                return DayOfWeek.WEDNESDAY;
            }
            case THURSDAY: {
                return DayOfWeek.THURSDAY;
            }
            case FRIDAY: {
                return DayOfWeek.FRIDAY;
            }
            case SATURDAY: {
                return DayOfWeek.SATURDAY;
            }
            case AUTO: {
                return DayOfWeek.getDefaultWeekStart();
            }
        }
        throw new RuntimeException("This weekStarts value is not supported (" + (Object)((Object)this.weekStarts) + ").");
    }

    Pixels getPixels(DateTime dateTime) {
        TimeHeaderRow timeHeaderRow = this.timeHeader.getTimeline();
        DateTime dateTime2 = dateTime;
        DateTime dateTime3 = DateTime.MAX;
        Pixels pixels = null;
        if (timeHeaderRow.size() == 0 || dateTime2.before(((TimeHeaderCell)timeHeaderRow.get(0)).getStart())) {
            pixels = new Pixels();
            pixels.setCut(false);
            pixels.setLeft(0);
            pixels.setBoxLeft(pixels.getLeft());
            pixels.setBoxRight(pixels.getLeft());
            return pixels;
        }
        for (int i = 0; i < timeHeaderRow.size(); ++i) {
            TimeHeaderCell timeHeaderCell = (TimeHeaderCell)timeHeaderRow.get(i);
            DateTime dateTime4 = timeHeaderCell.getStart();
            DateTime dateTime5 = timeHeaderCell.getEnd();
            if (dateTime4.before(dateTime2) && dateTime2.before(dateTime5)) {
                TimeSpan timeSpan = dateTime2.minus(dateTime4);
                pixels = new Pixels();
                pixels.setCut(false);
                pixels.setLeft(i * this.cellWidth + this.ticksToPixels(timeSpan));
                pixels.setBoxLeft(i * this.cellWidth);
                pixels.setBoxRight((i + 1) * this.cellWidth);
                break;
            }
            if (dateTime4.equals(dateTime2)) {
                pixels = new Pixels();
                pixels.setCut(false);
                pixels.setLeft(i * this.cellWidth);
                pixels.setBoxLeft(pixels.getLeft());
                pixels.setBoxRight(pixels.getLeft());
                break;
            }
            if (dateTime5.equals(dateTime2)) {
                pixels = new Pixels();
                pixels.setCut(false);
                pixels.setLeft((i + 1) * this.cellWidth);
                pixels.setBoxLeft(pixels.getLeft());
                pixels.setBoxRight(pixels.getLeft());
                break;
            }
            if (dateTime2.before(dateTime4) && dateTime2.after(dateTime3)) {
                pixels = new Pixels();
                pixels.setCut(true);
                pixels.setLeft(i * this.cellWidth);
                pixels.setBoxLeft(pixels.getLeft());
                pixels.setBoxRight(pixels.getLeft());
                break;
            }
            dateTime3 = dateTime5;
        }
        if (pixels == null) {
            pixels = new Pixels();
            pixels.setCut(true);
            pixels.setLeft(timeHeaderRow.size() * this.cellWidth);
            pixels.setBoxLeft(pixels.getLeft());
            pixels.setBoxRight(pixels.getLeft());
        }
        return pixels;
    }

    private int ticksToPixels(TimeSpan timeSpan) {
        return (int)Math.floor((double)this.cellWidth * timeSpan.getTotalMinutes() / (double)this.cellDuration);
    }

    CellTableCell getCell(DateTime dateTime, DateTime dateTime2, String string) {
        BeforeCellRenderArgs beforeCellRenderArgs = new BeforeCellRenderArgs(dateTime, dateTime.addMinutes(this.cellDuration), string);
        beforeCellRenderArgs.setBackgroundColor("");
        boolean bl = this.isBusinessCell(dateTime, dateTime2);
        beforeCellRenderArgs.setBusiness(bl);
        if (this.cssOnly) {
            try {
                this.onBeforeCellRender(beforeCellRenderArgs);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        Object object = beforeCellRenderArgs.isBusiness() ? this.backColor : this.nonBusinessBackColor;
        beforeCellRenderArgs.setBackgroundColor((String)object);
        try {
            this.onBeforeCellRender(beforeCellRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (beforeCellRenderArgs.backgroundColorEquals((String)object) && beforeCellRenderArgs.isBusiness() != bl) {
            if (beforeCellRenderArgs.isBusiness()) {
                beforeCellRenderArgs.setBackgroundColor(this.backColor);
            } else {
                beforeCellRenderArgs.setBackgroundColor(this.nonBusinessBackColor);
            }
        }
        object = new CellTableCell();
        ((CellTableCell)object).setBusiness(beforeCellRenderArgs.isBusiness());
        ((CellTableCell)object).setColor(beforeCellRenderArgs.getBackgroundColor());
        ((CellTableCell)object).setInnerHTML(beforeCellRenderArgs.getInnerHTML());
        ((CellTableCell)object).setBackgroundImage(beforeCellRenderArgs.getBackgroundImage());
        ((CellTableCell)object).setBackgroundRepeat(beforeCellRenderArgs.getBackgroundRepeat());
        ((CellTableCell)object).setBackgroundColor(beforeCellRenderArgs.getBackgroundColor());
        ((CellTableCell)object).setCssClass(beforeCellRenderArgs.getCssClass());
        return object;
    }

    private boolean isBusinessCell(DateTime dateTime, DateTime dateTime2) {
        int n = (int)dateTime2.minus(dateTime).getTotalMinutes();
        if (dateTime2.minus(dateTime).getTicks() > TimeSpan.fromDays(1).getTicks()) {
            return true;
        }
        if (dateTime.getDayOfWeek() == DayOfWeek.SATURDAY || dateTime.getDayOfWeek() == DayOfWeek.SUNDAY) {
            return false;
        }
        if (n < 720) {
            return dateTime.getHour() >= this.getBusinessBeginsHour() && dateTime.getHour() < this.getBusinessEndsHour();
        }
        return true;
    }

    private TimeZone tz() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        return DateTime.UTC;
    }

    public DateTime getStartDate() {
        return this.startDate.tz(this.tz());
    }

    public void setStartDate(DateTime dateTime) {
        this.startDate = dateTime;
    }

    public DateTime getEndDate() {
        return this.getStartDate().addDays(this.days);
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int n) {
        this.days = n;
    }

    public int getCellDuration() {
        return this.cellDuration;
    }

    public void setCellDuration(int n) {
        this.cellDuration = n;
    }

    public GroupBy getCellGroupBy() {
        if (this.cellGroupBy == null) {
            return GroupBy.DAY;
        }
        if (this.cellGroupBy == GroupBy.DEFAULT) {
            return GroupBy.DAY;
        }
        return this.cellGroupBy;
    }

    public void setCellGroupBy(GroupBy groupBy) {
        if (this.timeHeaders == null || this.timeHeaders.size() == 0) {
            throw new RuntimeException("TimeHeaders collection does not contain any header group definition.");
        }
        ((TimeHeader)this.timeHeaders.get(0)).setGroupBy(groupBy);
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int n) {
        this.cellWidth = n;
    }

    public JSONObject getClientState() {
        return this.clientState;
    }

    public void setClientState(JSONObject jSONObject) {
        this.clientState = jSONObject;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public void setScrollX(int n) {
        this.scrollX = n;
    }

    public void setScrollX(DateTime dateTime) {
        this.scrollXDate = dateTime;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(int n) {
        this.scrollY = n;
    }

    public ResourceCollection getResources() {
        return this.resources;
    }

    public SeparatorCollection getSeparators() {
        return this.separators;
    }

    public String getHourNameBackColor() {
        return this.hourNameBackColor;
    }

    public void setHourNameBackColor(String string) {
        this.hourNameBackColor = string;
    }

    int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.timeHeader.getTimeline().size();
    }

    Day getRow(int n) {
        return this.rows.get(n);
    }

    public TimeHeaderCell getColumn(int n) {
        return (TimeHeaderCell)this.timeHeader.getTimeline().get(n);
    }

    public Section getViewPort() {
        return this.viewPort;
    }

    public String getDataTagFields() {
        return this.dataTagFields;
    }

    public void setDataTagFields(String string) {
        this.dataTagFields = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    public boolean isShowNonBusiness() {
        return this.showNonBusiness;
    }

    public void setShowNonBusiness(boolean bl) {
        this.showNonBusiness = bl;
    }

    public int getBusinessBeginsHour() {
        return this.businessBeginsHour;
    }

    public void setBusinessBeginsHour(int n) {
        this.businessBeginsHour = n;
    }

    public int getBusinessEndsHour() {
        return this.businessEndsHour;
    }

    public void setBusinessEndsHour(int n) {
        this.businessEndsHour = n;
    }

    public WeekStarts getWeekStarts() {
        return this.weekStarts;
    }

    public void setWeekStarts(WeekStarts weekStarts) {
        this.weekStarts = weekStarts;
    }

    public boolean isTreeEnabled() {
        return this.treeEnabled;
    }

    public void setTreeEnabled(boolean bl) {
        this.treeEnabled = bl;
    }

    public String getHeaderDateFormat() {
        return this.headerDateFormat;
    }

    public void setHeaderDateFormat(String string) {
        this.headerDateFormat = string;
    }

    public String getBackColor() {
        return this.backColor;
    }

    public void setBackColor(String string) {
        this.backColor = string;
    }

    public String getNonBusinessBackColor() {
        return this.nonBusinessBackColor;
    }

    public void setNonBusinessBackColor(String string) {
        this.nonBusinessBackColor = string;
    }

    public String getId() {
        return this.id;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    SchedulerTimeHeader getTimeHeader() {
        return this.timeHeader;
    }

    public boolean isUseUtcDates() {
        return this.useUtcDates;
    }

    public void setUseUtcDates(boolean bl) {
        this.useUtcDates = bl;
    }

    public boolean isCssOnly() {
        return this.cssOnly;
    }

    public void setCssOnly(boolean bl) {
        this.cssOnly = bl;
    }

    public DateTime getVisibleStart() {
        DateTime dateTime = this.startDate;
        if (this.scale == TimeScale.MANUAL) {
            if (this.timeline.size() == 0) {
                throw new RuntimeException("The Timeline doesn't contain any cells (Scale='Manual' mode)");
            }
            dateTime = ((TimeCell)this.timeline.get(0)).getStart().tz(this.timeZone);
        }
        return dateTime.tz(this.timeZone);
    }

    public DateTime getVisibleEnd() {
        if (this.scale == TimeScale.MANUAL) {
            if (this.timeline.size() == 0) {
                throw new RuntimeException("The Timeline doesn't contain any cells (Scale='Manual' mode)");
            }
            return ((TimeCell)this.timeline.get(this.timeline.size() - 1)).getEnd();
        }
        DateTime dateTime = this.startDate.addDays(this.days);
        return dateTime;
    }

    public TimeScale getScale() {
        return this.scale;
    }

    public void setScale(TimeScale timeScale) {
        this.scale = timeScale;
    }

    public TimeCellCollection getTimeline() {
        return this.timeline;
    }

    public void setTimeline(TimeCellCollection timeCellCollection) {
        this.timeline = timeCellCollection;
    }

    TimeHeaderCollection getTimeHeadersResolved() {
        if (this.timeHeaders.size() > 0) {
            return this.timeHeaders;
        }
        TimeHeaderCollection timeHeaderCollection = new TimeHeaderCollection();
        timeHeaderCollection.add(new TimeHeader(GroupBy.DEFAULT));
        timeHeaderCollection.add(new TimeHeader(GroupBy.CELL));
        return timeHeaderCollection;
    }

    public CellWidthSpec getCellWidthSpec() {
        return this.cellWidthSpec;
    }

    public void setCellWidthSpec(CellWidthSpec cellWidthSpec) {
        this.cellWidthSpec = cellWidthSpec;
    }

    public void doIncludeCell(IncludeCellArgs includeCellArgs) {
        this.onIncludeCell(includeCellArgs);
    }

    private Collection<Resource> resourceListFromJSON(JSONArray jSONArray) {
        if (jSONArray == null) {
            return new ArrayList<Resource>();
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            int n = jSONArray.getJSONObject(i).getInt("index");
            Resource resource = this.resources.findByIndex(n);
            arrayList.add(resource);
        }
        return arrayList;
    }

    public Collection<Resource> getSelectedRows() {
        return this.selectedRows;
    }

    public String getDataRecurrenceField() {
        return this.dataRecurrenceField;
    }

    public void setDataRecurrenceField(String string) {
        this.dataRecurrenceField = string;
    }

    public String getEventSortExpression() {
        return this.eventSortExpression;
    }

    public void setEventSortExpression(String string) {
        if (!SortExpression.isValid(string)) {
            throw new IllegalArgumentException("Invalid EventSortExpression format. Valid example: \"start asc, end desc\"");
        }
        this.sortFields = SortExpression.parse(string);
        this.eventSortExpression = string;
    }

    public LinkCollection getLinks() {
        return this.links;
    }

    public String getDataJoinField() {
        return this.dataJoinField;
    }

    public void setDataJoinField(String string) {
        this.dataJoinField = string;
    }

    public String getDataIdField() {
        return this.dataIdField;
    }

    public List<EventInfo> getMultiselect() {
        return this.multiselect;
    }

    public class Section {
        private DateTime start;
        private DateTime end;
        private List<String> resources = new ArrayList<String>();

        public Date getStart() {
            return this.start.toTimeStamp();
        }

        public Date getEnd() {
            return this.end.toTimeStamp();
        }

        public List<String> getResources() {
            return this.resources;
        }

        void restoreResourcesFromJSON(JSONArray jSONArray) {
            this.resources.clear();
            for (int i = 0; i < jSONArray.length(); ++i) {
                this.resources.add(jSONArray.getString(i));
            }
        }
    }
}

