/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.util.ArrayList;
import java.util.List;
import org.daypilot.ui.Block;
import org.daypilot.ui.EventPart;

class EventColumn {
    private List<EventPart> events = new ArrayList<EventPart>();
    private Block block;

    EventColumn() {
    }

    public int getWidthPct() {
        if (this.block == null) {
            throw new RuntimeException("This EventColumn does not belong to any Block.");
        }
        if (this.block.getColumns().size() == 0) {
            throw new RuntimeException("Internal error: Problem with Block.EventColumn.Counts (it is zero).");
        }
        if (this.isLastInBlock()) {
            return 100 / this.block.getColumns().size() + 100 % this.block.getColumns().size();
        }
        return 100 / this.block.getColumns().size();
    }

    public int startsAtPct() {
        if (this.block == null) {
            throw new RuntimeException("This EventColumn does not belong to any Block.");
        }
        if (this.block.getColumns().size() == 0) {
            throw new RuntimeException("Internal error: Problem with Block.EventColumn.Counts (it is zero).");
        }
        return 100 / this.block.getColumns().size() * this.getNumber();
    }

    private boolean isLastInBlock() {
        return this.block.getColumns().get(this.block.getColumns().size() - 1) == this;
    }

    public boolean canAdd(EventPart eventPart) {
        for (EventPart eventPart2 : this.events) {
            if (!eventPart2.overlapsWith(eventPart)) continue;
            return false;
        }
        return true;
    }

    public void add(EventPart eventPart) {
        if (eventPart.getEvColumn() != null) {
            throw new RuntimeException("This EventPart was already placed into a EventColumn.");
        }
        this.events.add(eventPart);
        eventPart.setEvColumn(this);
    }

    public int getNumber() {
        if (this.block == null) {
            throw new RuntimeException("This EventColumn doesn't belong to any Block.");
        }
        return this.block.getColumns().indexOf(this);
    }

    public void setBlock(Block block) {
        this.block = block;
    }
}

