/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import org.daypilot.date.DateTime;
import org.daypilot.date.TimeSpan;
import org.daypilot.ui.Day;
import org.daypilot.ui.Event;
import org.daypilot.ui.EventColumn;
import org.daypilot.ui.enums.UseBoxes;

class EventPart {
    private Event ev;
    private EventColumn evColumn;
    private Day row;

    public Event getEvent() {
        return this.ev;
    }

    public EventPart(Day day, Event event) {
        this.ev = event;
        this.row = day;
    }

    public DateTime getStart() {
        if (this.ev.getStart().before(this.row.getStart())) {
            return this.row.getStart();
        }
        return this.ev.getStart();
    }

    public DateTime getEnd() {
        if (this.ev.getEnd().after(this.row.getEnd())) {
            return this.row.getEnd();
        }
        return this.ev.getEnd();
    }

    public boolean useBox() {
        return this.row.getUseEventBoxes() == UseBoxes.ALWAYS || this.row.getUseEventBoxes() == UseBoxes.SHORT_EVENTS_ONLY && this.duration().getTotalMinutes() < (double)this.row.getCellDuration();
    }

    private TimeSpan duration() {
        return this.getEnd().minus(this.getStart());
    }

    public DateTime getBoxStart() {
        if (!this.useBox()) {
            return this.getStart();
        }
        TimeSpan timeSpan = this.getStart().getTimeOfDay();
        int n = (int)Math.floor(timeSpan.getTotalMinutes());
        n = n / this.row.getCellDuration() * this.row.getCellDuration();
        DateTime dateTime = this.getStart().getDatePart();
        DateTime dateTime2 = dateTime.addMinutes(n);
        return dateTime2;
    }

    public DateTime getBoxEnd() {
        if (!this.useBox()) {
            return this.getEnd();
        }
        TimeSpan timeSpan = this.getEnd().getTimeOfDay();
        int n = (int)Math.floor(timeSpan.getTotalMinutes());
        int n2 = n / this.row.getCellDuration() * this.row.getCellDuration();
        DateTime dateTime = this.getEnd().getDatePart();
        DateTime dateTime2 = dateTime.addMinutes(n2);
        if (timeSpan.getTotalMinutes() % (double)this.row.getCellDuration() != 0.0 || this.duration().isZero()) {
            return dateTime2.addMinutes(this.row.getCellDuration());
        }
        return dateTime2;
    }

    public boolean overlapsWith(EventPart eventPart) {
        return this.getBoxStart().before(eventPart.getBoxEnd()) && this.getBoxEnd().after(eventPart.getStart());
    }

    public EventColumn getEvColumn() {
        return this.evColumn;
    }

    public void setEvColumn(EventColumn eventColumn) {
        this.evColumn = eventColumn;
    }
}

