/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.daypilot.data.TimeCell;
import org.daypilot.data.TimeHeader;
import org.daypilot.data.TimeHeaderCell;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.date.TimeFormatter;
import org.daypilot.date.TimeSpan;
import org.daypilot.date.Week;
import org.daypilot.json.JSONArray;
import org.daypilot.ui.ITimeHeaderParent;
import org.daypilot.ui.Pixels;
import org.daypilot.ui.TimeHeaderRow;
import org.daypilot.ui.args.scheduler.BeforeTimeHeaderRenderArgs;
import org.daypilot.ui.enums.GroupBy;
import org.daypilot.ui.enums.TimeFormat;
import org.daypilot.ui.enums.TimeScale;
import org.daypilot.util.Str;

class SchedulerTimeHeader {
    private TimeHeaderRow _timeline = null;
    private List<TimeHeaderRow> _grouplines = null;
    private ITimeHeaderParent _scheduler;

    SchedulerTimeHeader(ITimeHeaderParent iTimeHeaderParent) {
        this._scheduler = iTimeHeaderParent;
    }

    JSONArray toJSON() {
        JSONArray jSONArray = new JSONArray();
        for (TimeHeaderRow timeHeaderRow : this._grouplines) {
            jSONArray.put(timeHeaderRow.toJSON());
        }
        return jSONArray;
    }

    TimeHeaderRow getTimeline() {
        return this._timeline;
    }

    private DateTime getStartDate() {
        return this._scheduler.getVisibleStart();
    }

    private DateTime getEndDate() {
        if (this._scheduler.isDaysMode()) {
            return this._scheduler.getStartDate().addDays(1);
        }
        return this._scheduler.getVisibleEnd();
    }

    private TimeHeaderRow prepareGroupline(int n) {
        TimeHeaderRow timeHeaderRow = new TimeHeaderRow();
        GroupBy groupBy = ((TimeHeader)this._scheduler.getTimeHeadersResolved().get(n)).getGroupBy();
        String string = ((TimeHeader)this._scheduler.getTimeHeadersResolved().get(n)).getFormat();
        if (groupBy == GroupBy.DEFAULT) {
            groupBy = this._scheduler.getCellGroupBy();
        }
        if (this._scheduler.isDaysMode() && groupBy != GroupBy.HOUR && groupBy != GroupBy.NONE && groupBy != GroupBy.CELL) {
            throw new RuntimeException("Set CellGroupBy property to either Hour or None. Other values are not allowed in Days view.");
        }
        DateTime dateTime = this.getEndDate();
        DateTime dateTime2 = ((TimeHeaderCell)this.getTimeline().get(this.getTimeline().size() - 1)).getEnd();
        DateTime dateTime3 = this.getStartDate();
        while (dateTime3.before(dateTime) && dateTime3.before(dateTime2)) {
            DateTime dateTime4 = this.addGroupSize(dateTime3, groupBy);
            int n2 = this.getPixels(dateTime3).getLeft();
            int n3 = this.getPixels(dateTime4).getLeft();
            int n4 = n3 - n2;
            if (n4 <= 0) {
                dateTime3 = dateTime4;
                continue;
            }
            TimeHeaderCell timeHeaderCell = new TimeHeaderCell(this._scheduler, dateTime3, dateTime4);
            timeHeaderCell.setLevel(n);
            timeHeaderCell.setBackColor(this._scheduler.getHourNameBackColor());
            timeHeaderCell.setToolTip("");
            BeforeTimeHeaderRenderArgs beforeTimeHeaderRenderArgs = BeforeTimeHeaderRenderArgs.fromCell(timeHeaderCell);
            if (Str.isNullOrEmpty(string)) {
                timeHeaderCell.setInnerHTML(this.getGroupName(timeHeaderCell, groupBy));
            } else {
                timeHeaderCell.setInnerHTML(timeHeaderCell.getStart().toString(string));
            }
            if (timeHeaderCell.getToolTip().equals("")) {
                timeHeaderCell.setToolTip(timeHeaderCell.getInnerHTML());
            }
            try {
                this._scheduler.doBeforeTimeHeaderRender(beforeTimeHeaderRenderArgs);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            timeHeaderCell.setLeft(n2);
            timeHeaderCell.setWidth(n4);
            timeHeaderRow.add(timeHeaderCell);
            dateTime3 = dateTime4;
        }
        return timeHeaderRow;
    }

    void prepareGrouplines() {
        if (this._timeline == null) {
            throw new RuntimeException("The timeline must be initialized before calling prepareGroupline().");
        }
        this._grouplines = new ArrayList<TimeHeaderRow>();
        for (int i = 0; i < this._scheduler.getTimeHeadersResolved().size(); ++i) {
            TimeHeaderRow timeHeaderRow = this.prepareGroupline(i);
            this._grouplines.add(timeHeaderRow);
        }
    }

    private boolean defaultCellVisibility(DateTime dateTime, DateTime dateTime2) {
        if (this._scheduler.getShowNonBusiness()) {
            return true;
        }
        if (dateTime2.minus(dateTime).getTicks() > TimeSpan.fromDays(1).getTicks()) {
            return true;
        }
        if (dateTime.getDayOfWeek() == DayOfWeek.SUNDAY) {
            return false;
        }
        if (dateTime.getDayOfWeek() == DayOfWeek.SATURDAY) {
            return false;
        }
        if (dateTime2.minus(dateTime).getTicks() < TimeSpan.fromDays(1).getTicks()) {
            double d = dateTime.getTimeOfDay().getTotalHours();
            if (d < (double)this._scheduler.getBusinessBeginsHour()) {
                return false;
            }
            if (this._scheduler.getBusinessEndsHour() >= 24) {
                return true;
            }
            if (d >= (double)this._scheduler.getBusinessEndsHour()) {
                return false;
            }
        }
        return true;
    }

    private boolean includeCell(DateTime dateTime, DateTime dateTime2) {
        return this._scheduler.doIncludeCell(dateTime, dateTime2, this.defaultCellVisibility(dateTime, dateTime2));
    }

    private DateTime addGroupSize(DateTime dateTime, GroupBy groupBy) {
        DateTime dateTime2;
        DateTime dateTime3 = this.getEndDate();
        int n = 60;
        switch (groupBy) {
            case HOUR: {
                dateTime2 = dateTime.addHours(1);
                break;
            }
            case DAY: {
                dateTime2 = dateTime.addDays(1);
                break;
            }
            case WEEK: {
                dateTime2 = dateTime.addDays(1);
                while (dateTime2.getDayOfWeek() != this._scheduler.getResolvedWeekStart()) {
                    dateTime2 = dateTime2.addDays(1);
                }
                break;
            }
            case MONTH: {
                boolean bl;
                dateTime2 = dateTime.addMonths(1);
                dateTime2 = new DateTime(dateTime2.getYear(), dateTime2.getMonth(), 1);
                boolean bl2 = bl = dateTime2.minus(dateTime).getTotalMinutes() % (double)n == 0.0;
                while (!bl) {
                    bl = (dateTime2 = dateTime2.addHours(1)).minus(dateTime).getTotalMinutes() % (double)n == 0.0;
                }
                break;
            }
            case YEAR: {
                boolean bl;
                dateTime2 = dateTime.addYears(1);
                dateTime2 = new DateTime(dateTime2.getYear(), 1, 1);
                boolean bl3 = bl = dateTime2.minus(dateTime).getTotalMinutes() % (double)n == 0.0;
                while (!bl) {
                    bl = (dateTime2 = dateTime2.addHours(1)).minus(dateTime).getTotalMinutes() % (double)n == 0.0;
                }
                break;
            }
            case NONE: {
                dateTime2 = dateTime3;
                break;
            }
            case CELL: {
                TimeHeaderCell timeHeaderCell = this.getItlineCellFromTime(dateTime);
                if (timeHeaderCell != null) {
                    dateTime2 = timeHeaderCell.getEnd();
                    break;
                }
                DateTime dateTime4 = dateTime;
                while (timeHeaderCell == null) {
                    dateTime4 = dateTime4.addMinutes(1);
                    timeHeaderCell = this.getItlineCellFromTime(dateTime4);
                }
                dateTime2 = timeHeaderCell.getStart();
                break;
            }
            default: {
                throw new RuntimeException("Invalid cellGroupBy value: " + (Object)((Object)groupBy));
            }
        }
        if (dateTime2.after(dateTime3)) {
            dateTime2 = dateTime3;
            return dateTime2;
        }
        if (dateTime2.equals(dateTime)) {
            throw new RuntimeException("Internal error while generating a time header (NOPROGRESS).");
        }
        return dateTime2;
    }

    private TimeHeaderCell getItlineCellFromTime(DateTime dateTime) {
        DateTime dateTime2 = dateTime;
        for (int i = 0; i < this.getTimeline().size(); ++i) {
            TimeHeaderCell timeHeaderCell = (TimeHeaderCell)this.getTimeline().get(i);
            if (timeHeaderCell.getStart().beforeOrEqual(dateTime2) && dateTime2.before(timeHeaderCell.getEnd())) {
                return timeHeaderCell;
            }
            if (!dateTime2.before(timeHeaderCell.getStart())) continue;
            return null;
        }
        return (TimeHeaderCell)this.getTimeline().get(this.getTimeline().size() - 1);
    }

    private String getGroupName(TimeHeaderCell timeHeaderCell, GroupBy groupBy) {
        Locale locale = this._scheduler.getLocale();
        TimeFormat timeFormat = this._scheduler.getTimeFormat();
        DateTime dateTime = timeHeaderCell.getStart();
        DateTime dateTime2 = timeHeaderCell.getEnd();
        String string = "";
        switch (groupBy) {
            case HOUR: {
                string = TimeFormatter.getHour(dateTime, timeFormat, "%d %s", locale);
                break;
            }
            case DAY: {
                string = "" + dateTime.getDay();
                break;
            }
            case WEEK: {
                DateTime dateTime3 = dateTime2.addSeconds(-1);
                DateTime dateTime4 = Week.monday(dateTime, this._scheduler.getResolvedWeekStart());
                int n = Week.weekNrISO8601(dateTime4);
                string = "" + n;
                break;
            }
            case MONTH: {
                string = dateTime.toString("MMMM yyyy", locale);
                break;
            }
            case YEAR: {
                string = dateTime.toString("yyyy", locale);
                break;
            }
            case NONE: {
                string = "";
                break;
            }
            case CELL: {
                if (this._scheduler.getScale() == TimeScale.MANUAL || this._scheduler.getScale() == TimeScale.CELL_DURATION) {
                    int n = (int)timeHeaderCell.getEnd().minus(timeHeaderCell.getStart()).getTotalMinutes();
                    string = this.getCellName(dateTime, n);
                    break;
                }
                string = this.getGroupName(timeHeaderCell, GroupBy.fromString(this._scheduler.getScale().toString()));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected groupby value: " + (Object)((Object)groupBy));
            }
        }
        return string;
    }

    private String getCellName(DateTime dateTime, int n) {
        if (n < 60) {
            return String.format("%2d", dateTime.getMinute());
        }
        if (n < 1440) {
            return TimeFormatter.getHour(dateTime, this._scheduler.getTimeFormat(), null, this._scheduler.getLocale());
        }
        if (n < 10080) {
            return "" + dateTime.getDay();
        }
        if (n == 10080) {
            return "" + Week.weekNrISO8601(dateTime);
        }
        return dateTime.toString("MMMM yyyy", this._scheduler.getLocale());
    }

    void prepareTimeline() {
        this._timeline = new TimeHeaderRow();
        if (this._scheduler.getScale() == TimeScale.MANUAL) {
            this.copyTimeline();
        } else {
            this.generateTimeline();
        }
    }

    private void copyTimeline() {
        int n = 0;
        for (TimeCell timeCell : this._scheduler.getTimeline()) {
            DateTime dateTime = timeCell.getStart().tz(this._scheduler.getTimeZone());
            DateTime dateTime2 = timeCell.getEnd().tz(this._scheduler.getTimeZone());
            TimeHeaderCell timeHeaderCell = new TimeHeaderCell(this._scheduler, dateTime, dateTime2);
            timeHeaderCell.setLeft(n);
            timeHeaderCell.setWidth(timeCell.getWidth() != null ? timeCell.getWidth().intValue() : this._scheduler.getCellWidth());
            this.getTimeline().add(timeHeaderCell);
            n += timeHeaderCell.getWidth().intValue();
        }
    }

    private void generateTimeline() {
        DateTime dateTime = this._scheduler.getStartDate();
        DateTime dateTime2 = this._scheduler.isDaysMode() ? this._scheduler.getStartDate().addDays(1) : this._scheduler.getEndDate();
        DateTime dateTime3 = this.addScaleSize(dateTime);
        int n = 0;
        while (dateTime3.beforeOrEqual(dateTime2) && dateTime3.after(dateTime)) {
            if (this.includeCell(dateTime, dateTime3)) {
                TimeHeaderCell timeHeaderCell = new TimeHeaderCell(this._scheduler, dateTime, dateTime3);
                timeHeaderCell.setLeft(n);
                timeHeaderCell.setWidth(this._scheduler.getCellWidth());
                this.getTimeline().add(timeHeaderCell);
                n += this._scheduler.getCellWidth();
            }
            if (dateTime3.equals(dateTime2)) {
                return;
            }
            dateTime = dateTime3;
            dateTime3 = this.addScaleSize(dateTime);
        }
    }

    private DateTime addScaleSize(DateTime dateTime) {
        TimeScale timeScale = this._scheduler.getScale();
        switch (timeScale) {
            case MANUAL: {
                throw new RuntimeException("Internal error (addScaleSize in Manual mode)");
            }
            case MINUTE: {
                return dateTime.addMinutes(1);
            }
            case CELL_DURATION: {
                return dateTime.addMinutes(this._scheduler.getCellDuration());
            }
        }
        return this.addGroupSize(dateTime, GroupBy.fromString(timeScale.toString()));
    }

    private int ticksToPixels(TimeHeaderCell timeHeaderCell, TimeSpan timeSpan) {
        int n = timeHeaderCell.getWidth();
        TimeSpan timeSpan2 = timeHeaderCell.getEnd().minus(timeHeaderCell.getStart());
        return (int)Math.floor((double)n * timeSpan.getTotalMinutes() / timeSpan2.getTotalMinutes());
    }

    Pixels getPixels(DateTime dateTime) {
        DateTime dateTime2 = dateTime;
        DateTime dateTime3 = DateTime.MAX;
        Pixels pixels = null;
        if (this.getTimeline().size() == 0 || dateTime2.before(((TimeHeaderCell)this.getTimeline().get(0)).getStart())) {
            pixels = new Pixels();
            pixels.setCut(false);
            pixels.setLeft(0);
            pixels.setBoxLeft(pixels.getLeft());
            pixels.setBoxRight(pixels.getLeft());
            return pixels;
        }
        for (int i = 0; i < this.getTimeline().size(); ++i) {
            TimeHeaderCell timeHeaderCell = (TimeHeaderCell)this.getTimeline().get(i);
            DateTime dateTime4 = timeHeaderCell.getStart();
            DateTime dateTime5 = timeHeaderCell.getEnd();
            if (dateTime4.before(dateTime2) && dateTime2.before(dateTime5)) {
                TimeSpan timeSpan = dateTime2.minus(dateTime4);
                pixels = new Pixels();
                pixels.setCut(false);
                pixels.setLeft(timeHeaderCell.getLeft() + this.ticksToPixels(timeHeaderCell, timeSpan));
                pixels.setBoxLeft(timeHeaderCell.getLeft());
                pixels.setBoxRight(timeHeaderCell.getRight());
                break;
            }
            if (dateTime4.equals(dateTime2)) {
                pixels = new Pixels();
                pixels.setCut(false);
                pixels.setLeft(timeHeaderCell.getLeft());
                pixels.setBoxLeft(timeHeaderCell.getLeft());
                pixels.setBoxRight(timeHeaderCell.getRight());
                break;
            }
            if (dateTime5.equals(dateTime2)) {
                pixels = new Pixels();
                pixels.setCut(false);
                pixels.setLeft(timeHeaderCell.getRight());
                pixels.setBoxLeft(timeHeaderCell.getRight());
                pixels.setBoxRight(timeHeaderCell.getRight());
                break;
            }
            if (dateTime2.before(dateTime4) && dateTime2.after(dateTime3)) {
                pixels = new Pixels();
                pixels.setCut(true);
                pixels.setLeft(timeHeaderCell.getLeft());
                pixels.setBoxLeft(timeHeaderCell.getLeft());
                pixels.setBoxRight(timeHeaderCell.getLeft());
                break;
            }
            dateTime3 = dateTime5;
        }
        if (pixels == null) {
            TimeHeaderCell timeHeaderCell = (TimeHeaderCell)this.getTimeline().get(this.getTimeline().size() - 1);
            pixels = new Pixels();
            pixels.setCut(true);
            pixels.setLeft(timeHeaderCell.getRight());
            pixels.setBoxLeft(timeHeaderCell.getRight());
            pixels.setBoxRight(timeHeaderCell.getRight());
        }
        return pixels;
    }
}

