/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.args.common;

import org.daypilot.data.TagCollection;
import org.daypilot.date.DateTime;
import org.daypilot.json.JSONObject;

public class EventData {
    private String id;
    private String text;
    private DateTime start;
    private DateTime end;
    private String resource;
    private TagCollection tags;

    private EventData() {
    }

    private void loadEvent(JSONObject jSONObject) {
        this.id = jSONObject.getString("id");
        this.text = jSONObject.getString("text");
        this.start = jSONObject.getDateTime("start");
        this.end = jSONObject.getDateTime("end");
        this.resource = jSONObject.optString("resource");
        this.tags = TagCollection.fromJSON(jSONObject.getJSONObject("tag"));
    }

    public static EventData fromJSON(JSONObject jSONObject) {
        EventData eventData = new EventData();
        eventData.loadEvent(jSONObject);
        return eventData;
    }

    public String getValue() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public String getResource() {
        return this.resource;
    }

    public TagCollection getTags() {
        return this.tags;
    }
}

