/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.args.gantt;

import java.util.ArrayList;
import org.daypilot.data.AreaCollection;
import org.daypilot.data.Task;
import org.daypilot.data.TaskCollection;
import org.daypilot.data.TaskColumn;
import org.daypilot.data.TaskTagMap;
import org.daypilot.date.DateTime;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONObject;
import org.daypilot.ui.DataItemWrapper;
import org.daypilot.ui.DayPilotGantt;
import org.daypilot.ui.args.common.DayPilotArgs;
import org.daypilot.ui.enums.gantt.TaskGroupMode;
import org.daypilot.ui.enums.gantt.TaskType;
import org.daypilot.util.Str;
import org.daypilot.util.Xml;

public class BeforeTaskRenderArgs
extends DayPilotArgs {
    private Task task;
    private DayPilotGantt gantt;
    private String id;
    private DateTime start;
    private DateTime end;
    private String text;
    private TaskType type;
    private DataItemWrapper dataItem;
    private TaskBox box;
    private TaskRow row;
    private TaskTagMap tags;

    public static BeforeTaskRenderArgs fromTask(Task task, DayPilotGantt dayPilotGantt) {
        BeforeTaskRenderArgs beforeTaskRenderArgs = new BeforeTaskRenderArgs();
        beforeTaskRenderArgs.task = task;
        beforeTaskRenderArgs.gantt = dayPilotGantt;
        beforeTaskRenderArgs.id = task.getId();
        beforeTaskRenderArgs.start = task.getStart();
        beforeTaskRenderArgs.end = task.getEnd();
        beforeTaskRenderArgs.text = task.getText();
        beforeTaskRenderArgs.type = task.getType();
        beforeTaskRenderArgs.dataItem = new DataItemWrapper(task.getDataItem());
        beforeTaskRenderArgs.box = beforeTaskRenderArgs.new TaskBox();
        beforeTaskRenderArgs.row = beforeTaskRenderArgs.new TaskRow();
        beforeTaskRenderArgs.loadTags();
        beforeTaskRenderArgs.loadColumns();
        if (task.getType() == TaskType.MILESTONE) {
            beforeTaskRenderArgs.end = beforeTaskRenderArgs.start;
        }
        if (task.getChildren().size() > 0) {
            beforeTaskRenderArgs.type = TaskType.GROUP;
            if (dayPilotGantt.getTaskGroupMode() == TaskGroupMode.AUTO) {
                Task.StartEnd startEnd = task.getChildrenStartEnd();
                beforeTaskRenderArgs.start = startEnd.getStart();
                beforeTaskRenderArgs.end = startEnd.getEnd();
            }
        }
        return beforeTaskRenderArgs;
    }

    private void loadColumns() {
        this.row.columns.clear();
        for (TaskColumn taskColumn : this.gantt.getColumns()) {
            TaskRowColumn taskRowColumn = new TaskRowColumn();
            if (Str.isNullOrEmpty(taskColumn.getProperty())) {
                taskRowColumn.value = this.text;
            } else if (taskColumn.getProperty() != null && taskColumn.getProperty().toLowerCase().equals("text")) {
                taskRowColumn.value = this.text;
            } else if (this.tags.containsKey(taskColumn.getProperty())) {
                taskRowColumn.value = (String)this.tags.get(taskColumn.getProperty());
            }
            taskRowColumn.html = Xml.escape(taskRowColumn.value);
            this.row.columns.add(taskRowColumn);
        }
    }

    private void loadTags() {
        this.tags = new TaskTagMap();
        for (String string : this.task.getTags().keySet()) {
            if (this.task.getTags().get(string) != null) {
                this.tags.put(string, (String)this.task.getTags().get(string));
                continue;
            }
            this.tags.put(string, null);
        }
    }

    public boolean hasChildren() {
        return this.task.getChildren().size() > 0;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = this.task.toJSON();
        JSONObject jSONObject3 = this.box.toJson();
        if (jSONObject3.length() > 0) {
            jSONObject2.put("box", jSONObject3);
        }
        if ((jSONObject = this.row.toJSON()).length() > 0) {
            jSONObject2.put("row", jSONObject);
        }
        return jSONObject2;
    }

    public TaskCollection getChildren() {
        return this.task.getChildren();
    }

    public String getId() {
        return this.id;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public String getText() {
        return this.text;
    }

    public TaskType getType() {
        return this.type;
    }

    public DataItemWrapper getDataItem() {
        return this.dataItem;
    }

    public TaskBox getBox() {
        return this.box;
    }

    public TaskRow getRow() {
        return this.row;
    }

    public TaskTagMap getTags() {
        return this.tags;
    }

    public class TaskBox {
        private String backgroundImage;
        private String backgroundRepeat;
        private String bubbleHtml;
        private String borderColor;
        private boolean rightClickEnabled = true;
        private String cssClass;
        private String toolTip;
        private String contextMenuClientName;
        private AreaCollection areas = new AreaCollection();
        private String barColor;
        private String barBackColor;
        private boolean barVisible = true;
        private String backgroundColor;
        private String html;
        private String htmlRight;
        private String htmlLeft;
        private boolean resizeEnabled = true;
        private boolean moveEnabled = true;
        private boolean clickEnabled = true;
        private boolean doubleClickEnabled = true;
        private boolean deleteEnabled = true;

        TaskBox() {
            this.htmlRight = BeforeTaskRenderArgs.this.task.getText();
        }

        boolean isRegular() {
            return BeforeTaskRenderArgs.this.task.getType() == TaskType.TASK && BeforeTaskRenderArgs.this.task.getChildren().size() == 0;
        }

        JSONObject toJson() {
            JSONObject jSONObject = new JSONObject();
            if (this.areas.size() > 0) {
                jSONObject.put("areas", this.areas.getJSON());
            }
            if (!Str.isNullOrEmpty(this.backgroundImage)) {
                jSONObject.put("backImage", this.backgroundImage);
            }
            if (!Str.isNullOrEmpty(this.backgroundRepeat)) {
                jSONObject.put("backRepeat", this.backgroundRepeat);
            }
            if (!Str.isNullOrEmpty(this.bubbleHtml)) {
                jSONObject.put("bubbleHtml", this.bubbleHtml);
            }
            if (!Str.isNullOrEmpty(this.borderColor)) {
                jSONObject.put("borderColor", this.borderColor);
            }
            if (!this.rightClickEnabled) {
                jSONObject.put("rightClickDisabled", true);
            }
            if (!Str.isNullOrEmpty(this.cssClass)) {
                jSONObject.put("cssClass", this.cssClass);
            }
            if (!Str.isNullOrEmpty(this.toolTip)) {
                jSONObject.put("toolTip", this.toolTip);
            }
            if (!Str.isNullOrEmpty(this.contextMenuClientName)) {
                jSONObject.put("contextMenu", this.contextMenuClientName);
            }
            if (!Str.isNullOrEmpty(this.barColor)) {
                jSONObject.put("barColor", this.barColor);
            }
            if (!Str.isNullOrEmpty(this.barBackColor)) {
                jSONObject.put("barBackColor", this.barBackColor);
            }
            if (!this.barVisible) {
                jSONObject.put("barHidden", true);
            }
            if (!Str.isNullOrEmpty(this.backgroundColor)) {
                jSONObject.put("backColor", this.backgroundColor);
            }
            if (this.isRegular()) {
                if (this.html == null) {
                    jSONObject.put("html", BeforeTaskRenderArgs.this.task.getComplete() + "%");
                } else {
                    jSONObject.put("html", this.html);
                }
            }
            if (!this.resizeEnabled) {
                jSONObject.put("resizeDisabled", true);
            }
            if (!this.moveEnabled) {
                jSONObject.put("moveDisabled", true);
            }
            if (!this.clickEnabled) {
                jSONObject.put("clickDisabled", true);
            }
            if (!this.doubleClickEnabled) {
                jSONObject.put("doubleClickDisabled", true);
            }
            if (!this.deleteEnabled) {
                jSONObject.put("deleteDisabled", true);
            }
            if (!Str.isNullOrEmpty(this.htmlRight)) {
                jSONObject.put("htmlRight", this.htmlRight);
            }
            if (!Str.isNullOrEmpty(this.htmlLeft)) {
                jSONObject.put("htmlLeft", this.htmlLeft);
            }
            return jSONObject;
        }

        public String getBackgroundImage() {
            return this.backgroundImage;
        }

        public void setBackgroundImage(String string) {
            this.backgroundImage = string;
        }

        public String getBackgroundRepeat() {
            return this.backgroundRepeat;
        }

        public void setBackgroundRepeat(String string) {
            this.backgroundRepeat = string;
        }

        public String getBubbleHtml() {
            return this.bubbleHtml;
        }

        public void setBubbleHtml(String string) {
            this.bubbleHtml = string;
        }

        public String getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(String string) {
            this.borderColor = string;
        }

        public boolean isRightClickEnabled() {
            return this.rightClickEnabled;
        }

        public void setRightClickEnabled(boolean bl) {
            this.rightClickEnabled = bl;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public void setCssClass(String string) {
            this.cssClass = string;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public void setToolTip(String string) {
            this.toolTip = string;
        }

        public String getContextMenuClientName() {
            return this.contextMenuClientName;
        }

        public void setContextMenuClientName(String string) {
            this.contextMenuClientName = string;
        }

        public String getBarColor() {
            return this.barColor;
        }

        public void setBarColor(String string) {
            this.barColor = string;
        }

        public String getBarBackColor() {
            return this.barBackColor;
        }

        public void setBarBackColor(String string) {
            this.barBackColor = string;
        }

        public boolean isBarVisible() {
            return this.barVisible;
        }

        public void setBarVisible(boolean bl) {
            this.barVisible = bl;
        }

        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(String string) {
            this.backgroundColor = string;
        }

        public String getHtml() {
            return this.html;
        }

        public void setHtml(String string) {
            this.html = string;
        }

        public String getHtmlRight() {
            return this.htmlRight;
        }

        public void setHtmlRight(String string) {
            this.htmlRight = string;
        }

        public String getHtmlLeft() {
            return this.htmlLeft;
        }

        public void setHtmlLeft(String string) {
            this.htmlLeft = string;
        }

        public boolean isResizeEnabled() {
            return this.resizeEnabled;
        }

        public void setResizeEnabled(boolean bl) {
            this.resizeEnabled = bl;
        }

        public boolean isMoveEnabled() {
            return this.moveEnabled;
        }

        public void setMoveEnabled(boolean bl) {
            this.moveEnabled = bl;
        }

        public boolean isClickEnabled() {
            return this.clickEnabled;
        }

        public void setClickEnabled(boolean bl) {
            this.clickEnabled = bl;
        }

        public boolean isDoubleClickEnabled() {
            return this.doubleClickEnabled;
        }

        public void setDoubleClickEnabled(boolean bl) {
            this.doubleClickEnabled = bl;
        }

        public boolean isDeleteEnabled() {
            return this.deleteEnabled;
        }

        public void setDeleteEnabled(boolean bl) {
            this.deleteEnabled = bl;
        }

        public AreaCollection getAreas() {
            return this.areas;
        }
    }

    public class TaskRow {
        private AreaCollection areas = new AreaCollection();
        private boolean expanded;
        private String backgroundColor;
        private String bubbleHtml;
        private String cssClass;
        private String toolTip;
        private String html;
        private String contextMenuClientName;
        private int minHeight;
        private int marginBottom;
        private boolean moveEnabled;
        private TaskRowColumnList columns = new TaskRowColumnList();

        TaskRow() {
            this.marginBottom = BeforeTaskRenderArgs.this.gantt.getRowMarginBottom();
            this.minHeight = BeforeTaskRenderArgs.this.gantt.getRowMinHeight();
            this.expanded = BeforeTaskRenderArgs.this.task.isExpanded();
            this.moveEnabled = true;
        }

        JSONObject toJSON() {
            JSONObject jSONObject = new JSONObject();
            if (this.areas.size() > 0) {
                jSONObject.put("areas", this.areas.getJSON());
            }
            if (!Str.isNullOrEmpty(this.backgroundColor)) {
                jSONObject.put("backColor", this.backgroundColor);
            }
            if (!Str.isNullOrEmpty(this.bubbleHtml)) {
                jSONObject.put("bubbleHtml", this.bubbleHtml);
            }
            if (!Str.isNullOrEmpty(this.cssClass)) {
                jSONObject.put("cssClass", this.cssClass);
            }
            if (!Str.isNullOrEmpty(this.toolTip)) {
                jSONObject.put("toolTip", this.toolTip);
            }
            if (!Str.isNullOrEmpty(this.html)) {
                jSONObject.put("html", this.html);
            }
            if (!Str.isNullOrEmpty(this.contextMenuClientName)) {
                jSONObject.put("contextMenu", this.contextMenuClientName);
            }
            if (BeforeTaskRenderArgs.this.gantt.getRowMinHeight() != this.minHeight) {
                jSONObject.put("minHeight", this.minHeight);
            }
            if (BeforeTaskRenderArgs.this.gantt.getRowMarginBottom() != this.marginBottom) {
                jSONObject.put("marginBottom", this.marginBottom);
            }
            if (!this.moveEnabled) {
                jSONObject.put("moveDisabled", true);
            }
            if (!this.expanded) {
                jSONObject.put("collapsed", true);
            }
            if (this.columns.size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (TaskRowColumn taskRowColumn : this.columns) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("html", taskRowColumn.html);
                    jSONArray.put(jSONObject2);
                }
                jSONObject.put("columns", jSONArray);
            }
            return jSONObject;
        }

        public String getHtml() {
            if (this.columns != null && this.columns.size() > 0) {
                return ((TaskRowColumn)this.columns.get(0)).getHtml();
            }
            return this.html;
        }

        public void setHtml(String string) {
            if (this.columns != null && this.columns.size() > 0) {
                ((TaskRowColumn)this.columns.get(0)).setHtml(string);
            } else {
                this.html = string;
            }
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean bl) {
            this.expanded = bl;
        }

        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(String string) {
            this.backgroundColor = string;
        }

        public String getBubbleHtml() {
            return this.bubbleHtml;
        }

        public void setBubbleHtml(String string) {
            this.bubbleHtml = string;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public void setCssClass(String string) {
            this.cssClass = string;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public void setToolTip(String string) {
            this.toolTip = string;
        }

        public String getContextMenuClientName() {
            return this.contextMenuClientName;
        }

        public void setContextMenuClientName(String string) {
            this.contextMenuClientName = string;
        }

        public int getMinHeight() {
            return this.minHeight;
        }

        public void setMinHeight(int n) {
            this.minHeight = n;
        }

        public int getMarginBottom() {
            return this.marginBottom;
        }

        public void setMarginBottom(int n) {
            this.marginBottom = n;
        }

        public boolean isMoveEnabled() {
            return this.moveEnabled;
        }

        public void setMoveEnabled(boolean bl) {
            this.moveEnabled = bl;
        }

        public AreaCollection getAreas() {
            return this.areas;
        }

        public TaskRowColumnList getColumns() {
            return this.columns;
        }
    }

    public class TaskRowColumnList
    extends ArrayList<TaskRowColumn> {
    }

    public class TaskRowColumn {
        String value;
        String html;

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getHtml() {
            return this.html;
        }

        public void setHtml(String string) {
            this.html = string;
        }
    }
}

