/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.args.month;

import org.daypilot.data.AreaCollection;
import org.daypilot.date.DateTime;
import org.daypilot.ui.DayPilotMonth;

public class BeforeCellRenderArgs {
    private DateTime start;
    private DateTime end;
    private boolean business;
    private String backgroundColor;
    private String backgroundImage;
    private String backgroundRepeat;
    private String headerText;
    private String headerBackColor;
    private String cssClass;
    private AreaCollection areas = new AreaCollection();

    private BeforeCellRenderArgs() {
    }

    public static BeforeCellRenderArgs fromDay(DayPilotMonth dayPilotMonth, DateTime dateTime) {
        BeforeCellRenderArgs beforeCellRenderArgs = new BeforeCellRenderArgs();
        beforeCellRenderArgs.start = dateTime;
        beforeCellRenderArgs.end = dateTime.addDays(1);
        boolean bl = beforeCellRenderArgs.business = !dateTime.isWeekend();
        if (!dayPilotMonth.isCssOnly()) {
            beforeCellRenderArgs.backgroundColor = beforeCellRenderArgs.business ? dayPilotMonth.getBackColor() : dayPilotMonth.getNonBusinessBackColor();
        }
        beforeCellRenderArgs.headerText = dateTime.getDay() == 1 ? String.format("%s %d", dateTime.toString("MMMM", dayPilotMonth.getLocale()), dateTime.getDay()) : "" + dateTime.getDay();
        beforeCellRenderArgs.headerBackColor = "";
        return beforeCellRenderArgs;
    }

    public boolean isBusiness() {
        return this.business;
    }

    public void setBusiness(boolean bl) {
        this.business = bl;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String string) {
        this.backgroundColor = string;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String string) {
        this.headerText = string;
    }

    public String getHeaderBackColor() {
        return this.headerBackColor;
    }

    public void setHeaderBackColor(String string) {
        this.headerBackColor = string;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public boolean backgroundColorEquals(String string) {
        if (this.backgroundColor == null) {
            return false;
        }
        return this.backgroundColor.equals(string);
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String string) {
        this.cssClass = string;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(String string) {
        this.backgroundImage = string;
    }

    public String getBackgroundRepeat() {
        return this.backgroundRepeat;
    }

    public void setBackgroundRepeat(String string) {
        this.backgroundRepeat = string;
    }

    public AreaCollection getAreas() {
        return this.areas;
    }
}

