/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.enums;

import java.util.Locale;

public enum TimeFormat {
    CLOCK_12_HOURS,
    CLOCK_24_HOURS,
    AUTO;


    public static TimeFormat parse(String string) {
        if (string == null) {
            throw new NullPointerException("Cannot parse null string.");
        }
        String string2 = string.toUpperCase();
        if ("CLOCK12HOURS".equals(string2)) {
            return CLOCK_12_HOURS;
        }
        if ("CLOCK24HOURS".equals(string2)) {
            return CLOCK_24_HOURS;
        }
        if ("AUTO".equals(string2)) {
            return AUTO;
        }
        throw new IllegalArgumentException("Unable to parse the supplied string.");
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "Clock12Hours";
            }
            case 1: {
                return "Clock24Hours";
            }
            case 2: {
                return "Auto";
            }
        }
        throw new IllegalArgumentException("Unknown TimeFormat value.");
    }

    public static boolean isValid(String string) {
        try {
            TimeFormat.parse(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public TimeFormat resolve(Locale locale) {
        if (this == AUTO) {
            return TimeFormat.getDefaultTimeFormat(locale);
        }
        return this;
    }

    private static TimeFormat getDefaultTimeFormat(Locale locale) {
        String string = locale.getCountry().toLowerCase();
        if ("au".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("bd".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("ca".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("co".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("eg".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("sv".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("hn".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("in".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("my".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("nz".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("ni".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("pk".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("ph".equals(string)) {
            return CLOCK_12_HOURS;
        }
        if ("us".equals(string)) {
            return CLOCK_12_HOURS;
        }
        return CLOCK_24_HOURS;
    }
}

