/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import java.util.ArrayList;
import java.util.List;
import org.daypilot.data.ResourceCollection;
import org.daypilot.data.ResourceColumn;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONObject;

public class Resource {
    public static final Resource ROOT = new Resource();
    private String value;
    private String name;
    private String toolTip;
    private ResourceCollection children = new ResourceCollection();
    private boolean expanded = false;
    private boolean childrenLoaded = true;
    private List<ResourceColumn> columns = new ArrayList<ResourceColumn>();

    public Resource() {
    }

    public Resource(String string, String string2) {
        this.value = string2;
        this.name = string;
    }

    public Resource(String string, String string2, boolean bl) {
        this.value = string;
        this.name = string2;
        this.childrenLoaded = bl;
    }

    public JSONArray getColumnsJSON() {
        JSONArray jSONArray = new JSONArray();
        for (ResourceColumn resourceColumn : this.columns) {
            jSONArray.put(resourceColumn.getJSON());
        }
        return jSONArray;
    }

    private void restoreColumnsFromJSON(JSONArray jSONArray) {
        try {
            this.columns.clear();
            if (jSONArray == null) {
                return;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                this.columns.add(ResourceColumn.fromJSON(jSONObject));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Resource fromJSON(JSONObject jSONObject) {
        try {
            Resource resource = new Resource();
            resource.setChildrenLoaded(jSONObject.isNull("Loaded") ? true : jSONObject.getBoolean("Loaded"));
            resource.setExpanded(jSONObject.optBoolean("Expanded"));
            resource.setName(jSONObject.getString("Name"));
            resource.setToolTip(jSONObject.optString("ToolTip"));
            resource.setValue(jSONObject.getString("Value"));
            resource.getChildren().restoreFromJSON(jSONObject.getJSONArray("Children"));
            resource.restoreColumnsFromJSON(jSONObject.optJSONArray("Columns"));
            return resource;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String string) {
        this.toolTip = string;
    }

    public ResourceCollection getChildren() {
        return this.children;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    public void setChildrenLoaded(boolean bl) {
        this.childrenLoaded = bl;
    }

    public List<ResourceColumn> getColumns() {
        return this.columns;
    }
}

