/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.data;

import org.daypilot.date.DateTime;
import org.daypilot.json.JSONObject;
import org.daypilot.ui.ITimeHeaderParent;

public class TimeHeaderCell {
    private DateTime start;
    private DateTime end;
    private String innerHTML;
    private String toolTip;
    private String backColor;
    private int level;
    private Integer left = null;
    private Integer width = null;
    private String defaultBackColor;

    public TimeHeaderCell(ITimeHeaderParent iTimeHeaderParent, DateTime dateTime, DateTime dateTime2) {
        this.start = dateTime;
        this.end = dateTime2;
        this.defaultBackColor = iTimeHeaderParent.getHourNameBackColor();
    }

    public DateTime getStart() {
        return this.start;
    }

    public String getInnerHTML() {
        return this.innerHTML;
    }

    public void setInnerHTML(String string) {
        this.innerHTML = string;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String string) {
        this.toolTip = string;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public String getBackColor() {
        return this.backColor;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setBackColor(String string) {
        this.backColor = string;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("start", this.start.utc().toStringSortable());
        jSONObject.put("end", this.end.utc().toStringSortable());
        jSONObject.put("innerHTML", this.innerHTML);
        if (this.toolTip != null && !this.toolTip.equals(this.innerHTML)) {
            jSONObject.put("toolTip", this.toolTip);
        }
        if (this.backColor != null && !this.backColor.equals(this.defaultBackColor)) {
            jSONObject.put("backColor", this.backColor);
        }
        if (this.left != null) {
            jSONObject.put("left", this.left);
        }
        if (this.width != null) {
            jSONObject.put("width", this.width);
        }
        return jSONObject;
    }

    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer n) {
        this.left = n;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer n) {
        this.width = n;
    }

    public int getRight() {
        return this.left + this.width;
    }
}

