/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.recurrence;

import java.util.ArrayList;
import org.daypilot.date.DateTime;
import org.daypilot.recurrence.RecurInfo;
import org.daypilot.recurrence.RecurType;
import org.daypilot.recurrence.RecurrenceException;
import org.daypilot.util.Base64;
import org.daypilot.util.Str;

public class RecurEx
extends RecurInfo {
    private DateTime start;
    private String masterId;
    private String id;

    public static RecurEx parse(String string, String string2, Object object) {
        if (string == null) {
            throw new RecurrenceException("Input not in correct format");
        }
        String[] stringArray = string.split("#");
        RecurEx recurEx = new RecurEx();
        recurEx.masterId = Base64.decodeToString(stringArray[0]);
        if (!stringArray[1].equals("1")) {
            throw new RecurrenceException("Unsupported recurrence format version.");
        }
        String string3 = stringArray[2];
        switch (string3.charAt(0)) {
            case 'D': {
                recurEx.setType(RecurType.DELETED);
                break;
            }
            case 'M': {
                recurEx.setType(RecurType.MODIFIED);
                break;
            }
            default: {
                throw new RecurrenceException("Unexpected recurex type.");
            }
        }
        recurEx.setStart(new DateTime(stringArray[3]));
        recurEx.setId(string2);
        recurEx.setTag(object);
        return recurEx;
    }

    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Base64.encodeString(this.masterId));
        arrayList.add("1");
        arrayList.add(this.type());
        arrayList.add(this.start.toStringSortable());
        return Str.join(arrayList, "#");
    }

    private String type() {
        switch (this.getType()) {
            case DELETED: {
                return "D";
            }
            case MODIFIED: {
                return "M";
            }
        }
        throw new RecurrenceException("Recurrence exception type must be either Deleted or Modified.");
    }

    public static String createString(RecurType recurType, String string, DateTime dateTime) {
        RecurEx recurEx = new RecurEx();
        recurEx.masterId = string;
        recurEx.start = dateTime;
        recurEx.setType(recurType);
        return recurEx.toString();
    }

    public DateTime getStart() {
        return this.start;
    }

    public void setStart(DateTime dateTime) {
        this.start = dateTime;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterId(String string) {
        this.masterId = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }
}

