/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.recurrence;

import org.daypilot.date.DateTime;
import org.daypilot.recurrence.RecurEvent;
import org.daypilot.recurrence.RecurEx;
import org.daypilot.recurrence.RecurType;
import org.daypilot.recurrence.RecurrenceException;
import org.daypilot.util.Str;

public class RecurInfo {
    private RecurType type;
    private Object tag;

    public static RecurInfo parse(String string, String string2, DateTime dateTime, DateTime dateTime2, Object object) {
        if (Str.isNullOrEmpty(string)) {
            return new RecurInfo(RecurType.NONE);
        }
        String[] stringArray = string.split("#");
        String string3 = stringArray[1];
        if (!string3.equals("1") && !string3.equals("2")) {
            throw new RecurrenceException("Unsupported recurrence format");
        }
        switch (stringArray[2].charAt(0)) {
            case 'D': {
                return RecurEx.parse(string, string2, object);
            }
            case 'M': {
                return RecurEx.parse(string, string2, object);
            }
            case 'C': {
                return RecurEvent.parseEvent(string, dateTime, dateTime2, string2, object);
            }
        }
        throw new RecurrenceException("Unrecognized recurrence information string.");
    }

    RecurInfo() {
    }

    RecurInfo(RecurType recurType) {
        this.type = recurType;
    }

    public RecurType getType() {
        return this.type;
    }

    public void setType(RecurType recurType) {
        this.type = recurType;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object object) {
        this.tag = object;
    }
}

