/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.recurrence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.daypilot.data.TagCollection;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.date.TimeSpan;
import org.daypilot.recurrence.Occurrence;
import org.daypilot.recurrence.RecurEvent;
import org.daypilot.recurrence.RecurEx;
import org.daypilot.recurrence.RecurInfo;
import org.daypilot.recurrence.RecurType;
import org.daypilot.ui.BoolParser;
import org.daypilot.ui.Event;
import org.daypilot.ui.EventBean;
import org.daypilot.ui.args.scheduler.BeforeEventRecurrenceArgs;
import org.daypilot.ui.enums.WeekStarts;
import org.daypilot.util.Str;

public class RecurrenceExpander {
    private String dataIdField = "id";
    private String dataTextField = "text";
    private String dataStartField = "start";
    private String dataEndField = "end";
    private String dataResourceField = "resource";
    private String dataRecurrenceField;
    private String dataTagFields;
    private String dataAllDayField;
    private boolean useUtcDates = false;
    private WeekStarts weekStarts = WeekStarts.AUTO;
    private Collection<?> events;

    public void onBeforeEventRecurrence(BeforeEventRecurrenceArgs beforeEventRecurrenceArgs) throws Exception {
    }

    public List<Event> expand(DateTime dateTime, DateTime dateTime2) {
        return this.expand(dateTime, dateTime2, TimeSpan.fromDays(30));
    }

    public List<Event> expand(DateTime dateTime, DateTime dateTime2, TimeSpan timeSpan) {
        try {
            Object object;
            Object object3;
            ArrayList<Event> arrayList = new ArrayList<Event>();
            if (this.events == null) {
                return arrayList;
            }
            if (this.events.size() == 0) {
                return arrayList;
            }
            ArrayList<RecurEx> arrayList2 = new ArrayList<RecurEx>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (Object object4 : this.events) {
                Object object2;
                Object object5;
                Object object6;
                object3 = new EventBean(object4);
                ((EventBean)object3).setUseUtc(this.useUtcDates);
                String iterator2 = ((EventBean)object3).getString(this.dataIdField);
                Object object7 = ((EventBean)object3).getString(this.dataTextField);
                object = ((EventBean)object3).getDateTime(this.dataStartField);
                DateTime dateTime3 = ((EventBean)object3).getDateTime(this.dataEndField);
                String string = null;
                if (this.dataResourceField != null) {
                    string = ((EventBean)object3).getString(this.dataResourceField);
                }
                boolean bl = false;
                if (this.dataAllDayField != null) {
                    bl = BoolParser.parse(((EventBean)object3).getString(this.dataAllDayField));
                }
                TagCollection tagCollection = null;
                if (this.dataTagFields != null) {
                    object6 = this.getDataTagFieldsSplit();
                    object5 = new ArrayList<String>();
                    for (String string2 : this.getDataTagFieldsSplit()) {
                        object5.add(((EventBean)object3).getString(string2));
                    }
                    tagCollection = new TagCollection((String[])object6, object5.toArray(new String[0]));
                }
                object6 = new Event((DateTime)object, dateTime3, iterator2, (String)object7, string, tagCollection, null, bl);
                ((Event)object6).setSource(object4);
                if (Str.isNullOrEmpty(this.dataRecurrenceField)) {
                    object5 = this.doBeforeEventRecurrence((Event)object6);
                    if (((BeforeEventRecurrenceArgs)object5).getRule() != null) {
                        object2 = RecurEvent.fromRule(((BeforeEventRecurrenceArgs)object5).getRule(), (DateTime)object, dateTime3, iterator2, object6);
                        ((RecurEvent)object2).setFirstDayOfWeek(this.getResolvedWeekStart());
                        arrayList3.add(object2);
                    }
                } else {
                    object5 = ((EventBean)object3).getString(this.dataRecurrenceField);
                    object2 = RecurInfo.parse((String)object5, iterator2, (DateTime)object, dateTime3, object6);
                    switch (((RecurInfo)object2).getType()) {
                        case DELETED: {
                            arrayList2.add((RecurEx)object2);
                            break;
                        }
                        case MODIFIED: {
                            arrayList2.add((RecurEx)object2);
                            break;
                        }
                        case EVENT: {
                            arrayList3.add((RecurEvent)object2);
                            break;
                        }
                    }
                    if (((RecurInfo)object2).getType() != RecurType.NONE) continue;
                }
                arrayList.add((Event)object6);
            }
            for (Object object4 : arrayList3) {
                for (RecurEx recurEx : arrayList2) {
                    ((RecurEvent)object4).addRecurexSilent(recurEx);
                }
                object3 = (Event)((RecurInfo)object4).getTag();
                for (Object object7 : ((RecurEvent)object4).occurrences(dateTime2.add(timeSpan))) {
                    object = new Event(((Occurrence)object7).getStart(), ((Occurrence)object7).getEnd(), ((Occurrence)object7).getId(), ((Event)object3).getText(), ((Event)object3).getResourceId(), ((Event)object3).getTags(), ((Event)object3).getSort(), ((Event)object3).isAllDay());
                    if (((Occurrence)object7).isModified()) {
                        object = (Event)((Occurrence)object7).getTag();
                    }
                    ((Event)object).setRecurrentMasterId(((Event)object3).getId());
                    ((Event)object).setRecurrent(true);
                    if (!((Event)object).getEnd().afterOrEqual(dateTime)) continue;
                    arrayList.add((Event)object);
                }
            }
            return arrayList;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private BeforeEventRecurrenceArgs doBeforeEventRecurrence(Event event) {
        BeforeEventRecurrenceArgs beforeEventRecurrenceArgs = new BeforeEventRecurrenceArgs(event);
        try {
            this.onBeforeEventRecurrence(beforeEventRecurrenceArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return beforeEventRecurrenceArgs;
    }

    public String getDataIdField() {
        return this.dataIdField;
    }

    public void setDataIdField(String string) {
        this.dataIdField = string;
    }

    public String getDataTextField() {
        return this.dataTextField;
    }

    public void setDataTextField(String string) {
        this.dataTextField = string;
    }

    public String getDataStartField() {
        return this.dataStartField;
    }

    public void setDataStartField(String string) {
        this.dataStartField = string;
    }

    public String getDataEndField() {
        return this.dataEndField;
    }

    public void setDataEndField(String string) {
        this.dataEndField = string;
    }

    public String getDataResourceField() {
        return this.dataResourceField;
    }

    public void setDataResourceField(String string) {
        this.dataResourceField = string;
    }

    public String getDataRecurrenceField() {
        return this.dataRecurrenceField;
    }

    public void setDataRecurrenceField(String string) {
        this.dataRecurrenceField = string;
    }

    public Collection<?> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<?> collection) {
        this.events = collection;
    }

    public String getDataTagFields() {
        return this.dataTagFields;
    }

    public void setDataTagFields(String string) {
        this.dataTagFields = string;
    }

    private String[] getDataTagFieldsSplit() {
        if (this.dataTagFields == null || "".equals(this.dataTagFields)) {
            return new String[0];
        }
        String[] stringArray = this.dataTagFields.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public boolean isUseUtcDates() {
        return this.useUtcDates;
    }

    public void setUseUtcDates(boolean bl) {
        this.useUtcDates = bl;
    }

    public WeekStarts getWeekStarts() {
        return this.weekStarts;
    }

    public void setWeekStarts(WeekStarts weekStarts) {
        this.weekStarts = weekStarts;
    }

    protected DayOfWeek getResolvedWeekStart() {
        switch (this.weekStarts) {
            case SUNDAY: {
                return DayOfWeek.SUNDAY;
            }
            case MONDAY: {
                return DayOfWeek.MONDAY;
            }
            case TUESDAY: {
                return DayOfWeek.TUESDAY;
            }
            case WEDNESDAY: {
                return DayOfWeek.WEDNESDAY;
            }
            case THURSDAY: {
                return DayOfWeek.THURSDAY;
            }
            case FRIDAY: {
                return DayOfWeek.FRIDAY;
            }
            case SATURDAY: {
                return DayOfWeek.SATURDAY;
            }
            case AUTO: {
                return DayOfWeek.getDefaultWeekStart();
            }
        }
        throw new RuntimeException("This weekStarts value is not supported (" + (Object)((Object)this.weekStarts) + ").");
    }

    public String getDataAllDayField() {
        return this.dataAllDayField;
    }

    public void setDataAllDayField(String string) {
        this.dataAllDayField = string;
    }
}

