/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.util.ArrayList;
import java.util.List;
import org.daypilot.date.DateTime;
import org.daypilot.ui.EventColumn;
import org.daypilot.ui.EventPart;

class Block {
    private List<EventColumn> columns;
    private List<EventPart> eventParts = new ArrayList<EventPart>();

    Block() {
    }

    void add(EventPart eventPart) {
        this.eventParts.add(eventPart);
        this.arrangeColumns();
    }

    EventColumn createColumn() {
        EventColumn eventColumn = new EventColumn();
        this.columns.add(eventColumn);
        eventColumn.setBlock(this);
        return eventColumn;
    }

    private void arrangeColumns() {
        this.columns = new ArrayList<EventColumn>();
        for (EventPart eventPart : this.eventParts) {
            eventPart.setEvColumn(null);
        }
        this.createColumn();
        for (EventPart eventPart : this.eventParts) {
            for (EventColumn eventColumn : this.columns) {
                if (!eventColumn.canAdd(eventPart)) continue;
                eventColumn.add(eventPart);
                break;
            }
            if (eventPart.getEvColumn() != null) continue;
            EventColumn eventColumn = this.createColumn();
            eventColumn.add(eventPart);
        }
    }

    boolean overlapsWith(EventPart eventPart) {
        if (this.eventParts.size() == 0) {
            return false;
        }
        return this.getBoxStart().before(eventPart.getBoxEnd()) && this.getBoxEnd().after(eventPart.getBoxStart());
    }

    DateTime getBoxStart() {
        DateTime dateTime = DateTime.MAX;
        for (EventPart eventPart : this.eventParts) {
            if (!eventPart.getBoxStart().before(dateTime)) continue;
            dateTime = eventPart.getBoxStart();
        }
        return dateTime;
    }

    DateTime getBoxEnd() {
        DateTime dateTime = DateTime.MIN;
        for (EventPart eventPart : this.eventParts) {
            if (!eventPart.getBoxEnd().after(dateTime)) continue;
            dateTime = eventPart.getBoxEnd();
        }
        return dateTime;
    }

    List<EventColumn> getColumns() {
        return this.columns;
    }
}

