/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.daypilot.data.ResourceColumn;
import org.daypilot.date.DateTime;
import org.daypilot.ui.Block;
import org.daypilot.ui.Event;
import org.daypilot.ui.EventPart;
import org.daypilot.ui.enums.DateTimeSpec;
import org.daypilot.ui.enums.UseBoxes;
import org.daypilot.util.Str;

class Day {
    private List<EventPart> eventParts = new ArrayList<EventPart>();
    private List<EventPart> allDayEvents = new ArrayList<EventPart>();
    private List<Block> blocks = new ArrayList<Block>();
    private int cellDuration;
    private DateTime start;
    private DateTime end;
    private String name;
    private String value;
    private String toolTip;
    private UseBoxes useEventBoxes = UseBoxes.ALWAYS;
    private DateTimeSpec AllDayEnd = DateTimeSpec.DATE_TIME;
    private List<ResourceColumn> columns = null;

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public Day(DateTime dateTime, DateTime dateTime2, String string, String string2, int n, String string3) {
        this.start = dateTime;
        this.end = dateTime2;
        this.name = string;
        this.value = string2;
        this.cellDuration = n;
        this.toolTip = string3;
    }

    private void stripAndAddEvent(Event event) {
        if (!Str.isNullOrEmpty(this.value) && !this.value.equals(event.getResourceId())) {
            return;
        }
        if (event.isAllDay()) {
            if (event.getStart().after(event.getEnd())) {
                return;
            }
            if (event.getStart().after(this.end)) {
                return;
            }
            if (this.AllDayEnd == DateTimeSpec.DATE_TIME ? event.getEnd().beforeOrEqual(this.start) : event.getEnd().before(this.start)) {
                return;
            }
            EventPart eventPart = new EventPart(this, event);
            this.allDayEvents.add(eventPart);
        } else {
            if (event.getEnd().before(this.start)) {
                return;
            }
            if (event.getEnd().equals(this.start) && !event.getStart().equals(event.getEnd())) {
                return;
            }
            if (event.getStart().afterOrEqual(this.end)) {
                return;
            }
            if (event.getStart().after(event.getEnd())) {
                return;
            }
            EventPart eventPart = new EventPart(this, event);
            this.eventParts.add(eventPart);
        }
    }

    public void load(Collection<Event> collection) {
        if (collection == null) {
            return;
        }
        for (Event event : collection) {
            this.stripAndAddEvent(event);
        }
        this.putIntoBlocks();
    }

    private void putIntoBlocks() {
        for (EventPart eventPart : this.eventParts) {
            if (this.getLastBlock() == null) {
                this.blocks.add(new Block());
            } else if (!this.getLastBlock().overlapsWith(eventPart)) {
                this.blocks.add(new Block());
            }
            this.getLastBlock().add(eventPart);
        }
    }

    private Block getLastBlock() {
        if (this.blocks.size() == 0) {
            return null;
        }
        return this.blocks.get(this.blocks.size() - 1);
    }

    public UseBoxes getUseEventBoxes() {
        return this.useEventBoxes;
    }

    public int getCellDuration() {
        return this.cellDuration;
    }

    public void setColumns(List<ResourceColumn> list) {
        this.columns = list;
    }

    public List<ResourceColumn> getColumns() {
        return this.columns;
    }

    public String getValue() {
        return this.value;
    }

    public void setCellDuration(int n) {
        this.cellDuration = n;
    }

    String getName() {
        return this.name;
    }

    String getToolTip() {
        return this.toolTip;
    }
}

