/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.daypilot.data.Column;
import org.daypilot.data.ColumnCollection;
import org.daypilot.data.TagCollection;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.date.TimeFormatter;
import org.daypilot.date.TimeSpan;
import org.daypilot.date.Week;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONException;
import org.daypilot.json.JSONObject;
import org.daypilot.recurrence.Occurrence;
import org.daypilot.recurrence.RecurEvent;
import org.daypilot.recurrence.RecurEx;
import org.daypilot.recurrence.RecurInfo;
import org.daypilot.recurrence.RecurType;
import org.daypilot.ui.BoolParser;
import org.daypilot.ui.CellTable;
import org.daypilot.ui.CellTableCell;
import org.daypilot.ui.Ensure;
import org.daypilot.ui.Event;
import org.daypilot.ui.EventBean;
import org.daypilot.ui.JSONParser;
import org.daypilot.ui.SortExpression;
import org.daypilot.ui.Version;
import org.daypilot.ui.args.calendar.BeforeCellRenderArgs;
import org.daypilot.ui.args.calendar.BeforeEventRecurrenceArgs;
import org.daypilot.ui.args.calendar.BeforeEventRenderArgs;
import org.daypilot.ui.args.calendar.BeforeHeaderRenderArgs;
import org.daypilot.ui.args.calendar.BeforeTimeHeaderRenderArgs;
import org.daypilot.ui.args.calendar.CommandArgs;
import org.daypilot.ui.args.calendar.EventBubbleArgs;
import org.daypilot.ui.args.calendar.EventClickArgs;
import org.daypilot.ui.args.calendar.EventDeleteArgs;
import org.daypilot.ui.args.calendar.EventDoubleClickArgs;
import org.daypilot.ui.args.calendar.EventEditArgs;
import org.daypilot.ui.args.calendar.EventMenuClickArgs;
import org.daypilot.ui.args.calendar.EventMoveArgs;
import org.daypilot.ui.args.calendar.EventResizeArgs;
import org.daypilot.ui.args.calendar.EventRightClickArgs;
import org.daypilot.ui.args.calendar.EventSelectArgs;
import org.daypilot.ui.args.calendar.HeaderClickArgs;
import org.daypilot.ui.args.calendar.NotifyArgs;
import org.daypilot.ui.args.calendar.TimeRangeDoubleClickArgs;
import org.daypilot.ui.args.calendar.TimeRangeMenuClick;
import org.daypilot.ui.args.calendar.TimeRangeSelectedArgs;
import org.daypilot.ui.enums.HeightSpec;
import org.daypilot.ui.enums.TimeFormat;
import org.daypilot.ui.enums.UpdateType;
import org.daypilot.ui.enums.ViewType;
import org.daypilot.ui.enums.WeekStarts;
import org.daypilot.util.LocaleFormatter;
import org.daypilot.util.LocaleParser;
import org.daypilot.util.Str;
import org.daypilot.util.Xml;

public class DayPilotCalendar {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String dataIdField = "id";
    private String dataTextField = "text";
    private String dataStartField = "start";
    private String dataEndField = "end";
    private String dataResourceField;
    private String dataTagFields;
    private String dataAllDayField;
    private String dataRecurrenceField;
    private boolean useUtcDates = false;
    private Collection<?> events;
    private List<Event> items;
    private UpdateType updateType = UpdateType.NONE;
    private String updateMessage;
    private DateTime startDate;
    private int days;
    private String id;
    private boolean eventHeaderVisible;
    private TimeFormat timeFormat = TimeFormat.AUTO;
    private int cellDuration;
    private HeightSpec heightSpec;
    private int businessBeginsHour;
    private int businessEndsHour;
    private JSONObject clientState;
    private ViewType viewType = ViewType.DAYS;
    private int dayBeginsHour;
    private int dayEndsHour;
    private int headerLevels;
    private String backColor;
    private String nonBusinessBackColor;
    private String headerDateFormat = "M/d/yyyy";
    private String hourFontFamily;
    private String hourFontSize;
    private String hourFontColor;
    private int timeHeaderCellDuration = 60;
    private Locale locale = Locale.getDefault();
    private String selectedEventValue;
    private boolean cssOnly;
    private String cssClassPrefix;
    private WeekStarts weekStarts = WeekStarts.AUTO;
    private String bubbleGuid;
    private JSONObject bubbleResult;
    private String eventSortExpression;
    private SortExpression sortFields = new SortExpression();
    private ColumnCollection columns = new ColumnCollection();

    public JSONObject callback(JSONObject jSONObject) {
        try {
            Object object;
            Object object2;
            String string = jSONObject.getString("action");
            JSONObject jSONObject2 = jSONObject.optJSONObject("parameters");
            JSONObject jSONObject3 = jSONObject.optJSONObject("data");
            JSONObject jSONObject4 = jSONObject.getJSONObject("header");
            Version.check(jSONObject4.optString("v"));
            this.backColor = jSONObject4.optString("backColor");
            this.businessBeginsHour = jSONObject4.optInt("businessBeginsHour");
            this.businessEndsHour = jSONObject4.optInt("businessEndsHour");
            this.clientState = jSONObject4.getJSONObject("clientState");
            this.cellDuration = jSONObject4.optInt("cellDuration");
            this.columns.restoreFromJSON(jSONObject4.optJSONArray("columns"));
            this.cssOnly = true;
            this.cssClassPrefix = jSONObject4.optString("cssClassPrefix");
            this.dayBeginsHour = jSONObject4.optInt("dayBeginsHour");
            this.dayEndsHour = jSONObject4.optInt("dayEndsHour");
            this.days = jSONObject4.getInt("days");
            this.eventHeaderVisible = jSONObject4.optBoolean("eventHeaderVisible");
            this.headerLevels = "Auto".equals(jSONObject4.optString("headerLevels")) ? 1 : jSONObject4.optInt("headerLevels");
            this.heightSpec = HeightSpec.parseSoft(jSONObject4.optString("heightSpec"));
            this.hourFontFamily = jSONObject4.optString("hourFontFamily");
            this.hourFontSize = jSONObject4.optString("hourFontSize");
            this.hourFontColor = jSONObject4.optString("hourFontColor");
            this.id = jSONObject4.getString("id");
            this.locale = LocaleParser.isValid(jSONObject4.optString("locale")) ? LocaleParser.parse(jSONObject4.getString("locale")) : this.locale;
            this.nonBusinessBackColor = jSONObject4.optString("nonBusinessBackColor");
            this.selectedEventValue = jSONObject4.optString("selected");
            this.startDate = DateTime.parseString(jSONObject4.getString("startDate"));
            TimeFormat timeFormat = this.timeFormat = TimeFormat.isValid(jSONObject4.optString("timeFormat")) ? TimeFormat.parse(jSONObject4.getString("timeFormat")) : this.timeFormat;
            if ("Auto".equals(jSONObject4.optString("timeHeaderCellDuration"))) {
                this.timeHeaderCellDuration = 60;
                this.timeHeaderCellDuration = this.cellDuration <= 60 ? 60 : this.cellDuration;
            } else {
                this.timeHeaderCellDuration = jSONObject4.optInt("timeHeaderCellDuration");
            }
            this.viewType = ViewType.parseSoft(jSONObject4.optString("viewType"));
            this.weekStarts = WeekStarts.fromStringJavaScript(jSONObject4.isNull("weekStarts") ? null : jSONObject4.optString("weekStarts"));
            this.sanityCheck();
            this.onPrepare();
            if (string.equals("Command")) {
                object2 = CommandArgs.fromJSON(jSONObject2, jSONObject3);
                this.onCommand((CommandArgs)object2);
            } else if (string.equals("Notify")) {
                object2 = NotifyArgs.fromJSON(jSONObject2, jSONObject3);
                this.onNotify((NotifyArgs)object2);
            } else if (string.equals("EventBubble")) {
                this.bubbleGuid = jSONObject2.optString("guid");
                object2 = EventBubbleArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventBubble((EventBubbleArgs)object2);
                this.bubbleResult = new JSONObject();
                this.bubbleResult.put("BubbleHTML", ((EventBubbleArgs)object2).getBubbleHTML());
            } else if (string.equals("Bubble")) {
                object2 = jSONObject2.getJSONObject("args");
                object = ((JSONObject)object2).optString("type");
                if ("Event".equals(object)) {
                    this.bubbleGuid = jSONObject2.optString("guid");
                    EventBubbleArgs eventBubbleArgs = EventBubbleArgs.fromJSON((JSONObject)object2, jSONObject3);
                    this.onEventBubble(eventBubbleArgs);
                    this.bubbleResult = new JSONObject();
                    this.bubbleResult.put("BubbleHTML", eventBubbleArgs.getBubbleHTML());
                } else if ("Resource".equals(object)) {
                    throw new RuntimeException("Resource bubble is not implemented yet.");
                }
            } else if (string.equals("EventClick")) {
                object2 = EventClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventClick((EventClickArgs)object2);
            } else if (string.equals("EventDelete")) {
                object2 = EventDeleteArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventDelete((EventDeleteArgs)object2);
            } else if (string.equals("EventDoubleClick")) {
                object2 = EventDoubleClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventDoubleClick((EventDoubleClickArgs)object2);
            } else if (string.equals("EventEdit")) {
                object2 = EventEditArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventEdit((EventEditArgs)object2);
            } else if (string.equals("EventMenuClick")) {
                object2 = EventMenuClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventMenuClick((EventMenuClickArgs)object2);
            } else if (string.equals("EventMove")) {
                object2 = EventMoveArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventMove((EventMoveArgs)object2);
            } else if (string.equals("EventResize")) {
                object2 = EventResizeArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventResize((EventResizeArgs)object2);
            } else if (string.equals("EventRightClick")) {
                object2 = EventRightClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventRightClick((EventRightClickArgs)object2);
            } else if (string.equals("EventSelect")) {
                object2 = EventSelectArgs.fromJSON(jSONObject3);
                this.onEventSelect((EventSelectArgs)object2);
            } else if (string.equals("Init")) {
                this.onInit();
            } else if (string.equals("HeaderClick")) {
                object2 = HeaderClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onHeaderClick((HeaderClickArgs)object2);
            } else if (string.equals("TimeRangeDoubleClick")) {
                object2 = TimeRangeDoubleClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onTimeRangeDoubleClick((TimeRangeDoubleClickArgs)object2);
            } else if (string.equals("TimeRangeMenuClick")) {
                object2 = TimeRangeMenuClick.fromJSON(jSONObject2, jSONObject3);
                this.onTimeRangeMenuClick((TimeRangeMenuClick)object2);
            } else if (string.equals("TimeRangeSelected")) {
                object2 = TimeRangeSelectedArgs.fromJSON(jSONObject2, jSONObject3);
                this.onTimeRangeSelected((TimeRangeSelectedArgs)object2);
            } else {
                throw new RuntimeException("Unknown callback type.");
            }
            this.onFinish();
            this.sanityCheck();
            this.loadEvents();
            object2 = new JSONObject();
            ((JSONObject)object2).put("UpdateType", (Object)this.getUpdateType());
            ((JSONObject)object2).put("Message", this.updateMessage);
            if (this.bubbleGuid != null) {
                ((JSONObject)object2).put("BubbleGuid", this.bubbleGuid);
                ((JSONObject)object2).put("Result", this.bubbleResult);
                return object2;
            }
            if (this.getUpdateType() != UpdateType.NONE) {
                ((JSONObject)object2).put("Events", this.getEventsJSON());
                ((JSONObject)object2).put("TagFields", this.getDataTagFieldsSplit());
                if (this.sortFields != null) {
                    ((JSONObject)object2).put("SortDirections", this.sortFields.getDirections());
                }
            }
            if (this.getUpdateType() == UpdateType.FULL) {
                object = new CellTable(this);
                ((CellTable)object).process();
                ((JSONObject)object2).put("CellProperties", ((CellTable)object).getProperties());
                ((JSONObject)object2).put("CellConfig", ((CellTable)object).getConfig());
                ((JSONObject)object2).put("Columns", this.getJsonColumns());
                ((JSONObject)object2).put("SelectedEventValue", this.selectedEventValue);
                ((JSONObject)object2).put("Days", this.getDays());
                ((JSONObject)object2).put("CssOnly", this.cssOnly);
                ((JSONObject)object2).put("CssClassPrefix", this.cssClassPrefix);
                ((JSONObject)object2).put("Hours", this.getJsonHours());
                ((JSONObject)object2).put("StartDate", this.getStartDate());
                ((JSONObject)object2).put("CellDuration", this.cellDuration);
                ((JSONObject)object2).put("HeightSpec", (Object)this.heightSpec);
                ((JSONObject)object2).put("BusinessBeginsHour", this.businessBeginsHour);
                ((JSONObject)object2).put("BusinessEndsHour", this.businessEndsHour);
                ((JSONObject)object2).put("ViewType", (Object)this.viewType);
                ((JSONObject)object2).put("DayBeginsHour", this.dayBeginsHour);
                ((JSONObject)object2).put("DayEndsHour", this.dayEndsHour);
                ((JSONObject)object2).put("HeaderLevels", this.headerLevels);
                ((JSONObject)object2).put("BackColor", this.backColor);
                ((JSONObject)object2).put("NonBusinessBackColor", this.nonBusinessBackColor);
                ((JSONObject)object2).put("EventHeaderVisible", this.eventHeaderVisible);
                ((JSONObject)object2).put("TimeFormat", (Object)this.timeFormat);
                ((JSONObject)object2).put("TimeHeaderCellDuration", this.timeHeaderCellDuration);
                ((JSONObject)object2).put("Locale", LocaleFormatter.format(this.locale));
            }
            return object2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void sanityCheck() {
        Ensure.inRange("businessBeginsHour", this.businessBeginsHour, 0, 23);
        Ensure.inRange("businessEndsHour", this.businessEndsHour, 0, 24);
        Ensure.inRange("cellDuration", this.cellDuration, 1, 60);
        Ensure.inRange("dayBeginsHour", this.dayBeginsHour, 0, 23);
        Ensure.inRange("days", this.days, 1, 100);
        Ensure.inRange("headerLevels", this.headerLevels, 1, 10);
        Ensure.inRange("timeHeaderCellDuration", this.timeHeaderCellDuration, 1, 60);
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            httpServletRequest.setCharacterEncoding("UTF-8");
            JSONObject jSONObject = JSONParser.parse(httpServletRequest);
            JSONObject jSONObject2 = this.callback(jSONObject);
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().print(jSONObject2);
            httpServletResponse.getWriter().close();
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected String[] getDataTagFieldsSplit() {
        if (this.dataTagFields == null || "".equals(this.dataTagFields)) {
            return new String[0];
        }
        String[] stringArray = this.dataTagFields.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public String getDataValueField() {
        return this.dataIdField;
    }

    public void setDataValueField(String string) {
        this.dataIdField = string;
    }

    public String getDataTextField() {
        return this.dataTextField;
    }

    public void setDataTextField(String string) {
        this.dataTextField = string;
    }

    public String getDataStartField() {
        return this.dataStartField;
    }

    public void setDataStartField(String string) {
        this.dataStartField = string;
    }

    public String getDataEndField() {
        return this.dataEndField;
    }

    public void setDataEndField(String string) {
        this.dataEndField = string;
    }

    public String getDataResourceField() {
        return this.dataResourceField;
    }

    public void setDataResourceField(String string) {
        this.dataResourceField = string;
    }

    public Collection getEvents() {
        return this.events;
    }

    public void setEvents(Collection<?> collection) {
        this.events = collection;
    }

    public void update(UpdateType updateType) {
        this.updateType = updateType;
    }

    public void update() {
        this.updateType = UpdateType.EVENTS_ONLY;
    }

    public void updateWithMessage(String string, UpdateType updateType) {
        this.updateType = updateType;
        this.updateMessage = string;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(UpdateType updateType) {
        this.updateType = updateType;
    }

    private JSONArray getEventsJSON() {
        JSONArray jSONArray = new JSONArray();
        if (this.events.size() == 0) {
            return jSONArray;
        }
        for (Event event : this.items) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("id", event.getId());
            jSONObject.put("text", event.getText());
            jSONObject.put("start", event.getStart());
            jSONObject.put("end", event.getEnd());
            if (event.getResourceId() != null) {
                jSONObject.put("resource", event.getResourceId());
            }
            if (event.isAllDay()) {
                jSONObject.put("allday", true);
            }
            if (event.isRecurrent()) {
                jSONObject.put("recurrent", true);
                jSONObject.put("recurrentMasterId", event.getRecurrentMasterId());
            }
            if (event.getTags() != null) {
                JSONArray jSONArray2 = new JSONArray();
                for (String string : this.getDataTagFieldsSplit()) {
                    jSONArray2.put(event.getTags().get(string));
                }
                jSONObject.put("tag", jSONArray2);
            }
            if (event.getSort() != null) {
                jSONObject.put("sort", event.getSort());
            }
            this.doBeforeEventRender(jSONObject, event.getSource());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    private void loadEvents() {
        try {
            Object object;
            Object object2;
            this.items = new ArrayList<Event>();
            if (this.events == null) {
                return;
            }
            if (this.events.size() == 0) {
                return;
            }
            ArrayList<RecurEx> arrayList = new ArrayList<RecurEx>();
            ArrayList<RecurEvent> arrayList2 = new ArrayList<RecurEvent>();
            for (Object object4 : this.events) {
                Object object3;
                Object object5;
                String[] stringArray;
                object2 = new EventBean(object4);
                ((EventBean)object2).setUseUtc(this.useUtcDates);
                String string = ((EventBean)object2).getString(this.dataIdField);
                Object object6 = ((EventBean)object2).getString(this.dataTextField);
                object = ((EventBean)object2).getDateTime(this.dataStartField);
                DateTime dateTime = ((EventBean)object2).getDateTime(this.dataEndField);
                boolean bl = false;
                if (this.dataAllDayField != null) {
                    bl = BoolParser.parse(((EventBean)object2).getString(this.dataAllDayField));
                }
                String string2 = null;
                if (this.dataResourceField != null) {
                    string2 = ((EventBean)object2).getString(this.dataResourceField);
                }
                TagCollection tagCollection = null;
                if (this.dataTagFields != null) {
                    stringArray = this.getDataTagFieldsSplit();
                    object5 = new ArrayList();
                    for (String string3 : this.getDataTagFieldsSplit()) {
                        object5.add(((EventBean)object2).getString(string3));
                    }
                    tagCollection = new TagCollection(stringArray, object5.toArray(new String[0]));
                }
                stringArray = null;
                if (this.sortFields != null) {
                    stringArray = new String[this.sortFields.getFields().length];
                    for (int i = 0; i < this.sortFields.getFields().length; ++i) {
                        object3 = ((EventBean)object2).getString(this.sortFields.getFields()[i]);
                        stringArray[i] = DateTime.canParse((String)object3) ? DateTime.parseString((String)object3).toStringSortable() : object6;
                    }
                }
                object5 = new Event((DateTime)object, dateTime, string, (String)object6, string2, tagCollection, stringArray, bl);
                ((Event)object5).setSource(object4);
                if (Str.isNullOrEmpty(this.dataRecurrenceField)) {
                    object3 = this.doBeforeEventRecurrence((Event)object5);
                    if (((BeforeEventRecurrenceArgs)object3).getRule() != null) {
                        RecurEvent recurEvent = RecurEvent.fromRule(((BeforeEventRecurrenceArgs)object3).getRule(), (DateTime)object, dateTime, string, object5);
                        recurEvent.setFirstDayOfWeek(this.getResolvedWeekStart());
                        arrayList2.add(recurEvent);
                    }
                } else {
                    object3 = ((EventBean)object2).getString(this.dataRecurrenceField);
                    RecurInfo recurInfo = RecurInfo.parse((String)object3, string, (DateTime)object, dateTime, object5);
                    switch (recurInfo.getType()) {
                        case DELETED: {
                            arrayList.add((RecurEx)recurInfo);
                            break;
                        }
                        case MODIFIED: {
                            arrayList.add((RecurEx)recurInfo);
                            break;
                        }
                        case EVENT: {
                            arrayList2.add((RecurEvent)recurInfo);
                            break;
                        }
                    }
                    if (recurInfo.getType() != RecurType.NONE) continue;
                }
                this.items.add((Event)object5);
            }
            for (RecurEvent recurEvent : arrayList2) {
                for (RecurEx recurEx : arrayList) {
                    recurEvent.addRecurexSilent(recurEx);
                }
                object2 = (Event)recurEvent.getTag();
                for (Object object6 : recurEvent.occurrences(this.startDate.addDays(this.getDays()))) {
                    object = new Event(((Occurrence)object6).getStart(), ((Occurrence)object6).getEnd(), ((Occurrence)object6).getId(), ((Event)object2).getText(), ((Event)object2).getResourceId(), ((Event)object2).getTags(), ((Event)object2).getSort(), ((Event)object2).isAllDay());
                    if (((Occurrence)object6).isModified()) {
                        object = (Event)((Occurrence)object6).getTag();
                    }
                    ((Event)object).setRecurrentMasterId(((Event)object2).getId());
                    ((Event)object).setRecurrent(true);
                    if (!((Event)object).getEnd().afterOrEqual(this.startDate)) continue;
                    this.items.add((Event)object);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private JSONObject doBeforeHeaderRender(Column column) {
        BeforeHeaderRenderArgs beforeHeaderRenderArgs = new BeforeHeaderRenderArgs(column);
        beforeHeaderRenderArgs.setInnerHTML(Xml.escape(beforeHeaderRenderArgs.getName()));
        try {
            this.onBeforeHeaderRender(beforeHeaderRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("name", beforeHeaderRenderArgs.getName());
        jSONObject.put("id", beforeHeaderRenderArgs.getValue());
        jSONObject.put("toolTip", beforeHeaderRenderArgs.getToolTip());
        jSONObject.put("start", beforeHeaderRenderArgs.getDate());
        jSONObject.put("html", beforeHeaderRenderArgs.getInnerHTML());
        jSONObject.put("backColor", beforeHeaderRenderArgs.getBackgroundColor());
        jSONObject.put("children", this.getJsonColumnCollection(column.getChildren()));
        jSONObject.put("areas", beforeHeaderRenderArgs.getAreas().getJSON());
        return jSONObject;
    }

    private JSONArray getJsonColumnCollection(ColumnCollection columnCollection) {
        JSONArray jSONArray = new JSONArray();
        for (Column column : columnCollection) {
            jSONArray.put(this.doBeforeHeaderRender(column));
        }
        return jSONArray;
    }

    private JSONArray getJsonColumns() {
        return this.getJsonColumnCollection(this.getColumnsResolved());
    }

    private JSONArray getJsonHours() {
        JSONArray jSONArray = new JSONArray();
        int n = (int)Math.floor(this.duration().getTotalHours() * 60.0 / (double)this.timeHeaderCellDuration);
        for (int i = 0; i < n; ++i) {
            TimeSpan timeSpan = TimeSpan.fromMinutes(i * this.timeHeaderCellDuration).add(TimeSpan.fromHours(this.getVisibleStart().getHour()));
            BeforeTimeHeaderRenderArgs beforeTimeHeaderRenderArgs = new BeforeTimeHeaderRenderArgs(timeSpan, timeSpan.add(TimeSpan.fromMinutes(this.timeHeaderCellDuration)));
            if (this.timeHeaderCellDuration == 60) {
                beforeTimeHeaderRenderArgs.setInnerHtml(this.getHourHtml((int)timeSpan.getHours()));
            } else {
                beforeTimeHeaderRenderArgs.setInnerHtml(TimeFormatter.getHourMinutes(timeSpan, this.timeFormat, this.locale));
            }
            this.doBeforeTimeHeaderRender(beforeTimeHeaderRenderArgs);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("start", TimeFormatter.getHourMinutes(beforeTimeHeaderRenderArgs.getStart(), TimeFormat.CLOCK_24_HOURS, Locale.US));
            jSONObject.put("end", TimeFormatter.getHourMinutes(beforeTimeHeaderRenderArgs.getEnd(), TimeFormat.CLOCK_24_HOURS, Locale.US));
            jSONObject.put("html", beforeTimeHeaderRenderArgs.getInnerHtml());
            jSONObject.put("areas", beforeTimeHeaderRenderArgs.getAreas().getJSON());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    private String getHourHtml(int n) {
        boolean bl;
        TimeFormat timeFormat = this.timeFormat.resolve(this.locale);
        if (!this.cssOnly) {
            boolean bl2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<div style='padding:2px; font-family:");
            stringBuilder.append(this.hourFontFamily);
            stringBuilder.append(";font-size:");
            stringBuilder.append(this.hourFontSize);
            stringBuilder.append(";color:");
            stringBuilder.append(this.hourFontColor);
            stringBuilder.append(";' unselectable='on'>");
            boolean bl3 = bl2 = n / 12 == 0;
            if (timeFormat == TimeFormat.CLOCK_12_HOURS && (n %= 12) == 0) {
                n = 12;
            }
            stringBuilder.append(n);
            stringBuilder.append("<span style='font-size:10px; vertical-align: super; ' unselectable='on'>&nbsp;");
            if (timeFormat == TimeFormat.CLOCK_24_HOURS) {
                stringBuilder.append("00");
            } else {
                stringBuilder.append(bl2 ? "AM" : "PM");
            }
            stringBuilder.append("</span>");
            stringBuilder.append("</div>");
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div unselectable='on'>");
        boolean bl4 = bl = n / 12 == 0;
        if (timeFormat == TimeFormat.CLOCK_12_HOURS && (n %= 12) == 0) {
            n = 12;
        }
        stringBuilder.append(n);
        stringBuilder.append("<span class='");
        if (!Str.isNullOrEmpty(this.cssClassPrefix)) {
            stringBuilder.append(this.cssClassPrefix);
            stringBuilder.append("_rowheader_minutes");
        }
        stringBuilder.append("' unselectable='on'>");
        if (timeFormat == TimeFormat.CLOCK_24_HOURS) {
            stringBuilder.append("00");
        } else {
            stringBuilder.append(bl ? "AM" : "PM");
        }
        stringBuilder.append("</span>");
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    TimeSpan duration() {
        int n = 0;
        n = this.heightSpec == HeightSpec.BUSINESS_HOURS_NO_SCROLL ? (this.businessBeginsHour > this.businessEndsHour ? 24 - this.businessBeginsHour + this.businessEndsHour : this.businessEndsHour - this.businessBeginsHour) : 24;
        return TimeSpan.fromHours(n);
    }

    private ColumnCollection getColumnsResolved() {
        if (this.viewType == ViewType.RESOURCES) {
            return this.columns;
        }
        return this.getDaysModeColumns();
    }

    int getColumnCount() {
        if (this.viewType == ViewType.RESOURCES) {
            List<Column> list = this.columns.getColumns(this.headerLevels, true);
            return list.size();
        }
        return this.getColumnsResolved().size();
    }

    public void onInit() throws Exception {
    }

    public void onEventBubble(EventBubbleArgs eventBubbleArgs) throws Exception {
    }

    public void onEventDoubleClick(EventDoubleClickArgs eventDoubleClickArgs) throws Exception {
    }

    public void onTimeRangeMenuClick(TimeRangeMenuClick timeRangeMenuClick) {
    }

    public void onHeaderClick(HeaderClickArgs headerClickArgs) {
    }

    public void onEventSelect(EventSelectArgs eventSelectArgs) {
    }

    public void onEventMenuClick(EventMenuClickArgs eventMenuClickArgs) throws Exception {
    }

    public void onTimeRangeDoubleClick(TimeRangeDoubleClickArgs timeRangeDoubleClickArgs) throws Exception {
    }

    public void onEventRightClick(EventRightClickArgs eventRightClickArgs) throws Exception {
    }

    public void onEventEdit(EventEditArgs eventEditArgs) throws Exception {
    }

    public void onEventClick(EventClickArgs eventClickArgs) throws Exception {
    }

    public void onEventDelete(EventDeleteArgs eventDeleteArgs) throws Exception {
    }

    public void onBeforeHeaderRender(BeforeHeaderRenderArgs beforeHeaderRenderArgs) throws Exception {
    }

    public void onBeforeTimeHeaderRender(BeforeTimeHeaderRenderArgs beforeTimeHeaderRenderArgs) throws Exception {
    }

    public void onEventMove(EventMoveArgs eventMoveArgs) throws Exception {
    }

    public void onEventResize(EventResizeArgs eventResizeArgs) throws Exception {
    }

    public void onCommand(CommandArgs commandArgs) throws Exception {
    }

    public void onNotify(NotifyArgs notifyArgs) throws Exception {
    }

    public void onTimeRangeSelected(TimeRangeSelectedArgs timeRangeSelectedArgs) throws Exception {
    }

    public void onBeforeEventRender(BeforeEventRenderArgs beforeEventRenderArgs) throws Exception {
    }

    public void onBeforeEventRecurrence(BeforeEventRecurrenceArgs beforeEventRecurrenceArgs) throws Exception {
    }

    public void onBeforeCellRender(BeforeCellRenderArgs beforeCellRenderArgs) throws Exception {
    }

    public void onFinish() throws Exception {
    }

    public void onPrepare() throws Exception {
    }

    public DateTime getVisibleStart() {
        DateTime dateTime = this.startDate;
        if (this.heightSpec == HeightSpec.BUSINESS_HOURS_NO_SCROLL) {
            return dateTime.addHours(this.businessBeginsHour);
        }
        return dateTime.addHours(this.dayBeginsHour);
    }

    public DateTime getVisibleEnd() {
        DateTime dateTime = this.getStartDate().addDays(this.getDays());
        if (this.dayBeginsHour > this.dayEndsHour) {
            dateTime.addHours(this.dayEndsHour);
        }
        return dateTime;
    }

    private BeforeEventRecurrenceArgs doBeforeEventRecurrence(Event event) {
        BeforeEventRecurrenceArgs beforeEventRecurrenceArgs = new BeforeEventRecurrenceArgs(event);
        try {
            this.onBeforeEventRecurrence(beforeEventRecurrenceArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return beforeEventRecurrenceArgs;
    }

    private void doBeforeEventRender(JSONObject jSONObject, Object object) {
        BeforeEventRenderArgs beforeEventRenderArgs = new BeforeEventRenderArgs(jSONObject, this.getDataTagFieldsSplit(), object);
        beforeEventRenderArgs.setToolTip(Xml.escape(beforeEventRenderArgs.getText()));
        beforeEventRenderArgs.setInnerHTML(Xml.escape(beforeEventRenderArgs.getText()));
        beforeEventRenderArgs.setDurationBarVisible(true);
        if (this.eventHeaderVisible) {
            beforeEventRenderArgs.setHeaderHTML(TimeFormatter.getHourMinutes(beforeEventRenderArgs.getStart(), this.timeFormat, this.locale));
        }
        try {
            this.onBeforeEventRender(beforeEventRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        jSONObject.put("areas", beforeEventRenderArgs.getAreas().getJSON());
        if (beforeEventRenderArgs.getDurationBarColor() != null) {
            jSONObject.put("barColor", beforeEventRenderArgs.getDurationBarColor());
        }
        if (beforeEventRenderArgs.getDurationBarImageUrl() != null) {
            jSONObject.put("durationBarImageUrl", beforeEventRenderArgs.getDurationBarImageUrl());
        }
        if (!beforeEventRenderArgs.isDurationBarVisible()) {
            jSONObject.put("barHidden", true);
        }
        if (beforeEventRenderArgs.getBackgroundColor() != null) {
            jSONObject.put("backColor", beforeEventRenderArgs.getBackgroundColor());
        }
        if (beforeEventRenderArgs.getInnerHTML() != null) {
            jSONObject.put("html", beforeEventRenderArgs.getInnerHTML());
        }
        if (beforeEventRenderArgs.getToolTip() != null) {
            jSONObject.put("toolTip", beforeEventRenderArgs.getToolTip());
        }
        if (beforeEventRenderArgs.getStaticBubbleHTML() != null) {
            jSONObject.put("bubbleHtml", beforeEventRenderArgs.getStaticBubbleHTML());
        }
        if (beforeEventRenderArgs.getContextMenuClientName() != null) {
            jSONObject.put("contextMenu", beforeEventRenderArgs.getContextMenuClientName());
        }
        if (beforeEventRenderArgs.getCssClass() != null) {
            jSONObject.put("cssClass", beforeEventRenderArgs.getCssClass());
        }
        if (beforeEventRenderArgs.getBackgroundImage() != null) {
            jSONObject.put("backgroundImage", beforeEventRenderArgs.getBackgroundImage());
        }
        if (beforeEventRenderArgs.getBackgroundRepeat() != null) {
            jSONObject.put("backgroundRepeat", beforeEventRenderArgs.getBackgroundRepeat());
        }
        if (beforeEventRenderArgs.getHeaderHTML() != null) {
            jSONObject.put("header", beforeEventRenderArgs.getHeaderHTML());
        }
        if (!beforeEventRenderArgs.isEventClickEnabled()) {
            jSONObject.put("clickDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventResizeEnabled()) {
            jSONObject.put("resizeDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventMoveEnabled()) {
            jSONObject.put("moveDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventDeleteEnabled()) {
            jSONObject.put("deleteDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventRightClickEnabled()) {
            jSONObject.put("rightClickDisabled", true);
        }
    }

    private void doBeforeCellRender(BeforeCellRenderArgs beforeCellRenderArgs) {
        try {
            this.onBeforeCellRender(beforeCellRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void doBeforeTimeHeaderRender(BeforeTimeHeaderRenderArgs beforeTimeHeaderRenderArgs) {
        try {
            this.onBeforeTimeHeaderRender(beforeTimeHeaderRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    CellTableCell getCell(DateTime dateTime, String string) {
        Object object;
        BeforeCellRenderArgs beforeCellRenderArgs = new BeforeCellRenderArgs(dateTime, dateTime.addMinutes(this.cellDuration), string);
        boolean bl = this.isBusinessCell(dateTime);
        beforeCellRenderArgs.setBusiness(bl);
        if (this.cssOnly) {
            beforeCellRenderArgs.setBackgroundColor("");
            this.doBeforeCellRender(beforeCellRenderArgs);
        } else {
            object = beforeCellRenderArgs.isBusiness() ? this.backColor : this.nonBusinessBackColor;
            beforeCellRenderArgs.setBackgroundColor((String)object);
            this.doBeforeCellRender(beforeCellRenderArgs);
            if (beforeCellRenderArgs.getBackgroundColor() == object && beforeCellRenderArgs.isBusiness() != bl) {
                if (beforeCellRenderArgs.isBusiness()) {
                    beforeCellRenderArgs.setBackgroundColor(this.backColor);
                } else {
                    beforeCellRenderArgs.setBackgroundColor(this.nonBusinessBackColor);
                }
            }
        }
        object = new CellTableCell();
        ((CellTableCell)object).setBusiness(beforeCellRenderArgs.isBusiness());
        ((CellTableCell)object).setColor(beforeCellRenderArgs.getBackgroundColor());
        ((CellTableCell)object).setInnerHTML(beforeCellRenderArgs.getInnerHTML());
        ((CellTableCell)object).setBackgroundImage(beforeCellRenderArgs.getBackgroundImage());
        ((CellTableCell)object).setBackgroundRepeat(beforeCellRenderArgs.getBackgroundRepeat());
        ((CellTableCell)object).setBackgroundColor(beforeCellRenderArgs.getBackgroundColor());
        ((CellTableCell)object).setCssClass(beforeCellRenderArgs.getCssClass());
        return object;
    }

    private boolean isBusinessCell(DateTime dateTime) {
        if (this.businessBeginsHour < this.businessEndsHour) {
            return dateTime.getHour() >= this.businessBeginsHour && dateTime.getHour() < this.businessEndsHour && dateTime.getDayOfWeek() != DayOfWeek.SATURDAY && dateTime.getDayOfWeek() != DayOfWeek.SUNDAY;
        }
        if (dateTime.getHour() >= this.businessBeginsHour) {
            return true;
        }
        return dateTime.getHour() < this.businessEndsHour;
    }

    public DateTime getStartDate() {
        switch (this.viewType) {
            case WORKWEEK: {
                return Week.firstWorkingDayOfWeek(this.startDate);
            }
            case WEEK: {
                return Week.firstDayOfWeek(this.startDate, this.getFirstDayOfWeek());
            }
        }
        return this.startDate;
    }

    public void setStartDate(DateTime dateTime) {
        this.startDate = dateTime;
    }

    public int getDays() {
        switch (this.viewType) {
            case DAY: {
                return 1;
            }
            case WORKWEEK: {
                return 5;
            }
            case WEEK: {
                return 7;
            }
        }
        return this.days;
    }

    public void setDays(int n) {
        this.days = n;
    }

    public int getCellDuration() {
        return this.cellDuration;
    }

    public void setCellDuration(int n) {
        this.cellDuration = n;
    }

    public HeightSpec getHeightSpec() {
        return this.heightSpec;
    }

    public void setHeightSpec(HeightSpec heightSpec) {
        this.heightSpec = heightSpec;
    }

    public int getBusinessBeginsHour() {
        return this.businessBeginsHour;
    }

    public void setBusinessBeginsHour(int n) {
        this.businessBeginsHour = n;
    }

    public int getBusinessEndsHour() {
        return this.businessEndsHour;
    }

    public void setBusinessEndsHour(int n) {
        this.businessEndsHour = n;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public int getDayBeginsHour() {
        return this.dayBeginsHour;
    }

    public void setDayBeginsHour(int n) {
        this.dayBeginsHour = n;
    }

    public int getHeaderLevels() {
        return this.headerLevels;
    }

    public void setHeaderLevels(int n) {
        this.headerLevels = n;
    }

    public String getBackColor() {
        return this.backColor;
    }

    public void setBackColor(String string) {
        this.backColor = string;
    }

    public String getNonBusinessBackColor() {
        return this.nonBusinessBackColor;
    }

    public void setNonBusinessBackColor(String string) {
        this.nonBusinessBackColor = string;
    }

    public ColumnCollection getColumns() {
        return this.columns;
    }

    public String getHeaderDateFormat() {
        return this.headerDateFormat;
    }

    public void setHeaderDateFormat(String string) {
        this.headerDateFormat = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getSelectedEventValue() {
        return this.selectedEventValue;
    }

    public String getDataTagFields() {
        return this.dataTagFields;
    }

    public void setDataTagFields(String string) {
        this.dataTagFields = string;
    }

    public String getDataAllDayField() {
        return this.dataAllDayField;
    }

    public void setDataAllDayField(String string) {
        this.dataAllDayField = string;
    }

    public String getId() {
        return this.id;
    }

    public DayOfWeek getFirstDayOfWeek() {
        return DayOfWeek.fromConstant(Calendar.getInstance(this.getLocale()).getFirstDayOfWeek());
    }

    public boolean isEventHeaderVisible() {
        return this.eventHeaderVisible;
    }

    public void setEventHeaderVisible(boolean bl) {
        this.eventHeaderVisible = bl;
    }

    public TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    public int getTimeHeaderCellDuration() {
        return this.timeHeaderCellDuration;
    }

    public void setTimeHeaderCellDuration(int n) {
        this.timeHeaderCellDuration = n;
    }

    public int getDayEndsHour() {
        return this.dayEndsHour;
    }

    public void setDayEndsHour(int n) {
        this.dayEndsHour = n;
    }

    public String getHourFontFamily() {
        return this.hourFontFamily;
    }

    public void setHourFontFamily(String string) {
        this.hourFontFamily = string;
    }

    public String getHourFontSize() {
        return this.hourFontSize;
    }

    public void setHourFontSize(String string) {
        this.hourFontSize = string;
    }

    public boolean isCssOnly() {
        return this.cssOnly;
    }

    public void setCssOnly(boolean bl) {
        this.cssOnly = bl;
    }

    public String getHourFontColor() {
        return this.hourFontColor;
    }

    public void setHourFontColor(String string) {
        this.hourFontColor = string;
    }

    public String getCssClassPrefix() {
        return this.cssClassPrefix;
    }

    public void setCssClassPrefix(String string) {
        this.cssClassPrefix = string;
    }

    Column getColumn(int n) {
        if (this.columns == null) {
            throw new RuntimeException("Columns not initialized.");
        }
        if (this.viewType == ViewType.RESOURCES) {
            List<Column> list = this.columns.getColumns(this.headerLevels, true);
            return list.get(n);
        }
        return (Column)this.getDaysModeColumns().get(n);
    }

    private ColumnCollection getDaysModeColumns() {
        ColumnCollection columnCollection = new ColumnCollection();
        for (int i = 0; i < this.getDays(); ++i) {
            DateTime dateTime = this.getStartDate().addDays(i);
            Column column = new Column(dateTime.toString(this.headerDateFormat, this.locale), null);
            column.setDate(dateTime);
            columnCollection.add(column);
        }
        return columnCollection;
    }

    public boolean isUseUtcDates() {
        return this.useUtcDates;
    }

    public void setUseUtcDates(boolean bl) {
        this.useUtcDates = bl;
    }

    public String getDataRecurrenceField() {
        return this.dataRecurrenceField;
    }

    public void setDataRecurrenceField(String string) {
        this.dataRecurrenceField = string;
    }

    protected DayOfWeek getResolvedWeekStart() {
        switch (this.weekStarts) {
            case SUNDAY: {
                return DayOfWeek.SUNDAY;
            }
            case MONDAY: {
                return DayOfWeek.MONDAY;
            }
            case TUESDAY: {
                return DayOfWeek.TUESDAY;
            }
            case WEDNESDAY: {
                return DayOfWeek.WEDNESDAY;
            }
            case THURSDAY: {
                return DayOfWeek.THURSDAY;
            }
            case FRIDAY: {
                return DayOfWeek.FRIDAY;
            }
            case SATURDAY: {
                return DayOfWeek.SATURDAY;
            }
            case AUTO: {
                return DayOfWeek.getDefaultWeekStart();
            }
        }
        throw new RuntimeException("This weekStarts value is not supported (" + (Object)((Object)this.weekStarts) + ").");
    }

    public WeekStarts getWeekStarts() {
        return this.weekStarts;
    }

    public void setWeekStarts(WeekStarts weekStarts) {
        this.weekStarts = weekStarts;
    }

    public String getEventSortExpression() {
        return this.eventSortExpression;
    }

    public void setEventSortExpression(String string) {
        if (!SortExpression.isValid(string)) {
            throw new IllegalArgumentException("Invalid EventSortExpression format. Valid example: \"start asc, end desc\"");
        }
        this.sortFields = SortExpression.parse(string);
        this.eventSortExpression = string;
    }

    public JSONObject getClientState() {
        return this.clientState;
    }

    public void setClientState(JSONObject jSONObject) {
        this.clientState = jSONObject;
    }
}

