/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.daypilot.data.TagCollection;
import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.date.Week;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONException;
import org.daypilot.json.JSONObject;
import org.daypilot.recurrence.Occurrence;
import org.daypilot.recurrence.RecurEvent;
import org.daypilot.recurrence.RecurEx;
import org.daypilot.recurrence.RecurInfo;
import org.daypilot.recurrence.RecurType;
import org.daypilot.ui.Event;
import org.daypilot.ui.EventBean;
import org.daypilot.ui.JSONParser;
import org.daypilot.ui.SortExpression;
import org.daypilot.ui.Version;
import org.daypilot.ui.args.month.BeforeCellRenderArgs;
import org.daypilot.ui.args.month.BeforeEventRenderArgs;
import org.daypilot.ui.args.month.BeforeHeaderRenderArgs;
import org.daypilot.ui.args.month.CommandArgs;
import org.daypilot.ui.args.month.EventBubbleArgs;
import org.daypilot.ui.args.month.EventClickArgs;
import org.daypilot.ui.args.month.EventDeleteArgs;
import org.daypilot.ui.args.month.EventMenuClickArgs;
import org.daypilot.ui.args.month.EventMoveArgs;
import org.daypilot.ui.args.month.EventResizeArgs;
import org.daypilot.ui.args.month.EventRightClickArgs;
import org.daypilot.ui.args.month.NotifyArgs;
import org.daypilot.ui.args.month.TimeRangeDoubleClickArgs;
import org.daypilot.ui.args.month.TimeRangeMenuClickArgs;
import org.daypilot.ui.args.month.TimeRangeSelectedArgs;
import org.daypilot.ui.args.scheduler.BeforeEventRecurrenceArgs;
import org.daypilot.ui.enums.TimeFormat;
import org.daypilot.ui.enums.UpdateType;
import org.daypilot.ui.enums.WeekStarts;
import org.daypilot.ui.enums.month.ViewType;
import org.daypilot.util.LocaleFormatter;
import org.daypilot.util.LocaleParser;
import org.daypilot.util.Str;
import org.daypilot.util.Xml;

public class DayPilotMonth {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String dataIdField = "id";
    private String dataTextField = "text";
    private String dataStartField = "start";
    private String dataEndField = "end";
    private String dataTagFields;
    private String dataRecurrenceField;
    private boolean useUtcDates = false;
    private Collection<?> events;
    private List<Event> items;
    private UpdateType updateType = UpdateType.NONE;
    private String updateMessage;
    private String eventSortExpression;
    private SortExpression sortFields = new SortExpression();
    private String id;
    private DateTime startDate;
    private DateTime visibleStart;
    private DateTime visibleEnd;
    private Locale locale = Locale.getDefault();
    private TimeFormat timeFormat = TimeFormat.AUTO;
    private JSONObject clientState;
    private WeekStarts weekStarts = WeekStarts.AUTO;
    private boolean showWeekend = true;
    private String headerBackColor;
    private String backColor;
    private String nonBusinessBackColor;
    private int weeks;
    private boolean cssOnly;
    private ViewType viewType;
    private String bubbleGuid;
    private JSONObject bubbleResult;

    public void onEventDelete(EventDeleteArgs eventDeleteArgs) throws Exception {
    }

    public void onTimeRangeMenuClick(TimeRangeMenuClickArgs timeRangeMenuClickArgs) throws Exception {
    }

    public void onTimeRangeDoubleClick(TimeRangeDoubleClickArgs timeRangeDoubleClickArgs) throws Exception {
    }

    public void onEventRightClick(EventRightClickArgs eventRightClickArgs) throws Exception {
    }

    public void onEventMenuClick(EventMenuClickArgs eventMenuClickArgs) throws Exception {
    }

    public void onEventClick(EventClickArgs eventClickArgs) throws Exception {
    }

    public void onCommand(CommandArgs commandArgs) throws Exception {
    }

    public void onNotify(NotifyArgs notifyArgs) throws Exception {
    }

    public void onEventBubble(EventBubbleArgs eventBubbleArgs) throws Exception {
    }

    public void onEventMove(EventMoveArgs eventMoveArgs) throws Exception {
    }

    public void onEventResize(EventResizeArgs eventResizeArgs) throws Exception {
    }

    public void onInit() throws Exception {
    }

    public void onTimeRangeSelected(TimeRangeSelectedArgs timeRangeSelectedArgs) throws Exception {
    }

    public void onFinish() throws Exception {
    }

    public void onPrepare() throws Exception {
    }

    public void onBeforeEventRender(BeforeEventRenderArgs beforeEventRenderArgs) throws Exception {
    }

    public void onBeforeEventRecurrence(BeforeEventRecurrenceArgs beforeEventRecurrenceArgs) throws Exception {
    }

    public void onBeforeCellRender(BeforeCellRenderArgs beforeCellRenderArgs) throws Exception {
    }

    public void onBeforeHeaderRender(BeforeHeaderRenderArgs beforeHeaderRenderArgs) throws Exception {
    }

    private JSONObject callback(JSONObject jSONObject) {
        try {
            Object object;
            String string = jSONObject.getString("action");
            JSONObject jSONObject2 = jSONObject.optJSONObject("parameters");
            JSONObject jSONObject3 = jSONObject.optJSONObject("data");
            JSONObject jSONObject4 = jSONObject.getJSONObject("header");
            Version.check(jSONObject4.optString("v"));
            this.id = jSONObject4.getString("id");
            this.visibleStart = jSONObject4.getDateTime("visibleStart");
            this.visibleEnd = jSONObject4.getDateTime("visibleEnd");
            this.startDate = jSONObject4.getDateTime("startDate");
            this.clientState = jSONObject4.getJSONObject("clientState");
            this.cssOnly = true;
            this.showWeekend = jSONObject4.getBoolean("showWeekend");
            this.locale = LocaleParser.isValid(jSONObject4.optString("locale")) ? LocaleParser.parse(jSONObject4.getString("locale")) : this.locale;
            this.timeFormat = TimeFormat.isValid(jSONObject4.optString("timeFormat")) ? TimeFormat.parse(jSONObject4.getString("timeFormat")) : this.timeFormat;
            this.weekStarts = WeekStarts.fromStringJavaScript(jSONObject4.optString("weekStarts"));
            this.viewType = ViewType.parseSoft(jSONObject4.optString("viewType"));
            this.weeks = jSONObject4.optInt("weeks");
            this.sanityCheck();
            this.onPrepare();
            if (string.equals("Command")) {
                object = CommandArgs.fromJSON(jSONObject2, jSONObject3);
                this.onCommand((CommandArgs)object);
            } else if (string.equals("Notify")) {
                object = NotifyArgs.fromJSON(jSONObject2, jSONObject3);
                this.onNotify((NotifyArgs)object);
            } else if (string.equals("Bubble")) {
                this.bubbleGuid = jSONObject2.optString("guid");
                object = jSONObject2.getJSONObject("args");
                String string2 = ((JSONObject)object).optString("type");
                if ("Event".equals(string2)) {
                    EventBubbleArgs eventBubbleArgs = EventBubbleArgs.fromJSON((JSONObject)object, jSONObject3);
                    this.onEventBubble(eventBubbleArgs);
                    this.bubbleResult = new JSONObject();
                    this.bubbleResult.put("BubbleHTML", eventBubbleArgs.getBubbleHTML());
                } else if ("Resource".equals(string2)) {
                    throw new RuntimeException("Resource bubble is not implemented yet.");
                }
            } else if (string.equals("EventClick")) {
                object = EventClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventClick((EventClickArgs)object);
            } else if (string.equals("EventMenuClick")) {
                object = EventMenuClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventMenuClick((EventMenuClickArgs)object);
            } else if (string.equals("EventMove")) {
                object = EventMoveArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventMove((EventMoveArgs)object);
            } else if (string.equals("EventResize")) {
                object = EventResizeArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventResize((EventResizeArgs)object);
            } else if (string.equals("EventRightClick")) {
                object = EventRightClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventRightClick((EventRightClickArgs)object);
            } else if (string.equals("Init")) {
                this.onInit();
            } else if (string.equals("TimeRangeDoubleClick")) {
                object = TimeRangeDoubleClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onTimeRangeDoubleClick((TimeRangeDoubleClickArgs)object);
            } else if (string.equals("TimeRangeSelected")) {
                object = TimeRangeSelectedArgs.fromJSON(jSONObject2, jSONObject3);
                this.onTimeRangeSelected((TimeRangeSelectedArgs)object);
            } else if (string.equals("TimeRangeMenuClick")) {
                object = TimeRangeMenuClickArgs.fromJSON(jSONObject2, jSONObject3);
                this.onTimeRangeMenuClick((TimeRangeMenuClickArgs)object);
            } else if (string.equals("EventDelete")) {
                object = EventDeleteArgs.fromJSON(jSONObject2, jSONObject3);
                this.onEventDelete((EventDeleteArgs)object);
            }
            this.onFinish();
            this.sanityCheck();
            this.loadEvents();
            object = new JSONObject();
            ((JSONObject)object).put("UpdateType", (Object)this.getUpdateType());
            ((JSONObject)object).put("Message", this.updateMessage);
            if (this.bubbleGuid != null) {
                ((JSONObject)object).put("BubbleGuid", this.bubbleGuid);
                ((JSONObject)object).put("Result", this.bubbleResult);
                return object;
            }
            if (this.getUpdateType() != UpdateType.NONE) {
                ((JSONObject)object).put("Events", this.getEventsJSON());
                ((JSONObject)object).put("TagFields", this.getDataTagFieldsSplit());
                if (this.sortFields != null) {
                    ((JSONObject)object).put("SortDirections", this.sortFields.getDirections());
                }
                ((JSONObject)object).put("StartDate", this.startDate.toStringSortable());
            }
            if (this.getUpdateType() == UpdateType.FULL) {
                ((JSONObject)object).put("HeaderProperties", this.getHeaders());
                ((JSONObject)object).put("CellProperties", this.getCells());
                ((JSONObject)object).put("StartDate", this.startDate);
                ((JSONObject)object).put("ShowWeekend", this.showWeekend);
                ((JSONObject)object).put("HeaderBackColor", this.headerBackColor);
                ((JSONObject)object).put("BackColor", this.backColor);
                ((JSONObject)object).put("NonBusinessBackColor", this.nonBusinessBackColor);
                ((JSONObject)object).put("Locale", LocaleFormatter.format(this.locale));
                ((JSONObject)object).put("TimeFormat", this.timeFormat.resolve(this.locale).toString());
                ((JSONObject)object).put("WeekStarts", this.weekStarts.resolve(this.locale).toInt());
                ((JSONObject)object).put("Weeks", this.weeks);
                ((JSONObject)object).put("ViewType", (Object)this.viewType);
            }
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void sanityCheck() {
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            httpServletRequest.setCharacterEncoding("UTF-8");
            JSONObject jSONObject = JSONParser.parse(httpServletRequest);
            JSONObject jSONObject2 = this.callback(jSONObject);
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().print(jSONObject2);
            httpServletResponse.getWriter().close();
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private JSONArray getCells() {
        int n = this.getRowCount();
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 7; ++j) {
                DateTime dateTime = this.getFirstDay().addDays(i * 7 + j);
                BeforeCellRenderArgs beforeCellRenderArgs = BeforeCellRenderArgs.fromDay(this, dateTime);
                String string = beforeCellRenderArgs.getBackgroundColor();
                boolean bl = beforeCellRenderArgs.isBusiness();
                if (!beforeCellRenderArgs.isBusiness() && !this.showWeekend) continue;
                try {
                    this.onBeforeCellRender(beforeCellRenderArgs);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                if (beforeCellRenderArgs.backgroundColorEquals(string) && beforeCellRenderArgs.isBusiness() != bl) {
                    beforeCellRenderArgs.setBackgroundColor(beforeCellRenderArgs.isBusiness() ? this.getBackColor() : this.getNonBusinessBackColor());
                }
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("business", beforeCellRenderArgs.isBusiness());
                if (!Str.isNullOrEmpty(beforeCellRenderArgs.getHeaderBackColor())) {
                    jSONObject.put("headerBackColor", beforeCellRenderArgs.getHeaderBackColor());
                }
                if (!Str.isNullOrEmpty(beforeCellRenderArgs.getCssClass())) {
                    jSONObject.put("cssClass", beforeCellRenderArgs.getCssClass());
                }
                if (!Str.isNullOrEmpty(beforeCellRenderArgs.getBackgroundColor())) {
                    jSONObject.put("backColor", beforeCellRenderArgs.getBackgroundColor());
                }
                if (!Str.isNullOrEmpty(beforeCellRenderArgs.getBackgroundImage())) {
                    jSONObject.put("backImage", beforeCellRenderArgs.getBackgroundImage());
                }
                if (!Str.isNullOrEmpty(beforeCellRenderArgs.getBackgroundRepeat())) {
                    jSONObject.put("backRepeat", beforeCellRenderArgs.getBackgroundRepeat());
                }
                if (!Str.isNullOrEmpty(beforeCellRenderArgs.getHeaderText())) {
                    jSONObject.put("headerHtml", beforeCellRenderArgs.getHeaderText());
                }
                if (beforeCellRenderArgs.getAreas().size() > 0) {
                    jSONObject.put("areas", beforeCellRenderArgs.getAreas().getJSON());
                }
                jSONArray.put(jSONObject);
            }
        }
        return jSONArray;
    }

    private int getRowCount() {
        if (this.viewType == ViewType.WEEKS) {
            return this.weeks;
        }
        DateTime dateTime = this.getLastVisibleDayOfMonth();
        int n = (int)Math.floor(dateTime.minus(this.getFirstDay()).getTotalDays()) + 1;
        int n2 = (int)Math.ceil((double)n / 7.0);
        return n2;
    }

    private DateTime getLastVisibleDayOfMonth() {
        DateTime dateTime = this.getFirstDayOfMonth().addMonths(1);
        if (this.showWeekend) {
            return dateTime;
        }
        while (this.isWeekend(dateTime)) {
            dateTime = dateTime.addDays(-1);
        }
        return dateTime;
    }

    private JSONArray getHeaders() {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < 7; ++i) {
            boolean bl;
            DateTime dateTime = this.getFirstDay().addDays(i);
            boolean bl2 = bl = dateTime.getDayOfWeek() != DayOfWeek.SATURDAY && dateTime.getDayOfWeek() != DayOfWeek.SUNDAY;
            if (!bl && !this.showWeekend) continue;
            BeforeHeaderRenderArgs beforeHeaderRenderArgs = BeforeHeaderRenderArgs.fromDay(this, dateTime);
            JSONObject jSONObject = this.doBeforeHeaderRender(beforeHeaderRenderArgs);
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    private JSONObject doBeforeHeaderRender(BeforeHeaderRenderArgs beforeHeaderRenderArgs) {
        JSONObject jSONObject = new JSONObject();
        try {
            this.onBeforeHeaderRender(beforeHeaderRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        jSONObject.put("backColor", beforeHeaderRenderArgs.getBackgroundColor());
        jSONObject.put("html", beforeHeaderRenderArgs.getInnerHTML());
        return jSONObject;
    }

    private DateTime getFirstDay() {
        DateTime dateTime;
        DateTime dateTime2 = dateTime = this.viewType == ViewType.MONTH ? this.getFirstDayOfFirstWeek() : Week.firstDayOfWeek(this.startDate, this.getResolvedWeekStart());
        if (this.showWeekend) {
            return dateTime;
        }
        DateTime dateTime3 = this.getFirstDayOfMonth().addMonths(-1);
        DateTime dateTime4 = dateTime.addDays(6);
        while (this.isWeekend(dateTime4)) {
            dateTime4 = dateTime4.addDays(-1);
        }
        if (dateTime4.getMonth() == dateTime3.getMonth()) {
            dateTime = dateTime.addDays(7);
        }
        return dateTime;
    }

    private boolean isWeekend(DateTime dateTime) {
        if (dateTime.getDayOfWeek() == DayOfWeek.SATURDAY) {
            return true;
        }
        return dateTime.getDayOfWeek() == DayOfWeek.SUNDAY;
    }

    private DateTime getFirstDayOfFirstWeek() {
        return Week.firstDayOfWeek(this.getFirstDayOfMonth(), this.getResolvedWeekStart());
    }

    private DayOfWeek getResolvedWeekStart() {
        switch (this.weekStarts) {
            case SUNDAY: {
                return DayOfWeek.SUNDAY;
            }
            case MONDAY: {
                return DayOfWeek.MONDAY;
            }
            case TUESDAY: {
                return DayOfWeek.TUESDAY;
            }
            case WEDNESDAY: {
                return DayOfWeek.WEDNESDAY;
            }
            case THURSDAY: {
                return DayOfWeek.THURSDAY;
            }
            case FRIDAY: {
                return DayOfWeek.FRIDAY;
            }
            case SATURDAY: {
                return DayOfWeek.SATURDAY;
            }
            case AUTO: {
                Calendar calendar = Calendar.getInstance(this.locale);
                return DayOfWeek.fromConstant(calendar.getFirstDayOfWeek());
            }
        }
        throw new IllegalArgumentException("Unrecognized weekStarts value.");
    }

    private DateTime getFirstDayOfMonth() {
        return new DateTime(this.startDate.getYear(), this.startDate.getMonth(), 1);
    }

    private JSONArray getEventsJSON() {
        JSONArray jSONArray = new JSONArray();
        if (this.events.size() == 0) {
            return jSONArray;
        }
        for (Event event : this.items) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("id", event.getId());
            jSONObject.put("text", event.getText());
            jSONObject.put("start", event.getStart());
            jSONObject.put("end", event.getEnd());
            if (event.getResourceId() != null) {
                jSONObject.put("resource", event.getResourceId());
            }
            if (event.isAllDay()) {
                jSONObject.put("allday", true);
            }
            if (event.isRecurrent()) {
                jSONObject.put("recurrent", true);
                jSONObject.put("recurrentMasterId", event.getRecurrentMasterId());
            }
            if (event.getTags() != null) {
                JSONArray jSONArray2 = new JSONArray();
                for (String string : this.getDataTagFieldsSplit()) {
                    jSONArray2.put(event.getTags().get(string));
                }
                jSONObject.put("tag", jSONArray2);
            }
            if (event.getSort() != null) {
                jSONObject.put("sort", event.getSort());
            }
            this.doBeforeEventRender(jSONObject, event.getSource());
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    private void loadEvents() {
        try {
            Object object;
            Object object2;
            this.items = new ArrayList<Event>();
            if (this.events == null) {
                return;
            }
            if (this.events.size() == 0) {
                return;
            }
            ArrayList<RecurEx> arrayList = new ArrayList<RecurEx>();
            ArrayList<RecurEvent> arrayList2 = new ArrayList<RecurEvent>();
            for (Object object4 : this.events) {
                Object object3;
                Object object5;
                String[] stringArray;
                object2 = new EventBean(object4);
                ((EventBean)object2).setUseUtc(this.useUtcDates);
                String string = ((EventBean)object2).getString(this.dataIdField);
                Object object6 = ((EventBean)object2).getString(this.dataTextField);
                object = ((EventBean)object2).getDateTime(this.dataStartField);
                DateTime dateTime = ((EventBean)object2).getDateTime(this.dataEndField);
                boolean bl = false;
                String string2 = null;
                TagCollection tagCollection = null;
                if (this.dataTagFields != null) {
                    stringArray = this.getDataTagFieldsSplit();
                    object5 = new ArrayList();
                    for (String string3 : this.getDataTagFieldsSplit()) {
                        object5.add(((EventBean)object2).getString(string3));
                    }
                    tagCollection = new TagCollection(stringArray, object5.toArray(new String[0]));
                }
                stringArray = null;
                if (this.sortFields != null) {
                    stringArray = new String[this.sortFields.getFields().length];
                    for (int i = 0; i < this.sortFields.getFields().length; ++i) {
                        object3 = ((EventBean)object2).getString(this.sortFields.getFields()[i]);
                        stringArray[i] = DateTime.canParse((String)object3) ? DateTime.parseString((String)object3).toStringSortable() : object6;
                    }
                }
                object5 = new Event((DateTime)object, dateTime, string, (String)object6, string2, tagCollection, stringArray, bl);
                ((Event)object5).setSource(object4);
                if (Str.isNullOrEmpty(this.dataRecurrenceField)) {
                    object3 = this.doBeforeEventRecurrence((Event)object5);
                    if (((BeforeEventRecurrenceArgs)object3).getRule() != null) {
                        RecurEvent recurEvent = RecurEvent.fromRule(((BeforeEventRecurrenceArgs)object3).getRule(), (DateTime)object, dateTime, string, object5);
                        recurEvent.setFirstDayOfWeek(this.getResolvedWeekStart());
                        arrayList2.add(recurEvent);
                    }
                } else {
                    object3 = ((EventBean)object2).getString(this.dataRecurrenceField);
                    RecurInfo recurInfo = RecurInfo.parse((String)object3, string, (DateTime)object, dateTime, object5);
                    switch (recurInfo.getType()) {
                        case DELETED: {
                            arrayList.add((RecurEx)recurInfo);
                            break;
                        }
                        case MODIFIED: {
                            arrayList.add((RecurEx)recurInfo);
                            break;
                        }
                        case EVENT: {
                            arrayList2.add((RecurEvent)recurInfo);
                            break;
                        }
                    }
                    if (recurInfo.getType() != RecurType.NONE) continue;
                }
                this.items.add((Event)object5);
            }
            for (RecurEvent recurEvent : arrayList2) {
                for (RecurEx recurEx : arrayList) {
                    recurEvent.addRecurexSilent(recurEx);
                }
                object2 = (Event)recurEvent.getTag();
                for (Object object6 : recurEvent.occurrences(this.getVisibleEnd())) {
                    object = new Event(((Occurrence)object6).getStart(), ((Occurrence)object6).getEnd(), ((Occurrence)object6).getId(), ((Event)object2).getText(), ((Event)object2).getResourceId(), ((Event)object2).getTags(), ((Event)object2).getSort(), ((Event)object2).isAllDay());
                    if (((Occurrence)object6).isModified()) {
                        object = (Event)((Occurrence)object6).getTag();
                    }
                    ((Event)object).setRecurrentMasterId(((Event)object2).getId());
                    ((Event)object).setRecurrent(true);
                    if (!((Event)object).getEnd().afterOrEqual(this.startDate)) continue;
                    this.items.add((Event)object);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private BeforeEventRecurrenceArgs doBeforeEventRecurrence(Event event) {
        BeforeEventRecurrenceArgs beforeEventRecurrenceArgs = new BeforeEventRecurrenceArgs(event);
        try {
            this.onBeforeEventRecurrence(beforeEventRecurrenceArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return beforeEventRecurrenceArgs;
    }

    private void doBeforeEventRender(JSONObject jSONObject, Object object) {
        BeforeEventRenderArgs beforeEventRenderArgs = new BeforeEventRenderArgs(jSONObject, this.getDataTagFieldsSplit(), object);
        beforeEventRenderArgs.setToolTip(Xml.escape(beforeEventRenderArgs.getText()));
        beforeEventRenderArgs.setInnerHTML(Xml.escape(beforeEventRenderArgs.getText()));
        try {
            this.onBeforeEventRender(beforeEventRenderArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        jSONObject.put("areas", beforeEventRenderArgs.getAreas().getJSON());
        if (beforeEventRenderArgs.getContextMenuClientName() != null) {
            jSONObject.put("contextMenu", beforeEventRenderArgs.getContextMenuClientName());
        }
        if (beforeEventRenderArgs.getInnerHTML() != null) {
            jSONObject.put("html", beforeEventRenderArgs.getInnerHTML());
        }
        if (beforeEventRenderArgs.getBackgroundColor() != null) {
            jSONObject.put("backColor", beforeEventRenderArgs.getBackgroundColor());
        }
        if (beforeEventRenderArgs.getBackgroundImage() != null) {
            jSONObject.put("backImage", beforeEventRenderArgs.getBackgroundImage());
        }
        if (beforeEventRenderArgs.getToolTip() != null) {
            jSONObject.put("toolTip", beforeEventRenderArgs.getToolTip());
        }
        if (beforeEventRenderArgs.getCssClass() != null) {
            jSONObject.put("cssClass", beforeEventRenderArgs.getCssClass());
        }
        if (beforeEventRenderArgs.getStaticBubbleHTML() != null) {
            jSONObject.put("bubbleHtml", beforeEventRenderArgs.getStaticBubbleHTML());
        }
        if (!beforeEventRenderArgs.isEventClickEnabled()) {
            jSONObject.put("clickDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventResizeEnabled()) {
            jSONObject.put("resizeDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventMoveEnabled()) {
            jSONObject.put("moveDisabled", true);
        }
        if (!beforeEventRenderArgs.isEventRightClickEnabled()) {
            jSONObject.put("rightClickDisabled", true);
        }
    }

    private String[] getDataTagFieldsSplit() {
        if (this.dataTagFields == null || "".equals(this.dataTagFields)) {
            return new String[0];
        }
        String[] stringArray = this.dataTagFields.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public String getDataValueField() {
        return this.dataIdField;
    }

    public void setDataValueField(String string) {
        this.dataIdField = string;
    }

    public String getDataTextField() {
        return this.dataTextField;
    }

    public void setDataTextField(String string) {
        this.dataTextField = string;
    }

    public String getDataStartField() {
        return this.dataStartField;
    }

    public void setDataStartField(String string) {
        this.dataStartField = string;
    }

    public String getDataEndField() {
        return this.dataEndField;
    }

    public void setDataEndField(String string) {
        this.dataEndField = string;
    }

    public Collection getEvents() {
        return this.events;
    }

    public void setEvents(Collection collection) {
        this.events = collection;
    }

    public void update(UpdateType updateType) {
        this.updateType = updateType;
    }

    public void update() {
        this.updateType = UpdateType.EVENTS_ONLY;
    }

    public void updateWithMessage(String string) {
        this.updateType = UpdateType.EVENTS_ONLY;
        this.updateMessage = string;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(UpdateType updateType) {
        this.updateType = updateType;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(DateTime dateTime) {
        this.startDate = dateTime;
    }

    public DateTime getVisibleStart() {
        return this.getFirstDay();
    }

    public DateTime getVisibleEnd() {
        if (this.showWeekend) {
            return this.getVisibleStart().addDays(this.getRowCount() * 7);
        }
        if (this.viewType == ViewType.WEEKS) {
            return this.getVisibleStart().addDays(this.weeks * 7 - 2);
        }
        DateTime dateTime = this.getFirstDayOfMonth().addMonths(1).addDays(-1);
        DateTime dateTime2 = Week.firstDayOfWeek(dateTime, this.getResolvedWeekStart());
        if (dateTime2 == dateTime && (dateTime2.getDayOfWeek() == DayOfWeek.SATURDAY || dateTime2.getDayOfWeek() == DayOfWeek.SUNDAY)) {
            dateTime2 = dateTime2.addDays(-7);
        }
        DateTime dateTime3 = dateTime2;
        while (dateTime3.getDayOfWeek() == DayOfWeek.SATURDAY || dateTime3.getDayOfWeek() == DayOfWeek.SUNDAY) {
            dateTime3 = dateTime3.addDays(1);
        }
        return dateTime3.addDays(5);
    }

    public String getEventSortExpression() {
        return this.eventSortExpression;
    }

    public void setEventSortExpression(String string) {
        if (!SortExpression.isValid(string)) {
            throw new IllegalArgumentException("Invalid EventSortExpression format. Valid example: \"start asc, end desc\"");
        }
        this.sortFields = SortExpression.parse(string);
        this.eventSortExpression = string;
    }

    public String getDataTagFields() {
        return this.dataTagFields;
    }

    public void setDataTagFields(String string) {
        this.dataTagFields = string;
    }

    public WeekStarts getWeekStarts() {
        return this.weekStarts;
    }

    public void setWeekStarts(WeekStarts weekStarts) {
        this.weekStarts = weekStarts;
    }

    public boolean isShowWeekend() {
        return this.showWeekend;
    }

    public void setShowWeekend(boolean bl) {
        this.showWeekend = bl;
    }

    public String getHeaderBackColor() {
        return this.headerBackColor;
    }

    public void setHeaderBackColor(String string) {
        this.headerBackColor = string;
    }

    public String getBackColor() {
        return this.backColor;
    }

    public void setBackColor(String string) {
        this.backColor = string;
    }

    public String getNonBusinessBackColor() {
        return this.nonBusinessBackColor;
    }

    public void setNonBusinessBackColor(String string) {
        this.nonBusinessBackColor = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getId() {
        return this.id;
    }

    public TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    public boolean isCssOnly() {
        return this.cssOnly;
    }

    public void setCssOnly(boolean bl) {
        this.cssOnly = bl;
    }

    public boolean isUseUtcDates() {
        return this.useUtcDates;
    }

    public void setUseUtcDates(boolean bl) {
        this.useUtcDates = bl;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public void setWeeks(int n) {
        this.weeks = n;
    }

    public String getDataRecurrenceField() {
        return this.dataRecurrenceField;
    }

    public void setDataRecurrenceField(String string) {
        this.dataRecurrenceField = string;
    }

    public JSONObject getClientState() {
        return this.clientState;
    }

    public void setClientState(JSONObject jSONObject) {
        this.clientState = jSONObject;
    }
}

