/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import org.daypilot.date.DateTime;

public class EventBean {
    private Object bean = null;
    private Hashtable<String, Method> getters = new Hashtable();
    private boolean useUtc = true;
    private Map<String, ?> map = null;

    public EventBean(Object object) throws IntrospectionException {
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            this.map = (Map)object;
        } else {
            PropertyDescriptor[] propertyDescriptorArray;
            this.bean = object;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                Method method = propertyDescriptor.getReadMethod();
                this.getters.put(propertyDescriptor.getName(), method);
            }
        }
    }

    private Object getObject(String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.map != null) {
            return this.getObjectFromMap(string);
        }
        if (this.bean != null) {
            return this.getObjectFromBean(string);
        }
        return null;
    }

    private Object getObjectFromMap(String string) {
        if (!this.map.containsKey(string)) {
            throw new RuntimeException("Key '" + string + "' not found in the supplied Map.");
        }
        return this.map.get(string);
    }

    private Object getObjectFromBean(String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this.getters.get(string);
        if (method == null) {
            throw new RuntimeException("Property '" + string + "' not found in the supplied JavaBean.");
        }
        return this.getters.get(string).invoke(this.bean, new Object[0]);
    }

    public Object get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("property argument cannot be null");
        }
        String string2 = string;
        String string3 = "";
        if (string.contains(".")) {
            int n = string.indexOf(46);
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        try {
            Object object = this.getObject(string2);
            if ("".equals(string3)) {
                return object;
            }
            EventBean eventBean = new EventBean(object);
            return eventBean.get(string3);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getString(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public DateTime getDateTime(String string) {
        return DateTime.parse(this.get(string), !this.useUtc);
    }

    public boolean isNull(String string) {
        return this.get(string) == null;
    }

    public boolean isUseUtc() {
        return this.useUtc;
    }

    public void setUseUtc(boolean bl) {
        this.useUtc = bl;
    }
}

