/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.args.common;

import java.util.ArrayList;
import java.util.List;
import org.daypilot.data.TagCollection;
import org.daypilot.date.DateTime;
import org.daypilot.json.JSONArray;
import org.daypilot.json.JSONObject;

public class EventInfo {
    private String id;
    private String text;
    private DateTime start;
    private DateTime end;
    private String resource;
    private TagCollection tags;
    private boolean isAllDay;
    private String recurrentMasterId;
    private boolean recurrent;

    private EventInfo() {
    }

    private void loadEvent(JSONObject jSONObject) {
        this.id = jSONObject.optString("id");
        if ("".equals(this.id)) {
            this.id = jSONObject.optString("value");
        }
        this.text = jSONObject.getString("text");
        this.start = jSONObject.getDateTime("start");
        this.end = jSONObject.getDateTime("end");
        this.resource = jSONObject.optString("resource");
        this.tags = TagCollection.fromJSON(jSONObject.getJSONObject("tag"));
        this.isAllDay = jSONObject.optBoolean("isAllDay");
        this.recurrentMasterId = jSONObject.optString("recurrentMasterId");
        this.recurrent = this.recurrentMasterId != null;
    }

    public static EventInfo fromJSON(JSONObject jSONObject) {
        EventInfo eventInfo = new EventInfo();
        eventInfo.loadEvent(jSONObject);
        return eventInfo;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.id);
        jSONObject.put("start", this.start.toStringIso8601());
        jSONObject.put("end", this.end.toStringIso8601());
        jSONObject.put("text", this.text);
        jSONObject.put("resource", this.resource);
        jSONObject.put("tags", this.tags.toJSON());
        return jSONObject;
    }

    public static EventInfo create(String string) {
        EventInfo eventInfo = new EventInfo();
        eventInfo.id = string;
        return eventInfo;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public String getResource() {
        return this.resource;
    }

    public TagCollection getTags() {
        return this.tags;
    }

    public boolean isAllDay() {
        return this.isAllDay;
    }

    public String getRecurrentMasterId() {
        return this.recurrentMasterId;
    }

    public static List<EventInfo> listFromJson(JSONArray jSONArray) {
        ArrayList<EventInfo> arrayList = new ArrayList<EventInfo>();
        if (jSONArray == null) {
            return arrayList;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            EventInfo eventInfo = EventInfo.fromJSON(jSONObject);
            arrayList.add(eventInfo);
        }
        return arrayList;
    }

    public boolean isRecurrent() {
        return this.recurrent;
    }

    public boolean isRecurrentException() {
        return this.recurrent && this.id != null;
    }
}

