/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.args.gantt;

import org.daypilot.data.Task;
import org.daypilot.data.TaskCollection;
import org.daypilot.json.JSONObject;
import org.daypilot.ui.enums.gantt.RowMovePosition;

public class RowMoveArgs {
    private JSONObject data;
    private Task source;
    private Task target;
    private RowMovePosition position;
    private TaskCollection tasks;

    private RowMoveArgs() {
    }

    public static RowMoveArgs fromJSON(TaskCollection taskCollection, JSONObject jSONObject, JSONObject jSONObject2) {
        RowMoveArgs rowMoveArgs = new RowMoveArgs();
        rowMoveArgs.data = jSONObject2;
        rowMoveArgs.source = taskCollection.findById(jSONObject.getJSONObject("source").getString("id"));
        rowMoveArgs.target = taskCollection.findById(jSONObject.getJSONObject("target").getString("id"));
        rowMoveArgs.position = RowMovePosition.fromString(jSONObject.getString("position"));
        rowMoveArgs.tasks = taskCollection;
        return rowMoveArgs;
    }

    public JSONObject getData() {
        return this.data;
    }

    public Task getSource() {
        return this.source;
    }

    public Task getTarget() {
        return this.target;
    }

    public RowMovePosition getPosition() {
        return this.position;
    }

    public void move() {
        TaskCollection taskCollection = this.tasks.findParentCollection(this.source);
        TaskCollection taskCollection2 = this.tasks.findParentCollection(this.target);
        int n = taskCollection2.indexOf(this.target);
        switch (this.position) {
            case BEFORE: {
                taskCollection.remove(this.source);
                taskCollection2.add(n, this.source);
                break;
            }
            case AFTER: {
                taskCollection.remove(this.source);
                if (n >= taskCollection2.size() - 1) {
                    taskCollection2.add(this.source);
                    break;
                }
                taskCollection2.add(n + 1, this.source);
                break;
            }
            case CHILD: {
                taskCollection.remove(this.source);
                this.target.getChildren().add(this.source);
                this.target.setExpanded(true);
                break;
            }
            case FORBIDDEN: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown RowMovePosition");
            }
        }
    }
}

