/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.args.month;

import org.daypilot.date.DateTime;
import org.daypilot.date.DayOfWeek;
import org.daypilot.ui.DayPilotMonth;

public class BeforeHeaderRenderArgs {
    private DayOfWeek dayOfWeek;
    private String backgroundColor;
    private String innerHTML;

    private BeforeHeaderRenderArgs() {
    }

    public static BeforeHeaderRenderArgs fromDay(DayPilotMonth dayPilotMonth, DateTime dateTime) {
        BeforeHeaderRenderArgs beforeHeaderRenderArgs = new BeforeHeaderRenderArgs();
        beforeHeaderRenderArgs.dayOfWeek = dateTime.getDayOfWeek();
        if (!dayPilotMonth.isCssOnly()) {
            beforeHeaderRenderArgs.backgroundColor = dayPilotMonth.getHeaderBackColor();
        }
        beforeHeaderRenderArgs.innerHTML = dateTime.toString("EEEE", dayPilotMonth.getLocale());
        return beforeHeaderRenderArgs;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getInnerHTML() {
        return this.innerHTML;
    }
}

