/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.args.scheduler;

import org.daypilot.data.TagCollection;
import org.daypilot.date.DateTime;
import org.daypilot.json.JSONObject;
import org.daypilot.ui.args.common.DayPilotArgs;

public class EventActionArgs
extends DayPilotArgs {
    private String id;
    private String text;
    private DateTime start;
    private DateTime end;
    private String resource;
    private TagCollection tags;
    private String recurrentMasterId;
    private String join;

    protected EventActionArgs() {
    }

    public void loadEvent(JSONObject jSONObject) {
        this.id = jSONObject.isNull("id") ? null : jSONObject.getString("id");
        this.text = jSONObject.getString("text");
        this.start = jSONObject.getDateTime("start");
        this.end = jSONObject.getDateTime("end");
        this.resource = jSONObject.optString("resource");
        this.tags = TagCollection.fromJSON(jSONObject.getJSONObject("tag"));
        this.recurrentMasterId = jSONObject.isNull("recurrentMasterId") ? null : jSONObject.getString("recurrentMasterId");
        this.join = jSONObject.optString("join");
    }

    @Deprecated
    public String getValue() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public String getResource() {
        return this.resource;
    }

    public TagCollection getTags() {
        return this.tags;
    }

    public boolean isRecurrent() {
        return this.recurrentMasterId != null;
    }

    public String getRecurrentMasterId() {
        return this.recurrentMasterId;
    }

    public String getJoin() {
        return this.join;
    }

    public void setJoin(String string) {
        this.join = string;
    }

    public boolean isRecurrentException() {
        return this.isRecurrent() && this.id != null;
    }
}

