/*
 * Decompiled with CFR 0.152.
 */
package org.daypilot.ui.args.scheduler;

import org.daypilot.data.Resource;
import org.daypilot.data.ResourceCollection;
import org.daypilot.json.JSONObject;
import org.daypilot.ui.enums.scheduler.RowMovePosition;

public class RowMoveArgs {
    private JSONObject data;
    private Resource source;
    private Resource target;
    private RowMovePosition position;
    private ResourceCollection resources;

    private RowMoveArgs() {
    }

    public static RowMoveArgs fromJSON(ResourceCollection resourceCollection, JSONObject jSONObject, JSONObject jSONObject2) {
        RowMoveArgs rowMoveArgs = new RowMoveArgs();
        rowMoveArgs.data = jSONObject2;
        rowMoveArgs.source = resourceCollection.findByIndex(jSONObject.getJSONObject("source").getInt("index"));
        rowMoveArgs.target = resourceCollection.findByIndex(jSONObject.getJSONObject("target").getInt("index"));
        rowMoveArgs.position = RowMovePosition.fromString(jSONObject.getString("position"));
        rowMoveArgs.resources = resourceCollection;
        return rowMoveArgs;
    }

    public JSONObject getData() {
        return this.data;
    }

    public RowMovePosition getPosition() {
        return this.position;
    }

    public void move() {
        ResourceCollection resourceCollection = this.resources.findParentCollection(this.source);
        ResourceCollection resourceCollection2 = this.resources.findParentCollection(this.target);
        int n = resourceCollection2.indexOf(this.target);
        switch (this.position) {
            case BEFORE: {
                resourceCollection.remove(this.source);
                resourceCollection2.add(n, this.source);
                break;
            }
            case AFTER: {
                resourceCollection.remove(this.source);
                if (n >= resourceCollection2.size() - 1) {
                    resourceCollection2.add(this.source);
                    break;
                }
                resourceCollection2.add(n + 1, this.source);
                break;
            }
            case CHILD: {
                resourceCollection.remove(this.source);
                this.target.getChildren().add(this.source);
                this.target.setExpanded(true);
                break;
            }
            case FORBIDDEN: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown RowMovePosition");
            }
        }
    }

    public Resource getSource() {
        return this.source;
    }

    public Resource getTarget() {
        return this.target;
    }
}

